/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.network;

import com.hungteen.pvz.register.ParticleRegister;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnParticlePacket {
    private int type;
    private double x;
    private double y;
    private double z;

    public SpawnParticlePacket(int type, double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public SpawnParticlePacket(PacketBuffer buffer) {
        this.type = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.type);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
    }

    public static class Handler {
        public static void onMessage(SpawnParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                int id = message.type;
                IParticleData particle = null;
                if (id == 0) {
                    particle = (IParticleData)ParticleRegister.RED_BOMB.get();
                } else if (id == 1) {
                    particle = (IParticleData)ParticleRegister.MELON_SLICE.get();
                } else if (id == 2) {
                    particle = (IParticleData)ParticleRegister.FROZEN_MELON_SLICE.get();
                } else if (id == 3) {
                    particle = (IParticleData)ParticleRegister.DIRT_BURST_OUT.get();
                } else if (id == 4) {
                    particle = (IParticleData)ParticleRegister.YELLOW_BOMB.get();
                } else if (id == 5) {
                    particle = ParticleTypes.field_197627_t;
                } else if (id == 6) {
                    particle = (IParticleData)ParticleRegister.DIRT_BURST_OUT.get();
                } else if (id == 7) {
                    particle = (IParticleData)ParticleRegister.GREEN_SWEEP.get();
                } else if (id == 8) {
                    particle = (IParticleData)ParticleRegister.YELLOW_BOMB.get();
                } else if (id == 9) {
                    particle = (IParticleData)ParticleRegister.POP_CORN.get();
                }
                if (particle != null) {
                    Minecraft.func_71410_x().field_71441_e.func_195594_a(particle, message.x, message.y, message.z, 0.0, 0.0, 0.0);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

