/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.register;

import com.hungteen.pvz.register.EntitySpawnRegister;
import com.hungteen.pvz.register.StructureRegister;
import com.hungteen.pvz.utils.BiomeUtil;
import com.hungteen.pvz.world.biome.ZenGardenBiome;
import com.hungteen.pvz.world.gen.GenOres;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeRegister {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"pvz");
    public static final RegistryObject<Biome> ZEN_GARDEN = BIOMES.register("zen_garden", () -> ZenGardenBiome.getZenGardenBiome());

    public static void registerBiomes(FMLCommonSetupEvent ev) {
        ev.enqueueWork(() -> BiomeRegister.registerBiome((Biome)ZEN_GARDEN.get(), BiomeManager.BiomeType.WARM, 100, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD));
    }

    private static void registerBiome(Biome biome, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
        BiomeDictionary.addTypes(BiomeUtil.getKey(biome), (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BiomeUtil.getKey(biome), weight));
    }

    public static void biomeModification(BiomeLoadingEvent event) {
        StructureRegister.addStructureToBiome(event);
        EntitySpawnRegister.addEntitySpawnToBiome(event);
        GenOres.addOresToBiomes(event);
    }

    public static Biome makeBiome(Biome.Category category, Biome.RainType rainType, float depth, float scale, float temperature, float downFall, BiomeAmbience effect, MobSpawnInfo mobInfo, BiomeGenerationSettings generateSettings) {
        return new Biome.Builder().func_205419_a(category).func_205415_a(rainType).func_205421_a(depth).func_205420_b(scale).func_205414_c(temperature).func_205417_d(downFall).func_235097_a_(effect).func_242458_a(mobInfo).func_242457_a(generateSettings).func_242455_a();
    }
}

