/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.register;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.creature.FoodieZombieEntity;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.entity.zombie.poolnight.YetiZombieEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.register.BiomeRegister;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.BiomeUtil;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pvz", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntitySpawnRegister {
    public static final EntitySpawnPlacementRegistry.PlacementType IN_SKY = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_in_sky", (world, pos, type) -> world.func_226660_f_(pos) && world.func_175710_j(pos.func_177982_a(0, -5, 0)));
    public static final EntitySpawnPlacementRegistry.PlacementType IN_HIGH_SKY = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_in_sky", (world, pos, type) -> world.func_226660_f_(pos) && world.func_175710_j(pos.func_177982_a(0, -20, 0)));
    public static final EntitySpawnPlacementRegistry.PlacementType ON_SNOW = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_on_snow", (world, pos, type) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC);

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> evt) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.NORMAL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FLAG_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CONEHEAD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.POLE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BUCKETHEAD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SUN.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SunEntity::canSunSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.NEWSPAPER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SCREENDOOR_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FOOTBALL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GIGA_FOOTBALL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DANCING_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BACKUP_DANCER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.OLD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SUNDAY_EDITION_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SNORKEL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.ZOMBONI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BOBSLE_TEAM.get()), (EntitySpawnPlacementRegistry.PlacementType)ON_SNOW, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.ZOMBIE_DOLPHIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoodieZombieEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DOLPHIN_RIDER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FOODIE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoodieZombieEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.LAVA_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CRAZY_DAVE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.PUMPKIN_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TRICK_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.JACK_IN_BOX_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BALLOON_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BalloonZombieEntity::canBalloonSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DIGGER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.POGO_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.YETI_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, YetiZombieEntity::canYetiSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TOMB_STONE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, TombStoneEntity::canTombSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BungeeZombieEntity::canBungeeSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.LADDER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CATAPULT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GARGANTUAR.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SAD_GARGANTUAR.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.PEASHOOTER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.WALLNUT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GATLINGPEA_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TALLNUT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SQUASH_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.JALAPENO_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
    }

    public static void addEntitySpawnToBiome(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (biome == BiomeRegister.ZEN_GARDEN.get()) {
            return;
        }
        RegistryKey<Biome> biomeKey = BiomeUtil.getKey(biome);
        if (BiomeUtil.isOverworld(biomeKey)) {
            if (BiomeUtil.isLand(biomeKey)) {
                EntitySpawnRegister.addSpawnToOverworldLand(event);
                event.getSpawns().func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SUN.get(), 2 * (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.SunSpawnWeight.get(), 1, 1));
                event.getSpawns().func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)EntityRegister.TOMB_STONE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.TombStoneSpawnWeight.get()).intValue(), 1, 1));
            }
            if (BiomeUtil.isDesert(biomeKey)) {
                // empty if block
            }
            if (BiomeUtil.isOcean(biomeKey)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)EntityRegister.FOODIE_ZOMBIE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.FoodieZombieSpawnWeight.get()).intValue(), 1, 1));
            }
            if (BiomeUtil.isPlain(biomeKey)) {
                // empty if block
            }
            if (BiomeUtil.isConiferous(biomeKey)) {
                // empty if block
            }
        }
        if (BiomeUtil.isNether(biomeKey)) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)EntityRegister.LAVA_ZOMBIE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.LavaZombieSpawnWeight.get()).intValue(), 1, 1));
        }
        if (BiomeUtil.isTheEnd(biomeKey)) {
            // empty if block
        }
    }

    private static void addSpawnToOverworldLand(BiomeLoadingEvent event) {
        int p = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.MaxSpawnWeightMultiple.get();
        EntityClassification ee = EntityClassification.MONSTER;
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.YETI_ZOMBIE.get(), 3 * (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.YetiZombieSpawnWeight.get(), 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.NORMAL_ZOMBIE.get(), 100 * p, 1, 2));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.CONEHEAD_ZOMBIE.get(), 50 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.POLE_ZOMBIE.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.BUCKETHEAD_ZOMBIE.get(), 15 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SNORKEL_ZOMBIE.get(), 70 * p, 1, 2));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.ZOMBONI.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.BOBSLE_TEAM.get(), 25 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.LAVA_ZOMBIE.get(), 8 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.PUMPKIN_ZOMBIE.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.TRICK_ZOMBIE.get(), 40 * p, 1, 2));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.NEWSPAPER_ZOMBIE.get(), 60 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.OLD_ZOMBIE.get(), 35 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SUNDAY_EDITION_ZOMBIE.get(), 5 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SCREENDOOR_ZOMBIE.get(), 35 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.FOOTBALL_ZOMBIE.get(), 20 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.DANCING_ZOMBIE.get(), 15 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.GIGA_FOOTBALL_ZOMBIE.get(), 5 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.JACK_IN_BOX_ZOMBIE.get(), 25 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.BALLOON_ZOMBIE.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.DIGGER_ZOMBIE.get(), 20 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.POGO_ZOMBIE.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.BUNGEE_ZOMBIE.get(), 10 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.LADDER_ZOMBIE.get(), 25 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.CATAPULT_ZOMBIE.get(), 25 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.GARGANTUAR.get(), 18 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SAD_GARGANTUAR.get(), 5 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.PEASHOOTER_ZOMBIE.get(), 60 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.WALLNUT_ZOMBIE.get(), 30 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.GATLINGPEA_ZOMBIE.get(), 15 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.TALLNUT_ZOMBIE.get(), 20 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.SQUASH_ZOMBIE.get(), 15 * p, 1, 1));
        event.getSpawns().func_242575_a(ee, new MobSpawnInfo.Spawners((EntityType)EntityRegister.JALAPENO_ZOMBIE.get(), 10 * p, 1, 1));
    }
}

