/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.entity.bullet;

import com.hungteen.pvz.entity.bullet.StarEntity;
import com.hungteen.pvz.model.entity.bullet.StarModel;
import com.hungteen.pvz.render.entity.PVZEntityRender;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarRender
extends PVZEntityRender<StarEntity> {
    private static final ResourceLocation RES1 = StringUtil.prefix("textures/entity/layer/sun_light.png");
    private static final ResourceLocation RES2 = StringUtil.prefix("textures/entity/layer/heal_light.png");

    public StarRender(EntityRendererManager renderManager) {
        super(renderManager, new StarModel());
    }

    public void render(StarEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70126_B, (float)entityIn.field_70177_z) + 180.0f));
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float f = this.getScaleByEntity(entityIn);
        matrixStackIn.func_227862_a_(f, f, f);
        matrixStackIn.func_227861_a_(0.0, -1.501, 0.0);
        ResourceLocation res = entityIn.getStarState() == StarEntity.StarStates.PINK ? RES2 : RES1;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)res, (float)0.0f, (float)0.0f));
        this.model.func_225597_a_((Entity)entityIn, 0.0f, 0.0f, (float)entityIn.field_70173_aa + partialTicks, 0.0f, 0.0f);
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    @Override
    protected float getScaleByEntity(StarEntity entity) {
        if (entity.getStarType() == StarEntity.StarTypes.BIG) {
            return 1.5f;
        }
        if (entity.getStarType() == StarEntity.StarTypes.HUGE) {
            return 2.0f;
        }
        return 0.8f;
    }

    public ResourceLocation getTextureLocation(StarEntity entity) {
        if (entity.getStarState() == StarEntity.StarStates.PINK) {
            return StringUtil.prefix("textures/entity/misc/pink_star.png");
        }
        return StringUtil.prefix("textures/entity/misc/star.png");
    }
}

