/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.entity.plant.assist;

import com.hungteen.pvz.entity.plant.assist.GraveBusterEntity;
import com.hungteen.pvz.model.entity.plant.assist.GraveBusterModel;
import com.hungteen.pvz.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GraveBusterRender
extends PVZPlantRender<GraveBusterEntity> {
    public GraveBusterRender(EntityRendererManager rendererManager) {
        super(rendererManager, new GraveBusterModel(), 0.0f);
    }

    @Override
    protected void scale(GraveBusterEntity entity, MatrixStack matrixStackIn, float partialTickTime) {
        float sz = this.getScaleByEntity(entity);
        matrixStackIn.func_227862_a_(sz, sz, sz);
        if (entity.isEating()) {
            float height = 1.5f;
            float downOffset = (1.0f - (float)entity.getAttackTime() * 1.0f / (float)entity.getAttackCD()) * height;
            matrixStackIn.func_227861_a_(0.0, (double)(-downOffset), 0.0);
        }
    }

    @Override
    public Vector3d getTranslateVec(GraveBusterEntity entity) {
        if (entity.isEating()) {
            float height = 1.5f;
            float downOffset = (1.0f - (float)entity.getAttackTime() * 1.0f / (float)entity.getAttackCD()) * height;
            return new Vector3d(0.0, (double)(-downOffset), 0.0);
        }
        return super.getTranslateVec(entity);
    }

    @Override
    public float getScaleByEntity(GraveBusterEntity entity) {
        return 1.0f;
    }

    public ResourceLocation getTextureLocation(GraveBusterEntity entity) {
        return StringUtil.prefix("textures/entity/plant/assist/grave_buster.png");
    }
}

