/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.layer;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.model.entity.plant.defence.PumpkinModel;
import com.hungteen.pvz.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public class PumpkinLayer<T extends PVZPlantEntity>
extends LayerRenderer<T, EntityModel<T>> {
    private PumpkinModel model = new PumpkinModel();
    private PVZPlantRender<T> plantRender;

    public PumpkinLayer(IEntityRenderer<T, EntityModel<T>> entityRendererIn) {
        super(entityRendererIn);
        if (entityRendererIn instanceof PVZPlantRender) {
            this.plantRender = (PVZPlantRender)entityRendererIn;
        }
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T plant, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((PVZPlantEntity)plant).getPumpkinLife() == 0.0f || plant.func_82150_aj()) {
            return;
        }
        matrixStackIn.func_227860_a_();
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getRenderTexture(plant)));
        if (this.plantRender != null) {
            float scale = 0.6f;
            float plantScale = this.plantRender.getScaleByEntity(plant);
            matrixStackIn.func_227862_a_(scale / plantScale, scale / plantScale, scale / plantScale);
            double offsetH = 1.501;
            matrixStackIn.func_227861_a_(0.0, (double)(plantScale / scale) * offsetH - offsetH, 0.0);
        } else {
            PVZMod.LOGGER.debug("pumpkin render wrong !");
        }
        this.model.render(matrixStackIn, builder, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
    }

    protected ResourceLocation getRenderTexture(T plant) {
        float life = ((PVZPlantEntity)plant).getPumpkinLife();
        if (life > 400.0f) {
            float tmp = life - 400.0f;
            if (tmp > 266.66666f) {
                return StringUtil.prefix("textures/entity/plant/defence/pumpkin4.png");
            }
            if (tmp > 133.33333f) {
                return StringUtil.prefix("textures/entity/plant/defence/pumpkin5.png");
            }
            return StringUtil.prefix("textures/entity/plant/defence/pumpkin6.png");
        }
        if (life > 266.66666f) {
            return StringUtil.prefix("textures/entity/plant/defence/pumpkin1.png");
        }
        if (life > 133.33333f) {
            return StringUtil.prefix("textures/entity/plant/defence/pumpkin2.png");
        }
        return StringUtil.prefix("textures/entity/plant/defence/pumpkin3.png");
    }
}

