/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.structure.zombie;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.StructureRegister;
import com.hungteen.pvz.structure.PVZTemplateComponent;
import com.hungteen.pvz.utils.StringUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BucketHouseComponents {
    public static final ResourceLocation res1 = StringUtil.prefix("zombie_house/bucket_house");

    public static void generate(TemplateManager manager, BlockPos pos1, Rotation rotation, List<StructurePiece> list, Random rand) {
        list.add((StructurePiece)new BucketHouseComponent(manager, res1, pos1, rotation));
    }

    public static class BucketHouseComponent
    extends PVZTemplateComponent {
        private static final IStructurePieceType type = StructureRegister.BUCKET_HOUSE_PIECE;

        public BucketHouseComponent(TemplateManager manager, CompoundNBT nbt) {
            super(type, manager, nbt);
        }

        public BucketHouseComponent(TemplateManager manager, ResourceLocation res, BlockPos pos, Rotation rotation) {
            super(type, manager, res, pos, rotation);
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn, BlockPos blockPos) {
            BlockPos mid = BlockPos.field_177992_a;
            int dx = 6;
            int dz = 5;
            switch (this.field_186169_c) {
                case CLOCKWISE_90: {
                    mid = this.field_186178_c.func_177982_a(-dz, 0, dx);
                    break;
                }
                case CLOCKWISE_180: {
                    mid = this.field_186178_c.func_177982_a(-dx, 0, -dz);
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    mid = this.field_186178_c.func_177982_a(dz, 0, -dx);
                    break;
                }
                default: {
                    mid = this.field_186178_c.func_177982_a(dx, 0, dz);
                }
            }
            int height = chunkGeneratorIn.func_222531_c(mid.func_177958_n(), mid.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), height + 1, this.field_186178_c.func_177952_p());
            return super.func_230383_a_(worldIn, p_230383_2_, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn, blockPos);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("bonus_chest1")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.BUCKET_HOUSE_CHEST, null);
            } else if (function.equals("bonus_chest2")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.BUCKET_HOUSE_CHEST, null);
            } else if (function.equals("spawner")) {
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)te).func_145881_a().func_200876_a(this.getRandomEntityType(rand));
                }
            }
        }

        protected EntityType<?> getRandomEntityType(Random rand) {
            int num = rand.nextInt(3);
            if (num == 0) {
                return (EntityType)EntityRegister.CONEHEAD_ZOMBIE.get();
            }
            if (num == 1) {
                return (EntityType)EntityRegister.POLE_ZOMBIE.get();
            }
            if (num == 2) {
                return (EntityType)EntityRegister.BUCKETHEAD_ZOMBIE.get();
            }
            return null;
        }
    }
}

