/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.tileentity;

import com.hungteen.pvz.entity.drop.JewelEntity;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.gui.container.SlotMachineContainer;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.register.TileEntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.ItemStackHandler;

public class SlotMachineTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final List<SlotOptions> OPTION_LIST = new ArrayList<SlotOptions>();
    public static final List<Integer> WEIGHT_LIST = new ArrayList<Integer>();
    public static final Map<SlotOptions, Integer> OPTION_MAP = new HashMap<SlotOptions, Integer>();
    public static int sum = 0;
    public static final int SUN_COST = 25;
    private final List<SlotOptions> currentList = new ArrayList<SlotOptions>();
    public final ItemStackHandler handler = new ItemStackHandler(3);
    public final IIntArray array = new IntArray(16);
    public SlotOptions[][] slotOptions = new SlotOptions[4][3];
    public int currentPos = 1;
    private final int minChangeCnt = 15;
    private final int maxChangeCnt = 25;
    private int changeCnt;
    private int changeTick = 0;
    private boolean isRunning = false;
    private PlayerEntity player;

    private static void putOptionToMap(SlotOptions option) {
        OPTION_MAP.put(option, OPTION_LIST.size());
        OPTION_LIST.add(option);
        WEIGHT_LIST.add(sum += option.weight);
    }

    public SlotMachineTileEntity() {
        super((TileEntityType)TileEntityRegister.SLOT_MACHINE.get());
        Random rand = new Random();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slotOptions[i][j] = OPTION_LIST.get(rand.nextInt(OPTION_LIST.size()));
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int id = i * 3 + j;
                    this.array.func_221477_a(id, OPTION_MAP.get(this.slotOptions[i][j]).intValue());
                }
            }
            this.array.func_221477_a(12, this.changeTick);
            this.array.func_221477_a(13, this.currentPos);
            this.array.func_221477_a(14, this.canRun() ? 1 : 0);
            this.array.func_221477_a(15, this.getChangeTick());
            if (this.changeTick > 0) {
                if (this.currentList.isEmpty()) {
                    this.changeTick = 0;
                    this.changeCnt = 0;
                    return;
                }
                --this.changeTick;
                if (this.changeTick == 0) {
                    --this.changeCnt;
                    if (this.changeCnt == 0) {
                        this.checkResult();
                    } else {
                        this.genNextRow();
                    }
                }
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            }
        }
    }

    private void checkResult() {
        this.isRunning = false;
        int leftId = OPTION_MAP.get(this.slotOptions[this.currentPos][0]);
        int midId = OPTION_MAP.get(this.slotOptions[this.currentPos][1]);
        int rightId = OPTION_MAP.get(this.slotOptions[this.currentPos][2]);
        if (leftId != midId && midId != rightId && leftId != rightId) {
            return;
        }
        if (leftId == midId && midId == rightId) {
            this.genBonusResult(leftId, 3);
        } else if (leftId == midId) {
            this.genBonusResult(leftId, 1);
        } else if (leftId == rightId) {
            this.genBonusResult(leftId, 1);
        } else if (rightId == midId) {
            this.genBonusResult(rightId, 1);
        }
    }

    private void genBonusResult(int type, int num) {
        SlotOptions option = OPTION_LIST.get(type);
        if (option.isSun) {
            int cnt = num == 1 ? 4 : 20;
            for (int i = 0; i < cnt; ++i) {
                SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_145850_b);
                sun.setAmount(25);
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_145850_b, sun, this.field_174879_c, 2);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegister.JEWEL_DROP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return;
        }
        for (int i = 0; i < num; ++i) {
            if (option.isJewel) {
                JewelEntity jewel = (JewelEntity)((EntityType)EntityRegister.JEWEL.get()).func_200721_a(this.field_145850_b);
                jewel.setAmount(1);
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_145850_b, jewel, this.field_174879_c, 2);
                continue;
            }
            if (!option.plantType.isPresent()) continue;
            Plants plant = option.plantType.get();
            PlantCardItem item = PlantUtil.getPlantEnjoyCard(plant);
            this.handler.setStackInSlot(i, new ItemStack((IItemProvider)item));
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegister.JEWEL_DROP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void genNextRow() {
        this.changeTick = this.getChangeTick();
        this.currentPos = (this.currentPos + 1) % 4;
        int next = (this.currentPos + 1) % 4;
        for (int i = 0; i < 3; ++i) {
            this.slotOptions[next][i] = this.currentList.get(this.field_145850_b.field_73012_v.nextInt(this.currentList.size()));
        }
    }

    public void startRun(PlayerEntity player) {
        if (player == null) {
            System.out.println("Error : No player bind with Slot Machine !");
            return;
        }
        this.player = player;
        this.isRunning = true;
        PlayerUtil.playClientSound(player, 8);
        PlayerUtil.addPlayerStats(player, Resources.SUN_NUM, -25);
        PlayerUtil.addPlayerStats(player, Resources.LOTTERY_CHANCE, -1);
        this.changeCnt = this.field_145850_b.field_73012_v.nextInt(this.maxChangeCnt - this.minChangeCnt + 1) + this.minChangeCnt;
        this.refreshOptionList();
        this.genNextRow();
    }

    private void refreshOptionList() {
        this.currentList.clear();
        this.currentList.add(OPTION_LIST.get(0));
        int len = this.field_145850_b.field_73012_v.nextInt(5) + 9;
        block0: for (int i = 0; i < len; ++i) {
            int now = this.field_145850_b.field_73012_v.nextInt(sum);
            for (int j = 0; j < OPTION_LIST.size(); ++j) {
                if (now >= WEIGHT_LIST.get(j)) continue;
                this.currentList.add(OPTION_LIST.get(j));
                continue block0;
            }
        }
    }

    public int getChangeTick() {
        if (this.changeCnt <= 2) {
            return 16;
        }
        if (this.changeCnt <= 5) {
            return 12;
        }
        if (this.changeCnt <= 12) {
            return 8;
        }
        return 4;
    }

    private boolean canRun() {
        for (int i = 0; i < 3; ++i) {
            if (this.handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return !this.isRunning;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.func_174877_v()), pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        for (int i = 0; i < 16; ++i) {
            if (!tag.func_74764_b("slot_machine_" + i)) continue;
            this.array.func_221477_a(i, tag.func_74762_e("slot_machine_" + i));
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compoundNBT = super.func_189517_E_();
        for (int i = 0; i < 16; ++i) {
            compoundNBT.func_74768_a("slot_machine_" + i, this.array.func_221476_a(i));
        }
        return compoundNBT;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("change_tick")) {
            this.changeTick = compound.func_74762_e("change_tick");
        }
        if (compound.func_74764_b("change_cnt")) {
            this.changeCnt = compound.func_74762_e("change_cnt");
        }
        if (compound.func_74764_b("is_machine_running")) {
            this.isRunning = compound.func_74767_n("is_machine_running");
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!compound.func_74764_b("slot_option" + (i * 3 + j))) continue;
                this.slotOptions[i][j] = OPTION_LIST.get(compound.func_74762_e("slot_option" + (i * 3 + j)));
            }
        }
        if (compound.func_74764_b("slot_machine_result")) {
            this.handler.deserializeNBT(compound.func_74775_l("slot_machine_result"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("change_tick", this.changeTick);
        compound.func_74768_a("change_cnt", this.changeCnt);
        compound.func_74757_a("is_machine_running", this.isRunning);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                compound.func_74768_a("slot_option" + (i * 3 + j), OPTION_MAP.get(this.slotOptions[i][j]).intValue());
            }
        }
        compound.func_218657_a("slot_machine_result", (INBT)this.handler.serializeNBT());
        return super.func_189515_b(compound);
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SlotMachineContainer(id, player, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.pvz.slot_machine");
    }

    static {
        SlotMachineTileEntity.putOptionToMap(new SlotOptions(1, 2));
        SlotMachineTileEntity.putOptionToMap(new SlotOptions(2, 1));
        for (Plants plant : Plants.values()) {
            Ranks rank = PlantUtil.getPlantRankByName(plant);
            SlotMachineTileEntity.putOptionToMap(new SlotOptions(plant, (Ranks.values().length - rank.ordinal()) / 2 + 1));
        }
    }

    public static class SlotOptions {
        public final Optional<Plants> plantType;
        public final boolean isSun;
        public final boolean isJewel;
        public final int weight;

        public SlotOptions(int type, int weight) {
            this.plantType = Optional.empty();
            this.isSun = type == 1;
            this.isJewel = type == 2;
            this.weight = weight;
        }

        public SlotOptions(Plants plant, int weight) {
            this.plantType = Optional.of(plant);
            this.isSun = false;
            this.isJewel = false;
            this.weight = weight;
        }
    }
}

