/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.tileentity;

import com.hungteen.pvz.entity.drop.DropEntity;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.gui.container.SunConverterContainer;
import com.hungteen.pvz.item.tool.SunStorageSaplingItem;
import com.hungteen.pvz.register.TileEntityRegister;
import com.hungteen.pvz.utils.MathUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class SunConverterTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public final ItemStackHandler handler = new ItemStackHandler(9);
    public final IIntArray array = new IntArray(1);
    private final Set<SunEntity> sunSet = new HashSet<SunEntity>();
    private final int MaxSearchTick = 60;
    private final double MaxSearchRange = 10.0;
    private int absorbPos = -1;
    public int tickExist = 0;

    public SunConverterTileEntity() {
        super((TileEntityType)TileEntityRegister.SUN_CONVERTER.get());
    }

    public void func_73660_a() {
        ++this.tickExist;
        this.tickSunSet();
        if (!this.field_145850_b.field_72995_K) {
            this.array.func_221477_a(0, this.checkCanWorkNow() ? 1 : 0);
        }
    }

    private void tickSunSet() {
        if (!this.field_145850_b.field_72995_K) {
            HashSet tmp = new HashSet();
            this.sunSet.forEach(sun -> {
                if (sun != null && !sun.field_70128_L && sun.getDropState() == DropEntity.DropStates.ABSORB) {
                    tmp.add(sun);
                }
            });
            this.sunSet.clear();
            this.sunSet.addAll(tmp);
            tmp.clear();
            if (!this.checkCanWorkNow()) {
                this.sunSet.forEach(sun -> sun.setDropState(DropEntity.DropStates.NORMAL));
                this.sunSet.clear();
                return;
            }
            if (this.tickExist % this.MaxSearchTick == 0) {
                this.field_145850_b.func_175647_a(SunEntity.class, MathUtil.getAABBWithPos(this.field_174879_c, 10.0), sun -> sun.getDropState() == DropEntity.DropStates.NORMAL && !this.sunSet.contains(sun)).forEach(sun -> {
                    sun.setDropState(DropEntity.DropStates.ABSORB);
                    this.sunSet.add((SunEntity)((Object)sun));
                });
            }
            this.sunSet.forEach(sun -> {
                if (!this.checkCanWorkNow()) {
                    return;
                }
                double speed = 0.15;
                Vector3d now = new Vector3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
                Vector3d vec = now.func_178788_d(sun.func_213303_ch());
                if (vec.func_72433_c() <= 1.0) {
                    this.onCollectSun((SunEntity)((Object)sun));
                } else {
                    sun.func_213317_d(vec.func_72432_b().func_186678_a(speed));
                }
            });
        }
    }

    private void onCollectSun(SunEntity sun) {
        int amount = sun.getAmount();
        while (this.checkCanWorkNow() && amount > 0) {
            ItemStack stack = this.handler.getStackInSlot(this.absorbPos);
            if (!(stack.func_77973_b() instanceof SunStorageSaplingItem)) {
                return;
            }
            SunStorageSaplingItem item = (SunStorageSaplingItem)stack.func_77973_b();
            int max = item.MAX_STORAGE_NUM;
            int now = SunStorageSaplingItem.getStorageSunAmount(stack);
            if (now + amount > max) {
                amount -= max - now;
                now = max;
            } else {
                now += amount;
                amount = 0;
            }
            SunStorageSaplingItem.setStorageSunAmount(stack, now);
        }
        if (amount > 0) {
            sun.setAmount(amount);
        } else {
            sun.func_70106_y();
        }
    }

    private boolean checkCanWorkNow() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (SunStorageSaplingItem.isSunStorageFull(stack)) continue;
            this.absorbPos = i;
            return true;
        }
        return false;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.handler.deserializeNBT(compound.func_74775_l("itemstack_list"));
        this.tickExist = compound.func_74762_e("exist_tick");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("itemstack_list", (INBT)this.handler.serializeNBT());
        compound.func_74768_a("exist_tick", this.tickExist);
        return super.func_189515_b(compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SunConverterContainer(id, player, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.pvz.sun_converter");
    }
}

