/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.PVZMultiPartEntity;
import com.hungteen.pvz.entity.npc.CrazyDaveEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.network.SpawnParticlePacket;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.utils.interfaces.IGroupEntity;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityUtil {
    public static final Random RAND = new Random();

    public static boolean canEntityBeRemoved(Entity entity) {
        if (entity instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)entity).canZombieBeRemoved();
        }
        return entity.func_184222_aU();
    }

    public static void spawnParticle(Entity entity, int type) {
        PVZPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 40.0, entity.field_70170_p.func_234923_W_())), (Object)new SpawnParticlePacket(type, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
    }

    public static boolean canDestroyBlock(World world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.func_180495_p(pos), entity);
    }

    public static void playSound(Entity entity, SoundEvent ev) {
        if (ev != null) {
            entity.func_184185_a(ev, 1.0f, RAND.nextFloat() * 0.2f + 0.9f);
        }
    }

    public static boolean isEntityValid(Entity target) {
        return target != null && target.func_70089_S();
    }

    public static List<LivingEntity> getRandomLivingInRange(World world, LivingEntity attacker, AxisAlignedBB aabb, int cnt) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity living : world.func_175647_a(LivingEntity.class, aabb, target -> EntityUtil.checkCanEntityTarget((Entity)attacker, target))) {
            list.add(living);
            if (--cnt > 0) continue;
            break;
        }
        return list;
    }

    public static float getCurrentHealth(LivingEntity target) {
        if (target instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)target).getCurrentHealth();
        }
        if (target instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)target).getCurrentHealth();
        }
        return target.func_110143_aJ();
    }

    public static float getCurrentMaxHealth(LivingEntity target) {
        if (target instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)target).getCurrentMaxHealth();
        }
        if (target instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)target).getCurrentMaxHealth();
        }
        return target.func_110138_aP();
    }

    public static boolean checkCanSeeEntity(Entity entity, Entity target) {
        Vector3d start = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vector3d lowerEnd = target.func_213303_ch();
        Vector3d upperEnd = lowerEnd.func_72441_c(0.0, (double)target.func_213302_cg(), 0.0);
        RayTraceContext ray1 = new RayTraceContext(start, lowerEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        RayTraceContext ray2 = new RayTraceContext(start, upperEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        return entity.field_70170_p.func_217299_a(ray1).func_216346_c() != RayTraceResult.Type.BLOCK || entity.field_70170_p.func_217299_a(ray2).func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    public static boolean canDestroyBlock(World world, BlockPos pos, BlockState state, Entity entity) {
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.func_177230_c().isAir(state, (IBlockReader)world, pos) && state.func_177230_c().canEntityDestroy(state, (IBlockReader)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static void onMobEntitySpawn(IWorld world, MobEntity entity, BlockPos pos) {
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
        world.func_217376_c((Entity)entity);
    }

    public static void onEntitySpawn(IWorld world, Entity entity, BlockPos pos) {
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        world.func_217376_c(entity);
    }

    public static void onMobEntityRandomPosSpawn(IWorld world, MobEntity entity, BlockPos pos, int dis) {
        pos = pos.func_177982_a(entity.func_70681_au().nextInt(dis * 2 + 1) - dis, entity.func_70681_au().nextInt(dis) + 1, entity.func_70681_au().nextInt(dis * 2 + 1) - dis);
        EntityUtil.onMobEntitySpawn(world, entity, pos);
    }

    public static boolean isOnGround(Entity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        return !entity.field_70170_p.func_175623_d(pos) && entity.func_226278_cu_() - (double)pos.func_177956_o() <= 1.00001;
    }

    public static boolean isOnSnow(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        return entity.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE || entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC;
    }

    public static boolean isSuitableTargetInRange(MobEntity entity, @Nonnull LivingEntity target, double range) {
        return entity.func_70068_e((Entity)target) > EntityUtil.getAttackRange((Entity)entity, (Entity)target, range) && EntityUtil.checkCanEntityAttack((Entity)entity, (Entity)target);
    }

    public static double getAttackRange(Entity a, Entity b, double r) {
        double two = Math.sqrt(2.0);
        double dis = (double)a.func_213311_cf() / two + (double)b.func_213311_cf() / two + r;
        return dis * dis;
    }

    public static double getNearestDistance(Entity a, Entity b) {
        double dx = a.func_226277_ct_() - b.func_226277_ct_();
        double dz = a.func_226281_cx_() - b.func_226281_cx_();
        double dy = 0.0;
        if (a.func_226278_cu_() > b.func_226278_cu_() + (double)b.func_213302_cg()) {
            dy = a.func_226278_cu_() - b.func_226278_cu_() - (double)b.func_213302_cg();
        } else if (b.func_226278_cu_() > a.func_226278_cu_() + (double)a.func_213302_cg()) {
            dy = b.func_226278_cu_() - a.func_226278_cu_() - (double)a.func_213302_cg();
        }
        return dx * dx + dy * dy + dz * dz;
    }

    @Nullable
    public static PlayerEntity getEntityOwner(World world, Entity entity) {
        if (entity == null) {
            return null;
        }
        UUID uuid = null;
        if (entity instanceof PVZPlantEntity) {
            uuid = ((PVZPlantEntity)entity).getOwnerUUID().orElse(null);
        } else if (entity instanceof PVZZombieEntity) {
            uuid = ((PVZZombieEntity)entity).getOwnerUUID().orElse(null);
        }
        return uuid == null ? null : world.func_217371_b(uuid);
    }

    public static boolean checkCanEntityTarget(Entity attacker, LivingEntity target) {
        if (attacker instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)attacker).checkCanZombieTarget(target);
        }
        if (attacker instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)attacker).checkCanPlantTarget(target);
        }
        return EntityUtil.checkCanEntityAttack(attacker, (Entity)target);
    }

    public static boolean checkCanEntityAttack(Entity attacker, Entity target) {
        int targetGroup;
        int attackerGroup;
        if (target instanceof PVZMultiPartEntity) {
            target = ((PVZMultiPartEntity)target).getOwner();
        }
        if (attacker == null || target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        World world = attacker.field_70170_p;
        if (target instanceof PlayerEntity && (((PlayerEntity)target).func_184812_l_() || target.func_175149_v())) {
            return false;
        }
        if (((Boolean)PVZConfig.COMMON_CONFIG.EntitySettings.TeamAttack.get()).booleanValue()) {
            Team team1 = EntityUtil.getEntityTeam(world, attacker);
            Team team2 = EntityUtil.getEntityTeam(world, target);
            if (team1 != null && team2 != null) {
                boolean change = EntityUtil.isEntityCharmed(attacker) ^ EntityUtil.isEntityCharmed(target);
                return change ? team1.func_142054_a(team2) : !team1.func_142054_a(team2);
            }
        }
        return (attackerGroup = EntityUtil.getEntityGroup(attacker)) * (targetGroup = EntityUtil.getEntityGroup(target)) < 0;
    }

    public static int getEntityGroup(Entity entity) {
        int group = 0;
        if (entity instanceof PlayerEntity) {
            return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.PlayerOriginGroup.get();
        }
        if (entity instanceof PVZPlantEntity) {
            group = ((PVZPlantEntity)entity).isCharmed() ? -1 : 1;
        } else if (entity instanceof CrazyDaveEntity) {
            group = 1;
        } else if (entity instanceof IMob) {
            group = -1;
            if (entity instanceof PVZZombieEntity) {
                group = ((PVZZombieEntity)entity).isCharmed() ? 1 : -1;
            }
        } else {
            if (entity instanceof IGroupEntity) {
                return ((IGroupEntity)entity).getEntityGroupType();
            }
            if (entity instanceof GolemEntity) {
                return 1;
            }
        }
        return group;
    }

    public static Team getEntityTeam(World world, Entity entity) {
        if (entity instanceof PlayerEntity) {
            return entity.func_96124_cp();
        }
        if (entity instanceof PVZPlantEntity && ((PVZPlantEntity)entity).getOwnerUUID().isPresent()) {
            PlayerEntity player = world.func_217371_b(((PVZPlantEntity)entity).getOwnerUUID().get());
            return player == null ? null : player.func_96124_cp();
        }
        if (entity instanceof PVZZombieEntity && ((PVZZombieEntity)entity).getOwnerUUID().isPresent()) {
            PlayerEntity player = world.func_217371_b(((PVZZombieEntity)entity).getOwnerUUID().get());
            return player == null ? null : player.func_96124_cp();
        }
        return entity.func_96124_cp();
    }

    public static boolean isEntityCharmed(Entity entity) {
        if (entity instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)entity).isCharmed();
        }
        if (entity instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)entity).isCharmed();
        }
        return false;
    }

    public static List<LivingEntity> getEntityTargetableEntity(Entity attacker, AxisAlignedBB aabb) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : attacker.field_70170_p.func_217357_a(LivingEntity.class, aabb)) {
            if (attacker == entity || !EntityUtil.checkCanEntityTarget(attacker, entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<Entity> getEntityAttackableTarget(Entity attacker, AxisAlignedBB aabb) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (attacker == null) {
            return list;
        }
        for (Entity entity : attacker.field_70170_p.func_217357_a(Entity.class, aabb)) {
            if (attacker == entity || !EntityUtil.checkCanEntityAttack(attacker, entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<LivingEntity> getViewableTargetableEntity(Entity attacker, AxisAlignedBB aabb) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : attacker.field_70170_p.func_217357_a(LivingEntity.class, aabb)) {
            if (attacker == entity || !EntityUtil.checkCanSeeEntity(attacker, (Entity)entity) || !EntityUtil.checkCanEntityTarget(attacker, entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<Entity> getAttackEntities(Entity attacker, AxisAlignedBB aabb) {
        IntOpenHashSet set = new IntOpenHashSet();
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (attacker == null) {
            return list;
        }
        List<Entity> targets = EntityUtil.getEntityAttackableTarget(attacker, aabb);
        targets.forEach(target -> {
            if (!(target instanceof PVZMultiPartEntity) && !set.contains(target.func_145782_y())) {
                set.addAll(EntityUtil.getOwnerAndPartsID(target));
                list.add((Entity)target);
            }
        });
        targets.forEach(target -> {
            if (!set.contains(target.func_145782_y())) {
                set.addAll(EntityUtil.getOwnerAndPartsID(target));
                list.add((Entity)target);
            }
        });
        return list;
    }

    public static List<Integer> getOwnerAndPartsID(Entity entity) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (entity instanceof PVZMultiPartEntity) {
            LivingEntity owner = ((PVZMultiPartEntity)entity).getOwner();
            if (owner == null) {
                list.add(entity.func_145782_y());
            } else {
                IMultiPartEntity parent = ((PVZMultiPartEntity)entity).getParent();
                for (PVZMultiPartEntity target : parent.getMultiParts()) {
                    if (target == null) continue;
                    list.add(target.func_145782_y());
                }
                list.add(owner.func_145782_y());
            }
        } else if (entity instanceof IMultiPartEntity) {
            for (PVZMultiPartEntity target : ((IMultiPartEntity)entity).getMultiParts()) {
                if (target == null) continue;
                list.add(target.func_145782_y());
            }
            list.add(entity.func_145782_y());
        } else {
            list.add(entity.func_145782_y());
        }
        return list;
    }

    public static void addEntityPotionEffect(Entity entity, EffectInstance effect) {
        if (entity instanceof PVZMultiPartEntity) {
            EntityUtil.addEntityPotionEffect((Entity)((PVZMultiPartEntity)entity).getOwner(), effect);
        } else if (entity instanceof PVZZombieEntity) {
            ((PVZZombieEntity)entity).checkAndAddPotionEffect(effect);
        } else if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(effect);
        }
    }

    public static boolean isEntityCold(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.COLD_EFFECT_UUID) != null;
    }

    public static boolean isEntityFrozen(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.FROZEN_EFFECT_UUID) != null;
    }

    public static boolean isEntityButter(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.BUTTER_EFFECT_UUID) != null;
    }

    public static boolean isEntityInSky(Entity entity) {
        if (entity instanceof FlyingEntity || entity instanceof BatEntity) {
            return true;
        }
        if (entity instanceof BalloonZombieEntity && ((BalloonZombieEntity)entity).hasBalloon()) {
            return true;
        }
        return !entity.func_233570_aj_() && !entity.func_70090_H() && !entity.func_180799_ab();
    }

    public static void setLivingMaxHealthAndHeal(LivingEntity living, float maxHealth) {
        living.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)maxHealth);
        living.func_70691_i(maxHealth);
    }

    public static AxisAlignedBB getEntityAABB(Entity entity, double w, double h) {
        return new AxisAlignedBB(entity.func_226277_ct_() - w, entity.func_226278_cu_() - h, entity.func_226281_cx_() - w, entity.func_226277_ct_() + w, entity.func_226278_cu_() + h, entity.func_226281_cx_() + w);
    }
}

