/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.network.AlmanacUnLockPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.network.PlaySoundPacket;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.stats.Stats;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerUtil {
    public static final int MAX_TREE_LVL = 100;
    public static final int MAX_ENERGY_NUM = 10;
    public static final int MAX_MONEY = 9999999;
    public static final int MAX_SLOT_NUM = 162;
    public static final int[] TREE_LVL_XP = new int[]{10, 25, 50, 100, 200, 300, 500, 800, 1200, 2100, 3200, 5400, 7000, 8000, 9000, 10000, 12000, 15000, 18000, 20000};

    public static int getPlayerMaxSunNum(int lvl) {
        if (lvl <= 40) {
            return 900 + lvl * 100;
        }
        if (lvl <= 99) {
            return lvl * 250 - 5100;
        }
        return 19999;
    }

    public static int getPlayerWaveCount(int lvl) {
        if (lvl <= 10) {
            return 1;
        }
        if (lvl <= 25) {
            return 2;
        }
        if (lvl <= 40) {
            return 3;
        }
        if (lvl <= 60) {
            return 4;
        }
        return 5;
    }

    public static int getPlayerLevelUpXp(int lvl) {
        int pos = lvl / 5;
        if (lvl >= 100) {
            return 1000000000;
        }
        return TREE_LVL_XP[pos];
    }

    public static void addPlayerStats(PlayerEntity player, Resources res, int num) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> l.getPlayerData().getPlayerStats().addPlayerStats(res, num));
    }

    public static void addPlantLvl(PlayerEntity player, Plants plant, int num) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> l.getPlayerData().getPlantStats().addPlantLevel(plant, num));
    }

    public static void addPlantXp(PlayerEntity player, Plants plant, int num) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> l.getPlayerData().getPlantStats().addPlantXp(plant, num));
    }

    public static void clonePlayerData(PlayerEntity oldPlayer, PlayerEntity newPlayer) {
        LazyOptional oldCap = oldPlayer.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY);
        LazyOptional newCap = newPlayer.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY);
        if (oldCap.isPresent() && newCap.isPresent()) {
            newCap.ifPresent(l -> oldCap.ifPresent(r -> l.getPlayerData().cloneFromExistingPlayerData(r.getPlayerData())));
        }
    }

    public static void unLockAlmanac(PlayerEntity player, SearchOption a) {
        if (player instanceof ServerPlayerEntity) {
            PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new AlmanacUnLockPacket(a.ordinal(), true));
        }
    }

    public static boolean isAlmanacUnlocked(ServerPlayerEntity player, SearchOption a) {
        if (a.isPlayer()) {
            return true;
        }
        if (a.isPlant()) {
            Plants plant = a.getPlant().get();
            int amount = player.func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)PlantUtil.getPlantSummonCard(plant)));
            return amount > 0;
        }
        return false;
    }

    public static void playClientSound(PlayerEntity player, int id) {
        PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlaySoundPacket(id));
    }

    public static void sendTitleToPlayer(PlayerEntity player, ITextComponent text) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, text));
        }
    }

    public static void sendSubTitleToPlayer(PlayerEntity player, ITextComponent text) {
        if (player instanceof ServerPlayerEntity) {
            PlayerUtil.sendTitleToPlayer(player, (ITextComponent)new StringTextComponent(""));
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, text));
        }
    }

    public static void sendMsgToAll(World world, ITextComponent text) {
        world.func_73046_m().func_184103_al().func_181057_v().forEach(player -> player.func_145747_a(text, Util.field_240973_b_));
    }

    public static List<ServerPlayerEntity> getServerPlayers(World world) {
        return world.func_73046_m().func_184103_al().func_181057_v();
    }

    public static boolean isPlayerSurvival(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }
}

