/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils.enums;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.utils.enums.Bundles;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.world.data.PVZFlagData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public enum InvasionEvents {
    BUCKET(true, Bundles.GRASS_DAY, Zombies.NORMAL_ZOMBIE, Zombies.CONEHEAD_ZOMBIE, Zombies.POLE_ZOMBIE, Zombies.BUCKETHEAD_ZOMBIE),
    WATER(true, Bundles.POOL_DAY, Zombies.NORMAL_ZOMBIE, Zombies.SNORKEL_ZOMBIE, Zombies.ZOMBONI, Zombies.BOBSLE_TEAM, Zombies.LAVA_ZOMBIE),
    HALLOWEEN(true, Bundles.RANDOM, Zombies.NORMAL_ZOMBIE, Zombies.TRICK_ZOMBIE, Zombies.PUMPKIN_ZOMBIE),
    NEWSPAPER(true, Bundles.GRASS_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.NEWSPAPER_ZOMBIE, Zombies.OLD_ZOMBIE, Zombies.SUNDAY_EDITION_ZOMBIE),
    FOOTBALL(true, Bundles.GRASS_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.DANCING_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE),
    RANDOM(true, Bundles.RANDOM, new Zombies[0]),
    FOG(false),
    YETI(true, Bundles.POOL_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.BALLOON_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.POGO_ZOMBIE),
    BUNGEE(true, Bundles.ROOF, Zombies.BUNGEE_ZOMBIE),
    METAL(true, Bundles.UPGRADE, Zombies.BUCKETHEAD_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.POGO_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.LADDER_ZOMBIE),
    ROOF(true, Bundles.ROOF, Zombies.NORMAL_ZOMBIE, Zombies.BUNGEE_ZOMBIE, Zombies.LADDER_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR),
    GIANT(true, Bundles.UPGRADE, Zombies.GARGANTUAR, Zombies.SAD_GARGANTUAR),
    MINI(false),
    INVIS(false),
    ZOMBOTANY(true, Bundles.RANDOM, Zombies.PEASHOOTER_ZOMBIE, Zombies.WALLNUT_ZOMBIE, Zombies.GATLINGPEA_ZOMBIE, Zombies.TALLNUT_ZOMBIE, Zombies.SQUASH_ZOMBIE, Zombies.JALAPENO_ZOMBIE);

    public static final List<InvasionEvents> ATTACK_EVENTS;
    public static final EnumMap<InvasionEvents, Integer> EVENT_CHANCE;
    public boolean isZombieAttackEvent;
    public final List<Zombies> zombies;
    public Optional<Bundles> bundle = Optional.empty();

    public static ITextComponent getEventText(InvasionEvents ev) {
        TranslationTextComponent text = new TranslationTextComponent("event.pvz." + ev.toString().toLowerCase());
        switch (ev) {
            case BUCKET: {
                text.func_240699_a_(TextFormatting.GRAY);
                break;
            }
            case WATER: {
                text.func_240699_a_(TextFormatting.DARK_BLUE);
                break;
            }
            case HALLOWEEN: {
                text.func_240699_a_(TextFormatting.GOLD);
                break;
            }
            case NEWSPAPER: {
                text.func_240699_a_(TextFormatting.DARK_GRAY);
                break;
            }
            case FOOTBALL: {
                text.func_240699_a_(TextFormatting.BLACK);
                break;
            }
            case YETI: {
                text.func_240699_a_(TextFormatting.AQUA);
                break;
            }
            case FOG: {
                text.func_240699_a_(TextFormatting.GRAY);
                break;
            }
            case RANDOM: {
                text.func_240699_a_(TextFormatting.GREEN);
                break;
            }
            case BUNGEE: {
                text.func_240699_a_(TextFormatting.RED);
                break;
            }
            case METAL: {
                text.func_240699_a_(TextFormatting.BLACK);
                break;
            }
            case ROOF: {
                text.func_240699_a_(TextFormatting.GOLD);
                break;
            }
            case GIANT: {
                text.func_240699_a_(TextFormatting.DARK_RED);
                break;
            }
            case MINI: {
                text.func_240699_a_(TextFormatting.DARK_AQUA);
                break;
            }
            case INVIS: {
                text.func_240699_a_(TextFormatting.DARK_GRAY);
                break;
            }
            case ZOMBOTANY: {
                text.func_240699_a_(TextFormatting.DARK_GREEN);
                break;
            }
        }
        return text;
    }

    public static List<InvasionEvents> getAvailableSpawnEvents(World world) {
        return InvasionEvents.getAvailableInvasionEvents(world, ev -> ev.isZombieAttackEvent);
    }

    private static List<InvasionEvents> getAvailableInvasionEvents(World world, Predicate<InvasionEvents> pre) {
        ArrayList<InvasionEvents> list = new ArrayList<InvasionEvents>();
        for (InvasionEvents ev : InvasionEvents.values()) {
            if (!InvasionEvents.isAvailableInvasionEvent(world, ev) || !pre.test(ev)) continue;
            list.add(ev);
        }
        return list;
    }

    public static boolean isAvailableInvasionEvent(World world, InvasionEvents ev) {
        PVZFlagData data = PVZFlagData.getGlobalFlagData(world);
        switch (ev) {
            case RANDOM: 
            case BUNGEE: 
            case METAL: 
            case GIANT: 
            case MINI: 
            case INVIS: 
            case ZOMBOTANY: {
                return data.isZombossDefeated();
            }
        }
        return true;
    }

    private InvasionEvents(boolean isAttackEvent) {
        this.zombies = new ArrayList<Zombies>();
    }

    private InvasionEvents(boolean isAttackEvent, Bundles bundle, Zombies ... zombies) {
        this.isZombieAttackEvent = isAttackEvent;
        this.bundle = Optional.of(bundle);
        this.zombies = Arrays.asList(zombies);
    }

    static {
        ATTACK_EVENTS = new ArrayList<InvasionEvents>();
        EVENT_CHANCE = new EnumMap(InvasionEvents.class);
        EVENT_CHANCE.put(BUCKET, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.BucketAttackChance.get());
        EVENT_CHANCE.put(WATER, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.WaterAttackChance.get());
        EVENT_CHANCE.put(HALLOWEEN, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.HalloweenAttackChance.get());
        EVENT_CHANCE.put(NEWSPAPER, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.NewspaperAttackChance.get());
        EVENT_CHANCE.put(FOOTBALL, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.FootballAttackChance.get());
        EVENT_CHANCE.put(RANDOM, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.RandomAttackChance.get());
        EVENT_CHANCE.put(YETI, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.YetiAttackChance.get());
        EVENT_CHANCE.put(BUNGEE, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.BungeeAttackChance.get());
        EVENT_CHANCE.put(METAL, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.MetalAttackChance.get());
        EVENT_CHANCE.put(ROOF, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.RoofAttackChance.get());
        EVENT_CHANCE.put(GIANT, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.GiantAttackChance.get());
        EVENT_CHANCE.put(ZOMBOTANY, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.ZombotanyAttackChance.get());
        for (InvasionEvents ev : InvasionEvents.values()) {
            if (!ev.isZombieAttackEvent) continue;
            ATTACK_EVENTS.add(ev);
        }
    }
}

