/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.world.invasion;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.others.WeightList;
import com.hungteen.pvz.world.data.PVZFlagData;
import com.hungteen.pvz.world.data.PVZInvasionData;
import com.hungteen.pvz.world.invasion.FogManager;
import com.hungteen.pvz.world.invasion.WaveManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class OverworldInvasion {
    private static final ITextComponent ZOMBIE_ATTACK = new TranslationTextComponent("event.pvz.zombie_attack").func_240699_a_(TextFormatting.DARK_RED);
    private static final ITextComponent ATTACK_FINISH = new TranslationTextComponent("event.pvz.attack_finish").func_240699_a_(TextFormatting.GREEN);
    private static final ITextComponent SAFE_DAY_INFO = new TranslationTextComponent("event.pvz.safe_day");
    private static final ITextComponent COUNT_DOWN_INFO = new TranslationTextComponent("event.pvz.count_down");
    private static final ITextComponent DAY = new TranslationTextComponent("event.pvz.day");
    public static final Set<Zombies> ZOMBIE_INVADE_SET = new HashSet<Zombies>();
    public static final int PRE_START_TICK = 499;
    public static final int START_TICK = 500;
    public static final int PRE_END_TICK = 99;
    public static final int END_TICK = 100;

    public static void tick(TickEvent.WorldTickEvent ev) {
        World world = ev.world;
        long totalTime = world.func_72820_D();
        int dayTime = (int)(totalTime % 24000L);
        switch (dayTime) {
            case 499: {
                PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
                data.setChanged(false);
                break;
            }
            case 500: {
                PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                OverworldInvasion.deactivateZombieAttackEvents(world, false);
                long dif = OverworldInvasion.difSafeDay(world);
                boolean isSafe = dif < 0L;
                int count = data.getCountDownDay();
                boolean hasCount = data.hasCountDownDay();
                if (!hasCount && !isSafe) {
                    OverworldInvasion.activateZombieAttackEvents(world);
                } else if (isSafe) {
                    PlayerUtil.sendMsgToAll(world, (ITextComponent)new StringTextComponent(SAFE_DAY_INFO.getString() + " : " + OverworldInvasion.getLeftSafeDay(dif) + DAY.getString()).func_240699_a_(TextFormatting.GREEN));
                } else {
                    PlayerUtil.sendMsgToAll(world, (ITextComponent)new StringTextComponent(COUNT_DOWN_INFO.getString() + " : " + count + DAY.getString()).func_240699_a_(TextFormatting.RED));
                }
                data.decCountDownDay();
                break;
            }
            case 99: {
                PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
                data.setChanged(false);
                break;
            }
            case 100: {
                PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                OverworldInvasion.deactivateZombieAttackEvents(world, true);
                break;
            }
        }
        WaveManager.tickWave(world, dayTime);
        FogManager.tickFog(world);
    }

    public static void activateZombieAttackEvents(World world) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL) {
            for (ServerPlayerEntity pl : world.func_73046_m().func_184103_al().func_181057_v()) {
                pl.func_145747_a(ZOMBIE_ATTACK, Util.field_240973_b_);
                PlayerUtil.playClientSound((PlayerEntity)pl, 3);
                WaveManager.resetPlayerWaveTime((PlayerEntity)pl);
            }
            InvasionEvents event = OverworldInvasion.getSpawnEvent(world);
            OverworldInvasion.activateEvent(world, event);
            OverworldInvasion.activateAssistEvents(world);
            PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
            ArrayList<Zombies> zombieList = new ArrayList<Zombies>();
            for (Zombies zombie : Zombies.values()) {
                if (!data.hasZombieSpawnEntry(zombie)) continue;
                zombieList.add(zombie);
            }
            if (((Boolean)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.ShowEventMessages.get()).booleanValue()) {
                world.func_73046_m().func_184103_al().func_181057_v().forEach(player -> {
                    for (InvasionEvents ev : InvasionEvents.values()) {
                        if (!data.hasEvent(ev)) continue;
                        player.func_145747_a(InvasionEvents.getEventText(ev), Util.field_240973_b_);
                    }
                    String zombieInfo = "";
                    for (int i = 0; i < zombieList.size(); ++i) {
                        zombieInfo = zombieInfo + new TranslationTextComponent("entity.pvz." + ((Zombies)((Object)((Object)zombieList.get(i)))).toString().toLowerCase()).getString() + (i == zombieList.size() - 1 ? "" : ",");
                    }
                    player.func_145747_a((ITextComponent)new StringTextComponent(zombieInfo), Util.field_240973_b_);
                });
            }
        }
    }

    public static void activateEvent(World world, @Nonnull InvasionEvents event) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
        if (!data.hasEvent(event)) {
            data.addEvent(event);
            OverworldInvasion.addEventSpawns(world, event);
        }
    }

    public static void addEventSpawns(World world, InvasionEvents event) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
        for (Zombies zombie : OverworldInvasion.getInvasionSpawnZombies(world, event)) {
            if (data.hasZombieSpawnEntry(zombie)) continue;
            data.addZombieSpawnEntry(zombie);
        }
        OverworldInvasion.syncStartSpawnList(world);
    }

    public static void activateAssistEvents(World world) {
        PVZFlagData data = PVZFlagData.getGlobalFlagData(world);
        if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.FogEventChance.get()) == 0) {
            OverworldInvasion.activateEvent(world, InvasionEvents.FOG);
        }
        if (data.isZombossDefeated()) {
            if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.MiniEventChance.get()) == 0) {
                OverworldInvasion.activateEvent(world, InvasionEvents.MINI);
            }
            if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.EventChanceSettings.InvisEventChance.get()) == 0) {
                OverworldInvasion.activateEvent(world, InvasionEvents.INVIS);
            }
        }
    }

    public static void deactivateZombieAttackEvents(World world, boolean isNatural) {
        boolean flag = false;
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
        for (Object ev : InvasionEvents.values()) {
            flag |= data.hasEvent((InvasionEvents)((Object)ev));
        }
        if (isNatural && flag) {
            for (ServerPlayerEntity pl : world.func_73046_m().func_184103_al().func_181057_v()) {
                pl.func_145747_a(ATTACK_FINISH, Util.field_240973_b_);
                PlayerUtil.playClientSound((PlayerEntity)pl, 4);
                WaveManager.giveInvasionBonusToPlayer(world, (PlayerEntity)pl);
            }
        }
        for (Object ev : InvasionEvents.values()) {
            if (!data.hasEvent((InvasionEvents)((Object)ev))) continue;
            data.removeEvent((InvasionEvents)((Object)ev));
        }
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            data.removeZombieSpawnEntry(zombie);
        }
        OverworldInvasion.syncEndSpawnList(world);
    }

    public static List<Zombies> getInvasionSpawnZombies(World world, InvasionEvents ev) {
        if (ev == InvasionEvents.RANDOM) {
            return OverworldInvasion.getRandomSpawnZombies(world);
        }
        return ev.zombies;
    }

    private static List<Zombies> getRandomSpawnZombies(World world) {
        ArrayList<Zombies> zombies = new ArrayList<Zombies>();
        int zombieTypeCnt = world.field_73012_v.nextInt(3) + 3;
        for (int i = 0; i < zombieTypeCnt; ++i) {
            Zombies.ZOMBIE_SPAWN_LIST.getRandomItem(world.field_73012_v).ifPresent(zombie -> {
                if (zombies.indexOf(zombie) == -1) {
                    zombies.add((Zombies)((Object)zombie));
                }
            });
        }
        return zombies;
    }

    private static InvasionEvents getSpawnEvent(World world) {
        WeightList<InvasionEvents> list = new WeightList<InvasionEvents>();
        int sum = 0;
        for (InvasionEvents ev : InvasionEvents.getAvailableSpawnEvents(world)) {
            if (!InvasionEvents.EVENT_CHANCE.containsKey((Object)ev)) continue;
            int weight = InvasionEvents.EVENT_CHANCE.get((Object)ev);
            list.addItem(ev, weight);
            sum += weight;
        }
        list.setTotal(sum);
        return (InvasionEvents)((Object)list.getRandomItem(world.field_73012_v).get());
    }

    public static void syncStartSpawnList(World world) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            ZOMBIE_INVADE_SET.add(zombie);
        }
    }

    public static void syncEndSpawnList(World world) {
        ZOMBIE_INVADE_SET.clear();
    }

    public static long difSafeDay(World world) {
        return world.func_82737_E() - (long)((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.SafeDayLength.get() * 24000);
    }

    public static long getLeftSafeDay(long len) {
        return (-len + 23999L) / 24000L;
    }
}

