/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.world.invasion;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.capability.player.PlayerDataManager;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.network.OtherStatsPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.utils.enums.Resources;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.others.WeightList;
import com.hungteen.pvz.world.data.PVZInvasionData;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.PacketDistributor;

public class WaveManager {
    private static final ITextComponent HUGE_WAVE = new TranslationTextComponent("event.pvz.huge_wave").func_240699_a_(TextFormatting.DARK_RED);
    public static final int MAX_WAVE_NUM = 5;
    public static final int FINISH_OFFSET = 30000;
    private final World world;
    private final int currentWave;
    private final PlayerEntity player;
    private final BlockPos center;
    private final WeightList<Zombies> spawnList = new WeightList();
    private static final int[] SPAWN_COUNT_EACH_WAVE = new int[]{20, 30, 40, 50, 60};
    public int spawnCnt = 0;

    public WaveManager(PlayerEntity player, int waveNum) {
        this.world = player.field_70170_p;
        this.currentWave = waveNum;
        this.player = player;
        this.center = player.func_233580_cy_();
        this.updateSpawns();
    }

    public static void tickWave(World world, int dayTime) {
        if (!WaveManager.canWaveRun(world)) {
            return;
        }
        PlayerUtil.getServerPlayers(world).forEach(player -> {
            if (PlayerUtil.isPlayerSurvival((PlayerEntity)player)) {
                player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                    PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
                    for (int i = 0; i < stats.zombieWaveTime.length; ++i) {
                        int time = stats.zombieWaveTime[i];
                        if (time == 0 || time != dayTime) continue;
                        WaveManager manager = new WaveManager((PlayerEntity)player, i);
                        manager.spawnWaveZombies();
                        int n = i;
                        stats.zombieWaveTime[n] = stats.zombieWaveTime[n] + 30000;
                        WaveManager.syncWaveTime((PlayerEntity)player);
                        break;
                    }
                });
            }
        });
    }

    public static void syncWaveTime(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
            for (int i = 0; i < 5; ++i) {
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(1, i, stats.zombieWaveTime[i]));
            }
            PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(1, -1, stats.totalWaveCount));
        });
    }

    public void activateTombStone() {
        if (!this.world.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        int len = 30;
        this.world.func_175647_a(TombStoneEntity.class, EntityUtil.getEntityAABB((Entity)this.player, len, len), tombstone -> true).forEach(tomb -> tomb.summonZombie());
    }

    public void spawnWaveZombies() {
        int cnt;
        int teamCnt;
        if (!this.world.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        if (this.spawnList.getTotal() == 0) {
            PVZMod.LOGGER.warn("Warn : Why cause no wave zombie spawned ?");
            return;
        }
        boolean spawned = false;
        int groupNum = 0;
        for (cnt = this.getSpawnCount(); cnt >= 10; cnt -= teamCnt) {
            teamCnt = cnt < 15 ? cnt : 10;
            spawned |= this.spawnZombieTeam(++groupNum, teamCnt);
        }
        if (cnt > 0) {
            spawned |= this.spawnZombieTeam(++groupNum, cnt);
        }
        if (spawned) {
            PlayerUtil.playClientSound(this.player, 2);
            PlayerUtil.sendSubTitleToPlayer(this.player, HUGE_WAVE);
            this.activateTombStone();
            this.checkAndSummonBungee();
        }
    }

    protected void checkAndSummonBungee() {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(this.world);
        if (!data.hasZombieSpawnEntry(Zombies.BUNGEE_ZOMBIE)) {
            return;
        }
        int minCnt = 5 + this.currentWave;
        int maxCnt = 5 + 3 * this.currentWave;
        int cnt = this.world.field_73012_v.nextInt(maxCnt - minCnt + 1) + minCnt;
        int height = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.player.func_233580_cy_().func_177958_n(), this.player.func_233580_cy_().func_177952_p());
        for (int i = 0; i < cnt; ++i) {
            int posX = this.world.field_73012_v.nextInt(71) - 35;
            int posZ = this.world.field_73012_v.nextInt(71) - 35;
            BungeeZombieEntity bungee = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.world);
            bungee.setBungeeType(BungeeZombieEntity.BungeeTypes.SUMMON);
            EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)bungee, new BlockPos(this.player.func_233580_cy_().func_177958_n() + posX, height + 20, this.player.func_233580_cy_().func_177952_p() + posZ));
            EntityUtil.playSound((Entity)this.player, (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
        }
    }

    public static void resetPlayerWaveTime(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
            int treeLvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
            int maxCnt = PlayerUtil.getPlayerWaveCount(treeLvl);
            int minCnt = (maxCnt + 1) / 2;
            int cnt = player.func_70681_au().nextInt(maxCnt - minCnt + 1) + minCnt;
            int partTime = 21000 / cnt;
            for (int i = 0; i < 5; ++i) {
                if (i < cnt) {
                    int time = player.func_70681_au().nextInt(partTime - 2000);
                    stats.zombieWaveTime[i] = 2500 + (time + i * partTime + 1000);
                    continue;
                }
                stats.zombieWaveTime[i] = 0;
            }
            stats.totalWaveCount = cnt;
            WaveManager.syncWaveTime(player);
        });
    }

    public static void giveInvasionBonusToPlayer(World world, PlayerEntity player) {
        if (!PlayerUtil.isPlayerSurvival(player)) {
            return;
        }
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int cnt = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.KILL_COUNT);
            if (cnt >= 50) {
                PlayerUtil.playClientSound(player, 6);
                PlayerUtil.addPlayerStats(player, Resources.MONEY, cnt >= 200 ? 200 : 50);
                PlayerUtil.addPlayerStats(player, Resources.LOTTERY_CHANCE, cnt >= 200 ? 5 : 3);
                for (int i = 0; i < (cnt >= 200 ? 2 : 1); ++i) {
                    player.func_191521_c(WaveManager.getRandomItemForPlayer(world));
                }
                PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
                for (int i = 0; i < stats.zombieWaveTime.length; ++i) {
                    stats.zombieWaveTime[i] = 0;
                }
                stats.totalWaveCount = 0;
                WaveManager.syncWaveTime(player);
            }
            l.getPlayerData().getPlayerStats().setPlayerStats(Resources.KILL_COUNT, 0);
        });
    }

    private static ItemStack getRandomItemForPlayer(World world) {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(world);
        for (InvasionEvents ev : InvasionEvents.values()) {
            if (!data.hasEvent(ev) || !ev.bundle.isPresent()) continue;
            return ev.bundle.get().getRandomBundle();
        }
        return ItemStack.field_190927_a;
    }

    private boolean spawnZombieTeam(int groupNum, int cnt) {
        PVZInvasionData data;
        BlockPos mid = this.findRandomSpawnPos(20);
        if (mid == null) {
            return false;
        }
        for (int i = 0; i < cnt; ++i) {
            this.spawnList.getRandomItem(this.world.field_73012_v).ifPresent(zombie -> this.spawnZombie((Zombies)((Object)zombie), mid));
        }
        if (groupNum == 1 && (data = PVZInvasionData.getOverWorldInvasionData(this.world)).hasEvent(InvasionEvents.YETI) && this.world.field_73012_v.nextInt(3) == 0) {
            PVZZombieEntity yeti = (PVZZombieEntity)((EntityType)EntityRegister.YETI_ZOMBIE.get()).func_200721_a(this.world);
            EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)yeti, mid.func_177982_a(0, 1, 0));
        }
        PVZZombieEntity flagZombie = (PVZZombieEntity)((EntityType)EntityRegister.FLAG_ZOMBIE.get()).func_200721_a(this.world);
        EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)flagZombie, mid.func_177982_a(0, 1, 0));
        return true;
    }

    private void spawnZombie(Zombies zombie, BlockPos pos) {
        int range = 11;
        int x = pos.func_177958_n() + this.world.field_73012_v.nextInt(range) - range / 2;
        int z = pos.func_177952_p() + this.world.field_73012_v.nextInt(range) - range / 2;
        int y = this.world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
        PVZZombieEntity zombieEntity = ZombieUtil.getZombieEntity(this.world, zombie);
        EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)zombieEntity, new BlockPos(x, y + 1, z));
    }

    private int getSpawnCount() {
        if (this.spawnCnt != 0) {
            return this.spawnCnt;
        }
        int maxCnt = SPAWN_COUNT_EACH_WAVE[this.currentWave];
        int minCnt = maxCnt / 2;
        return this.world.field_73012_v.nextInt(maxCnt - minCnt + 1) + minCnt;
    }

    private void updateSpawns() {
        PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(this.world);
        int sum = 0;
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            this.spawnList.addItem(zombie, zombie.spawnWeight);
            sum += zombie.spawnWeight;
        }
        this.spawnList.setTotal(sum);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int chance) {
        int range = 16;
        int distance = 32;
        for (int i = 0; i < chance; ++i) {
            int z;
            int y;
            float f = this.world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            int dx = MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)f) * (float)distance));
            int dz = MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)f) * (float)distance));
            int x = this.center.func_177958_n() + (dx > 0 ? dx + range : dx - range);
            BlockPos pos = new BlockPos(x, y = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = this.center.func_177952_p() + (dz > 0 ? dz + range : dz - range)), z);
            if (!this.world.func_175707_a(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range, range, range)) || !this.world.func_72863_F().func_222865_a(new ChunkPos(pos)) || !this.world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206888_e() || this.world.func_226658_a_(LightType.BLOCK, pos) >= 7) continue;
            return pos;
        }
        return null;
    }

    public static boolean canWaveRun(World world) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }
}

