/*
 * Definition of the Directorybrowser class
 */
#define _CRT_SECURE_NO_WARNINGS
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "directorybrowser.h"
#include "logger.h"


/*
 * Constructor
 */
Directorybrowser *directorybrowser_create(char * directory,int dir_brows_default,char *web_file)
{
	Directorybrowser	*new_obj;

	new_obj = malloc(sizeof(Directorybrowser));
	assert(new_obj);
	if (new_obj)
	{
		strcpy(new_obj->_directory,directory);
		new_obj->_dir_brows_default = dir_brows_default;
		new_obj->_output = 0;
		new_obj->_pos = 0;
		new_obj->_pages = 2;
		new_obj->_web_file = web_file;
		if (!strcmp(web_file,"/") || !strcmp(web_file,"\\"))
		{
			new_obj->_is_root = 1;
		}
		else
		{
			new_obj->_is_root = 0;
		}
	}
	return new_obj;
}

/*
 * Destructor
 */
void directorybrowser_delete(Directorybrowser *self)
{
	assert(self);
	if (self)
	{
		if (self->_output != 0)
			free(self->_output);
		free(self);
	}
}


int directorybrowser_can_brows(Directorybrowser *self)
{
	FILE	*f;
	char	dir_file[FILE_SIZE];

	if (!self->_dir_brows_default)
	{
		strcpy(dir_file,self->_directory);
		strcat(dir_file,DIRECTORY_BROWSING_FILE);
		f = NULL;
		/* Try to open the file*/
		f = fopen(dir_file,"rb");
		if (!f)
			return 0; 
		else
		{
			/* Could open file so close it*/
			fclose(f);
			return 1;
		}
	}
	return 1;
}

static void write_data(Directorybrowser *self, char *data)
{
	char *p;

	if( ((self->_pages * DIR_BUFFER_SIZE) - (unsigned int)(self->_pos - self->_output)) < (unsigned int)strlen(data) + 1)
	{
		self->_pages++;
		self->_output = realloc(self->_output,DIR_BUFFER_SIZE * self->_pages);
	}

	for (p = data; *p != 0; p++)
	{
		*(self->_pos)++ = *p;
	}
	*(self->_pos) = 0;
}

static void print_dir(Directorybrowser *self,char *name,int is_root)
{
	if (self->_is_root)
		if(!strcmp(name,".."))
			return;

	if (strcmp(name,"."))
	{
		write_data(self,"<a href='");
		write_data(self,name);
		write_data(self,"/'>");
		write_data(self,name);
		write_data(self,"</a>");
		write_data(self,"<BR>");
	}

}

static void print_file(Directorybrowser *self,char *name)
{
	if (strcmp(name,DIRECTORY_BROWSING_FILE))
	{
		write_data(self,"<a href='");
		write_data(self,name);
		write_data(self,"'>");
		write_data(self,name);
		write_data(self,"</a>");
		write_data(self,"<BR>");
	}
}


Result directorybrowser_get_brows_data(Directorybrowser *self, char **output)
{
	WIN32_FIND_DATA file_data;
	HANDLE			files;
	int				is_root = 0;

	/*Initialize write buffer*/
	if (self->_output == 0)
	{
		self->_output = malloc(DIR_BUFFER_SIZE * self->_pages);
		self->_pos = self->_output;
		self->_pos = self->_pos;
	}

	write_data(self,"<html><head></head><body>");
	write_data(self,"<h2>");
	write_data(self,self->_web_file);
	write_data(self,"</h2>");

	/*Subdirectories*/
	strcat(self->_directory,"*.*");
	files = FindFirstFileA(self->_directory,(LPWIN32_FIND_DATAA)&file_data);
	if (!files)
		return ERR;
	if (files != INVALID_HANDLE_VALUE)
	{
		if (file_data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			print_dir(self,(char*)file_data.cFileName,is_root);
		while (FindNextFileA(files,(LPWIN32_FIND_DATAA)&file_data))
		{
			if (file_data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				print_dir(self,(char*)file_data.cFileName,is_root);
		}
	}
	FindClose(files);

	/*Files*/
	files = FindFirstFileA(self->_directory,(LPWIN32_FIND_DATAA)&file_data);
	if (!files)
		return ERR;
	if (files != INVALID_HANDLE_VALUE)
	{
		if (!(file_data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			print_file(self,(char*)file_data.cFileName);
		while (FindNextFileA(files,(LPWIN32_FIND_DATAA)&file_data))
		{
			if (!(file_data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
				print_file(self,(char*)file_data.cFileName);
		}
	}
	FindClose(files);

	write_data(self,"</body></html>");
	*output = self->_output;
	return OK;

}
