/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsState;
import com.mojang.realmsclient.exception.RealmsServiceException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class BuyRealmsScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen lastScreen;
    private static int BACK_BUTTON_ID = 111;
    private volatile RealmsState realmsStatus;
    private boolean onLink = false;

    public BuyRealmsScreen(RealmsScreen lastScreen) {
        this.lastScreen = lastScreen;
    }

    public void tick() {
        super.tick();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        int buttonLength = 212;
        this.buttonsAdd(BuyRealmsScreen.newButton((int)BACK_BUTTON_ID, (int)(this.width() / 2 - buttonLength / 2), (int)180, (int)buttonLength, (int)20, (String)BuyRealmsScreen.getLocalizedString((String)"gui.back")));
        this.fetchMessage();
    }

    private void fetchMessage() {
        final RealmsClient client = RealmsClient.createRealmsClient();
        new Thread("Realms-stat-message"){

            @Override
            public void run() {
                try {
                    BuyRealmsScreen.this.realmsStatus = client.fetchRealmsState();
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Could not get stat");
                }
            }
        }.start();
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == BACK_BUTTON_ID) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        if (this.onLink) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.realmsStatus.getBuyLink()), null);
            this.browseTo(this.realmsStatus.getBuyLink());
        }
    }

    private void browseTo(String uri) {
        try {
            URI link = new URI(uri);
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(o, link);
        }
        catch (Throwable e) {
            LOGGER.error("Couldn't open link");
        }
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(BuyRealmsScreen.getLocalizedString((String)"mco.buy.realms.title"), this.width() / 2, 11, 0xFFFFFF);
        if (this.realmsStatus == null) {
            return;
        }
        String[] lines = this.realmsStatus.getStatusMessage().split("\n");
        int height = 52;
        for (String line : lines) {
            this.drawCenteredString(line, this.width() / 2, height, 0xA0A0A0);
            height += 18;
        }
        if (this.realmsStatus.getBuyLink() != null) {
            String buyLink = this.realmsStatus.getBuyLink();
            int linkColor = 0x3366BB;
            int hoverColor = 7107012;
            int textWidth = this.fontWidth(buyLink);
            int x1 = this.width() / 2 - textWidth / 2 - 1;
            int y1 = (height += 18) - 1;
            int x2 = x1 + textWidth + 1;
            int y2 = height + 1 + this.fontLineHeight();
            if (x1 <= xm && xm <= x2 && y1 <= ym && ym <= y2) {
                this.onLink = true;
                this.drawString("\u00a7n" + buyLink, this.width() / 2 - textWidth / 2, height, hoverColor);
            } else {
                this.onLink = false;
                this.drawString(buyLink, this.width() / 2 - textWidth / 2, height, linkColor);
            }
        }
        super.render(xm, ym, a);
    }
}

