/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomItem;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.INeedleAmmo;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;

public abstract class MFRRegistry {
    private static Map<Integer, IFactoryPlantable> _plantables = new HashMap<Integer, IFactoryPlantable>();
    private static Map<Integer, IFactoryHarvestable> _harvestables = new HashMap<Integer, IFactoryHarvestable>();
    private static Map<Integer, IFactoryFertilizer> _fertilizers = new HashMap<Integer, IFactoryFertilizer>();
    private static Map<Integer, IFactoryFertilizable> _fertilizables = new HashMap<Integer, IFactoryFertilizable>();
    private static Map<Class<?>, IFactoryRanchable> _ranchables = new HashMap();
    private static Map<Class<?>, IFactoryGrindable> _grindables = new HashMap();
    private static Map<Class<?>, List<ItemStack>> _breederFoods = new HashMap();
    private static Map<String, ILiquidDrinkHandler> _liquidDrinkHandlers = new HashMap<String, ILiquidDrinkHandler>();
    private static Map<Integer, INeedleAmmo> _needleAmmoTypes = new HashMap<Integer, INeedleAmmo>();
    private static List<Integer> _fruitLogBlocks = new ArrayList<Integer>();
    private static Map<Integer, IFactoryFruit> _fruitBlocks = new HashMap<Integer, IFactoryFruit>();
    private static List<WeightedRandomItem> _sludgeDrops = new ArrayList<WeightedRandomItem>();
    private static List<IMobEggHandler> _eggHandlers = new ArrayList<IMobEggHandler>();
    private static List<ISafariNetHandler> _safariNetHandlers = new ArrayList<ISafariNetHandler>();
    private static List<String> _rubberTreeBiomes = new ArrayList<String>();
    private static List<Class<?>> _safariNetBlacklist = new ArrayList();
    private static List<IRandomMobProvider> _randomMobProviders = new ArrayList<IRandomMobProvider>();
    private static List<IRedNetLogicCircuit> _redNetLogicCircuits = new ArrayList<IRedNetLogicCircuit>();
    private static List<WeightedRandomItem> _laserOres = new ArrayList<WeightedRandomItem>();
    private static List<Class<?>> _grindableBlacklist = new ArrayList();
    private static List<String> _autoSpawnerBlacklist = new ArrayList<String>();
    private static List<Class<?>> _autoSpawnerClassBlacklist = new ArrayList();
    private static List<Class<?>> _slaughterhouseBlacklist = new ArrayList();
    private static Map<Integer, List<ItemStack>> _laserPreferredOres = new HashMap<Integer, List<ItemStack>>(16);

    public static void registerPlantable(IFactoryPlantable iFactoryPlantable) {
        _plantables.put(new Integer(iFactoryPlantable.getSeedId()), iFactoryPlantable);
    }

    public static Map<Integer, IFactoryPlantable> getPlantables() {
        return _plantables;
    }

    public static void registerHarvestable(IFactoryHarvestable iFactoryHarvestable) {
        _harvestables.put(iFactoryHarvestable.getPlantId(), iFactoryHarvestable);
    }

    public static Map<Integer, IFactoryHarvestable> getHarvestables() {
        return _harvestables;
    }

    public static void registerFertilizable(IFactoryFertilizable iFactoryFertilizable) {
        _fertilizables.put(iFactoryFertilizable.getFertilizableBlockId(), iFactoryFertilizable);
    }

    public static Map<Integer, IFactoryFertilizable> getFertilizables() {
        return _fertilizables;
    }

    public static void registerFertilizer(IFactoryFertilizer iFactoryFertilizer) {
        Integer n = new Integer(iFactoryFertilizer.getFertilizerId());
        if (!_fertilizers.containsKey(n)) {
            _fertilizers.put(n, iFactoryFertilizer);
        }
    }

    public static Map<Integer, IFactoryFertilizer> getFertilizers() {
        return _fertilizers;
    }

    public static void registerRanchable(IFactoryRanchable iFactoryRanchable) {
        _ranchables.put(iFactoryRanchable.getRanchableEntity(), iFactoryRanchable);
    }

    public static Map<Class<?>, IFactoryRanchable> getRanchables() {
        return _ranchables;
    }

    public static void registerGrindable(IFactoryGrindable iFactoryGrindable) {
        _grindables.put(iFactoryGrindable.getGrindableEntity(), iFactoryGrindable);
    }

    public static Map<Class<?>, IFactoryGrindable> getGrindables() {
        return _grindables;
    }

    public static void registerGrinderBlacklist(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            _grindableBlacklist.add(clazz);
            if (!_safariNetBlacklist.contains(clazz)) continue;
            _slaughterhouseBlacklist.add(clazz);
        }
    }

    public static List<Class<?>> getGrinderBlacklist() {
        return _grindableBlacklist;
    }

    public static List<Class<?>> getSlaughterhouseBlacklist() {
        return _slaughterhouseBlacklist;
    }

    public static void registerSludgeDrop(int n, ItemStack itemStack) {
        _sludgeDrops.add((WeightedRandomItem)new WeightedRandomItemStack(n, itemStack.func_77946_l()));
    }

    public static List<WeightedRandomItem> getSludgeDrops() {
        return _sludgeDrops;
    }

    public static void registerBreederFood(Class<?> clazz, ItemStack itemStack) {
        if (_breederFoods.containsKey(clazz)) {
            _breederFoods.get(clazz).add(itemStack);
        } else {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.add(itemStack.func_77946_l());
            _breederFoods.put(clazz, arrayList);
        }
    }

    public static Map<Class<?>, List<ItemStack>> getBreederFoods() {
        return _breederFoods;
    }

    public static void registerMobEggHandler(IMobEggHandler iMobEggHandler) {
        _eggHandlers.add(iMobEggHandler);
    }

    public static List<IMobEggHandler> getModMobEggHandlers() {
        return _eggHandlers;
    }

    public static void registerSafariNetHandler(ISafariNetHandler iSafariNetHandler) {
        _safariNetHandlers.add(iSafariNetHandler);
    }

    public static List<ISafariNetHandler> getSafariNetHandlers() {
        return _safariNetHandlers;
    }

    public static void registerRubberTreeBiome(String string) {
        _rubberTreeBiomes.add(string);
    }

    public static List<String> getRubberTreeBiomes() {
        return _rubberTreeBiomes;
    }

    public static void registerSafariNetBlacklist(Class<?> clazz) {
        _safariNetBlacklist.add(clazz);
        if (_grindableBlacklist.contains(clazz)) {
            _slaughterhouseBlacklist.add(clazz);
        }
    }

    public static List<Class<?>> getSafariNetBlacklist() {
        return _safariNetBlacklist;
    }

    public static void registerRandomMobProvider(IRandomMobProvider iRandomMobProvider) {
        _randomMobProviders.add(iRandomMobProvider);
    }

    public static List<IRandomMobProvider> getRandomMobProviders() {
        return _randomMobProviders;
    }

    public static void registerLiquidDrinkHandler(String string, ILiquidDrinkHandler iLiquidDrinkHandler) {
        _liquidDrinkHandlers.put(string, iLiquidDrinkHandler);
    }

    public static Map<String, ILiquidDrinkHandler> getLiquidDrinkHandlers() {
        return _liquidDrinkHandlers;
    }

    public static void registerRedNetLogicCircuit(IRedNetLogicCircuit iRedNetLogicCircuit) {
        _redNetLogicCircuits.add(iRedNetLogicCircuit);
    }

    public static List<IRedNetLogicCircuit> getRedNetLogicCircuits() {
        return _redNetLogicCircuits;
    }

    public static void registerLaserOre(int n, ItemStack itemStack) {
        _laserOres.add((WeightedRandomItem)new WeightedRandomItemStack(n, itemStack.func_77946_l()));
    }

    public static List<WeightedRandomItem> getLaserOres() {
        return _laserOres;
    }

    public static void registerFruitLogBlockId(Integer n) {
        _fruitLogBlocks.add(n);
    }

    public static List<Integer> getFruitLogBlockIds() {
        return _fruitLogBlocks;
    }

    public static void registerFruit(IFactoryFruit iFactoryFruit) {
        _fruitBlocks.put(iFactoryFruit.getSourceBlockId(), iFactoryFruit);
    }

    public static Map<Integer, IFactoryFruit> getFruits() {
        return _fruitBlocks;
    }

    public static void registerAutoSpawnerBlacklistClass(Class<?> clazz) {
        _autoSpawnerClassBlacklist.add(clazz);
    }

    public static List<Class<?>> getAutoSpawnerClassBlacklist() {
        return _autoSpawnerClassBlacklist;
    }

    public static void registerAutoSpawnerBlacklist(String string) {
        _autoSpawnerBlacklist.add(string);
    }

    public static List<String> getAutoSpawnerBlacklist() {
        return _autoSpawnerBlacklist;
    }

    @Deprecated
    public static void setLaserPreferredOre(int n, ItemStack itemStack) {
        MFRRegistry.addLaserPreferredOre(n, itemStack);
    }

    public static void addLaserPreferredOre(int n, ItemStack itemStack) {
        if (n < 0 || 16 <= n) {
            return;
        }
        List<ItemStack> list = _laserPreferredOres.get(n);
        if (list == null) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.add(itemStack);
            _laserPreferredOres.put(n, arrayList);
        } else {
            for (ItemStack itemStack2 : list) {
                if (!UtilInventory.stacksEqual((ItemStack)itemStack2, (ItemStack)itemStack)) continue;
                return;
            }
            list.add(itemStack);
        }
    }

    public static List<ItemStack> getLaserPreferredOres(int n) {
        return _laserPreferredOres.get(n);
    }

    public static void registerNeedleAmmoType(Integer n, INeedleAmmo iNeedleAmmo) {
        Integer n2 = new Integer(n);
        if (!_needleAmmoTypes.containsKey(n2)) {
            _needleAmmoTypes.put(n2, iNeedleAmmo);
        }
    }

    public static Map<Integer, INeedleAmmo> getNeedleAmmoTypes() {
        return _needleAmmoTypes;
    }
}

