/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits;

import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;

public class PassthroughRoundRobin
implements IRedNetLogicCircuit {
    private int _currentOutput;
    private boolean _lastClockState;

    @Override
    public int getInputCount() {
        return 3;
    }

    @Override
    public int getOutputCount() {
        return 16;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        if (nArray[2] > 0 && !this._lastClockState) {
            ++this._currentOutput;
            if (this._currentOutput >= Math.min(nArray[1], 16)) {
                this._currentOutput = 0;
            }
        }
        this._lastClockState = nArray[2] > 0;
        int[] nArray2 = new int[16];
        nArray2[this._currentOutput] = nArray[0];
        return nArray2;
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.passthrough.roundrobin";
    }

    @Override
    public String getInputPinLabel(int n) {
        return n == 0 ? "I" : (n == 1 ? "CNT" : "CLK");
    }

    @Override
    public String getOutputPinLabel(int n) {
        return "O" + n;
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this._lastClockState = nBTTagCompound.func_74767_n("lastClockState");
        this._currentOutput = nBTTagCompound.func_74762_e("currentOutput");
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("lastClockState", this._lastClockState);
        nBTTagCompound.func_74768_a("currentOutput", this._currentOutput);
    }
}

