/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRocket
extends Entity {
    private int _ticksAlive = 0;
    private String _owner;
    private Entity _target;
    private NBTTagCompound _lostTarget = null;

    public EntityRocket(World world) {
        super(world);
    }

    public EntityRocket(World world, EntityLivingBase entityLivingBase) {
        this(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e(), entityLivingBase.field_70161_v, entityLivingBase.field_70177_z, entityLivingBase.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.recalculateVelocity();
        if (entityLivingBase instanceof EntityPlayer) {
            this._owner = ((EntityPlayer)entityLivingBase).func_70005_c_();
        }
    }

    public EntityRocket(World world, EntityLivingBase entityLivingBase, Entity entity) {
        this(world, entityLivingBase);
        this._target = entity;
    }

    private void recalculateVelocity() {
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        Vec3 vec3;
        super.func_70071_h_();
        ++this._ticksAlive;
        if (this._ticksAlive > 600) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3 vec32 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec33 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingObjectPosition = this.field_70170_p.func_72831_a(vec32, vec33, false, true);
            vec32 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec33 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingObjectPosition != null) {
                vec33 = this.field_70170_p.func_82732_R().func_72345_a(movingObjectPosition.field_72307_f.field_72450_a, movingObjectPosition.field_72307_f.field_72448_b, movingObjectPosition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d = 0.0;
            double d2 = 0.3;
            EntityPlayer entityPlayer = this._owner == null ? null : this.field_70170_p.func_72924_a(this._owner);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                double d3;
                AxisAlignedBB axisAlignedBB;
                MovingObjectPosition movingObjectPosition2;
                Entity entity2 = (Entity)list.get(i);
                if (!(entity2 != entityPlayer | this._ticksAlive > 5) || !entity2.func_70067_L() || (movingObjectPosition2 = (axisAlignedBB = entity2.field_70121_D.func_72314_b(d2, d2, d2)).func_72327_a(vec32, vec33)) == null || !((d3 = vec32.func_72438_d(movingObjectPosition2.field_72307_f)) < d | d == 0.0)) continue;
                entity = entity2;
                d = d3;
            }
            if (entity != null) {
                movingObjectPosition = new MovingObjectPosition(entity);
            }
            if (movingObjectPosition != null && movingObjectPosition.field_72308_g != null && movingObjectPosition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityPlayer2 = (EntityPlayer)movingObjectPosition.field_72308_g;
                if (entityPlayer2.field_71075_bZ.field_75102_a || entityPlayer != null && !entityPlayer.func_96122_a(entityPlayer2)) {
                    movingObjectPosition = null;
                }
            }
            if (movingObjectPosition != null && !this.field_70170_p.field_72995_K) {
                if (movingObjectPosition.field_72308_g != null) {
                    this.field_70170_p.func_72885_a((Entity)this, movingObjectPosition.field_72308_g.field_70165_t, movingObjectPosition.field_72308_g.field_70163_u, movingObjectPosition.field_72308_g.field_70161_v, 4.0f, true, true);
                } else {
                    this.field_70170_p.func_72885_a((Entity)this, (double)movingObjectPosition.field_72311_b, (double)movingObjectPosition.field_72312_c, (double)movingObjectPosition.field_72309_d, 4.0f, true, true);
                }
                this.func_70106_y();
            }
        }
        if ((vec3 = this.findTarget()) != null) {
            float f = this.clampAngle(360.0f - (float)(Math.atan2(vec3.field_72450_a, vec3.field_72449_c) * 180.0 / Math.PI), 360.0f, false);
            float f2 = this.clampAngle(-((float)(Math.atan2(vec3.field_72448_b, Math.sqrt(vec3.field_72450_a * vec3.field_72450_a + vec3.field_72449_c * vec3.field_72449_c)) * 180.0 / Math.PI)), 360.0f, false);
            float f3 = this.clampAngle(f - this.field_70177_z, 3.0f, true);
            float f4 = this.clampAngle(f2 - this.field_70125_A, 3.0f, true);
            float f5 = Math.max(f, this.field_70177_z) - Math.min(f, this.field_70177_z) > 180.0f ? this.field_70177_z - f3 : this.field_70177_z + f3;
            float f6 = Math.max(f2, this.field_70125_A) - Math.min(f2, this.field_70125_A) > 180.0f ? this.field_70125_A - f4 : this.field_70125_A + f4;
            this.field_70177_z = this.clampAngle(f5, 360.0f, false);
            this.field_70125_A = this.clampAngle(f6, 360.0f, false);
            this.recalculateVelocity();
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
    }

    private float clampAngle(float f, float f2, boolean bl) {
        f = f >= 0.0f ? (f %= 360.0f) : -(-f % 360.0f);
        if (f < 0.0f & !bl) {
            f += 360.0f;
        }
        if (Math.abs(f) > f2) {
            f = Math.copySign(f2, f);
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double d, double d2, double d3) {
        this.field_70159_w = d;
        this.field_70181_x = d2;
        this.field_70179_y = d3;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            double d4 = MathHelper.func_76133_a((double)(d * d + d3 * d3));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d3) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d2, d4) * 180.0 / Math.PI);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private Vec3 findTarget() {
        block3: {
            if (this._lostTarget != null) {
                UUID uUID = new UUID(this._lostTarget.func_74763_f("UUIDMost"), this._lostTarget.func_74763_f("UUIDLeast"));
                double d = this._lostTarget.func_74769_h("xTarget");
                double d2 = this._lostTarget.func_74769_h("yTarget");
                double d3 = this._lostTarget.func_74769_h("zTarget");
                List list = this.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72332_a().func_72299_a(d - 5.0, d2 - 5.0, d3 - 5.0, d + 5.0, d2 + 5.0, d3 + 5.0));
                for (Entity entity : list) {
                    if (!entity.func_110124_au().equals(uUID)) continue;
                    this._target = entity;
                    this._lostTarget = null;
                    break block3;
                }
                return this.field_70170_p.func_82732_R().func_72345_a(d - this.field_70165_t, d2 - this.field_70163_u, d3 - this.field_70161_v);
            }
        }
        if (this._target != null) {
            return this.field_70170_p.func_82732_R().func_72345_a(this._target.field_70165_t - this.field_70165_t, this._target.field_70163_u - this.field_70163_u + (double)this._target.func_70047_e(), this._target.field_70161_v - this.field_70161_v);
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound nBTTagCompound) {
        if (this._target != null) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound("target");
            nBTTagCompound.func_74780_a("xTarget", this._target.field_70165_t);
            nBTTagCompound.func_74780_a("yTarget", this._target.field_70163_u);
            nBTTagCompound.func_74780_a("zTarget", this._target.field_70161_v);
            UUID uUID = this._target.func_110124_au();
            nBTTagCompound.func_74772_a("UUIDMost", uUID.getMostSignificantBits());
            nBTTagCompound.func_74772_a("UUIDLeast", uUID.getLeastSignificantBits());
            nBTTagCompound.func_74766_a("target", nBTTagCompound2);
        }
        if (this._owner != null) {
            nBTTagCompound.func_74778_a("owner", this._owner);
        }
    }

    protected void func_70037_a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b("target")) {
            this._lostTarget = nBTTagCompound.func_74775_l("target");
        }
        if (nBTTagCompound.func_74764_b("owner")) {
            this._owner = nBTTagCompound.func_74779_i("owner");
        }
    }
}

