/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.farmables.grindables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.MobDrop;

public class GrindableSlime
implements IFactoryGrindable {
    protected Class<?> grindable;
    protected ArrayList<MobDrop> drops;
    protected int dropSize;

    public GrindableSlime(Class<?> clazz, MobDrop[] mobDropArray, int n) {
        this.grindable = clazz;
        ArrayList<MobDrop> arrayList = new ArrayList<MobDrop>();
        arrayList.addAll(Arrays.asList(mobDropArray));
        this.drops = arrayList;
        this.dropSize = n;
    }

    public GrindableSlime(Class<?> clazz, MobDrop mobDrop, int n) {
        this(clazz, new MobDrop[]{mobDrop}, n);
    }

    public GrindableSlime(Class<?> clazz, ItemStack[] itemStackArray, int n) {
        this.grindable = clazz;
        ArrayList<MobDrop> arrayList = new ArrayList<MobDrop>();
        for (ItemStack itemStack : itemStackArray) {
            arrayList.add(new MobDrop(10, itemStack));
        }
        this.drops = arrayList;
        this.dropSize = n;
    }

    public GrindableSlime(Class<?> clazz, ItemStack itemStack, int n) {
        this(clazz, new MobDrop[]{new MobDrop(10, itemStack)}, n);
    }

    @Override
    public Class<?> getGrindableEntity() {
        return this.grindable;
    }

    @Override
    public List<MobDrop> grind(World world, EntityLivingBase entityLivingBase, Random random) {
        if (((EntitySlime)entityLivingBase).func_70809_q() > this.dropSize) {
            return this.drops;
        }
        return null;
    }

    @Override
    public boolean processEntity(EntityLivingBase entityLivingBase) {
        return false;
    }
}

