/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.bop;

import com.google.common.base.Optional;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableSapling;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.bop.FruitLeaves;

@Mod(modid="MineFactoryReloaded|CompatBiomesOPlenty", name="MFR Compat: Biomes O' Plenty", version="1.6.2R2.7.1", dependencies="after:MineFactoryReloaded;after:BiomesOPlenty")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class BiomesOPlenty {
    @Mod.EventHandler
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        if (!Loader.isModLoaded((String)"BiomesOPlenty")) {
            FMLLog.warning((String)"BiomesOPlenty missing - MFR Biomes O' Plenty Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            BiomesOPlenty.registerRubberTreeBiomes();
            BiomesOPlenty.registerFarmables();
            BiomesOPlenty.registerSludgeDrops();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void registerRubberTreeBiomes() throws Throwable {
        String[] stringArray = new String[]{"bayou", "birchForest", "bog", "borealForest", "deciduousForest", "forestNew", "grove", "jungleNew", "lushSwamp", "mapleWoods", "rainforest", "seasonalForest", "shield", "swamplandNew", "temperateRainforest", "thicket", "tropicalRainforest", "woodland"};
        Class<?> clazz = Class.forName("biomesoplenty.api.Biomes");
        for (String string : stringArray) {
            BiomeGenBase biomeGenBase = (BiomeGenBase)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerRubberTreeBiome(biomeGenBase.field_76791_y);
        }
    }

    private static void registerFarmables() throws Throwable {
        Optional optional;
        String[] stringArray = new String[]{"leaves1", "leaves2", "leavesColorized", "treeMoss", "willow", "ivy", "moss"};
        String[] stringArray2 = new String[]{"leavesFruit"};
        String[] stringArray3 = new String[]{"logs1", "logs2", "logs3", "logs4", "bamboo"};
        String[] stringArray4 = new String[]{"flowers", "plants", "foliage", "mushrooms"};
        String[] stringArray5 = new String[]{"saplings", "colorizedSaplings"};
        Class<?> clazz = Class.forName("biomesoplenty.api.Blocks");
        for (String string : stringArray) {
            optional = (Optional)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerHarvestable(new HarvestableTreeLeaves(((Block)optional.get()).field_71990_ca));
        }
        for (String string : stringArray3) {
            optional = (Optional)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)optional.get()).field_71990_ca, HarvestType.Tree));
        }
        for (String string : stringArray4) {
            optional = (Optional)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)optional.get()).field_71990_ca, HarvestType.Normal));
        }
        for (String string : stringArray5) {
            optional = (Optional)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerPlantable(new PlantableStandard(((Block)optional.get()).field_71990_ca, ((Block)optional.get()).field_71990_ca));
            MFRRegistry.registerFertilizable(new FertilizableSapling(((Block)optional.get()).field_71990_ca));
        }
        for (String string : stringArray2) {
            optional = (Optional)clazz.getDeclaredField(string).get(null);
            MFRRegistry.registerHarvestable(new HarvestableTreeLeaves(((Block)optional.get()).field_71990_ca));
            MFRRegistry.registerFruit(new FruitLeaves(((Block)optional.get()).field_71990_ca));
        }
    }

    private static void registerSludgeDrops() throws Throwable {
        Class<?> clazz = Class.forName("biomesoplenty.api.BlockReferences");
        Method method = clazz.getDeclaredMethod("getBlockItemStack", String.class);
        MFRRegistry.registerSludgeDrop(15, (ItemStack)method.invoke(null, "driedDirt"));
        MFRRegistry.registerSludgeDrop(15, (ItemStack)method.invoke(null, "hardSand"));
        MFRRegistry.registerSludgeDrop(15, (ItemStack)method.invoke(null, "hardDirt"));
        clazz = Class.forName("biomesoplenty.api.Items");
        MFRRegistry.registerSludgeDrop(15, new ItemStack((Item)((Optional)clazz.getDeclaredField("miscItems").get(null)).get(), 4, 1));
        MFRRegistry.registerSludgeDrop(25, new ItemStack((Item)((Optional)clazz.getDeclaredField("mudBall").get(null)).get(), 4));
    }
}

