/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.gates.IAction;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.core.asm.relauncher.Implementable;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

@Implementable(value="buildcraft.core.IMachine")
public abstract class TileEntityFactoryInventory
extends TileEntityFactory
implements ISidedInventory {
    protected Machine machine;
    protected String _invName;
    protected boolean _hasInvName = false;
    protected FluidTank _tank;
    protected ItemStack[] _inventory = new ItemStack[this.func_70302_i_()];

    protected TileEntityFactoryInventory(Machine machine) {
        this.machine = machine;
    }

    public String func_70303_b() {
        return this._hasInvName ? this._invName : StatCollector.func_74838_a((String)(this.machine.getInternalName() + ".name"));
    }

    public boolean func_94042_c() {
        return this._hasInvName;
    }

    public void setInvName(String string) {
        this._invName = string;
        this._hasInvName = string != null && string.length() > 0;
    }

    public void onBlockBroken() {
        if (this.func_94042_c()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74778_a("Name", this.func_70303_b());
            nBTTagCompound.func_74782_a("display", (NBTBase)nBTTagCompound2);
            BlockNBTManager.setForBlock(new BlockPosition(this.field_70329_l, this.field_70330_m, this.field_70327_n), nBTTagCompound);
        }
    }

    public IFluidTank getTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
        return this._tank;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        IFluidTank[] iFluidTankArray = this.getTanks();
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[iFluidTankArray.length];
        int n = iFluidTankArray.length;
        while (n-- > 0) {
            fluidTankInfoArray[n] = iFluidTankArray[n].getInfo();
        }
        return fluidTankInfoArray;
    }

    public IFluidTank[] getTanks() {
        if (this._tank != null) {
            return new IFluidTank[]{this._tank};
        }
        return new IFluidTank[0];
    }

    protected boolean shouldPumpLiquid() {
        return false;
    }

    public boolean allowBucketFill() {
        return false;
    }

    public boolean allowBucketDrain() {
        return false;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.shouldPumpLiquid()) {
            for (IFluidTank iFluidTank : this.getTanks()) {
                MFRLiquidMover.pumpLiquid(iFluidTank, this);
            }
        }
    }

    public ItemStack func_70301_a(int n) {
        return this._inventory[n];
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int n, int n2) {
        if (this._inventory[n] != null) {
            if (this._inventory[n].field_77994_a <= n2) {
                ItemStack itemStack = this._inventory[n];
                this._inventory[n] = null;
                this.onFactoryInventoryChanged();
                return itemStack;
            }
            ItemStack itemStack = this._inventory[n].func_77979_a(n2);
            if (this._inventory[n].field_77994_a == 0) {
                this._inventory[n] = null;
            }
            this.onFactoryInventoryChanged();
            return itemStack;
        }
        this.onFactoryInventoryChanged();
        return null;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        this._inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.onFactoryInventoryChanged();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.onFactoryInventoryChanged();
    }

    protected void onFactoryInventoryChanged() {
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        FluidTank fluidTank;
        super.func_70307_a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.func_74761_m("Items");
        this._inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound3 = (NBTTagCompound)nBTTagList.func_74743_b(i);
            int n = nBTTagCompound3.func_74771_c("Slot") & 0xFF;
            if (n < 0 || n >= this._inventory.length) continue;
            ItemStack itemStack = new ItemStack(0, 0, 0);
            itemStack.func_77963_c(nBTTagCompound3);
            this._inventory[n] = itemStack;
        }
        this.onFactoryInventoryChanged();
        if (nBTTagCompound.func_74764_b("mTanks")) {
            fluidTank = this.getTanks();
            nBTTagList = nBTTagCompound.func_74761_m("mTanks");
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                FluidStack fluidStack;
                NBTTagCompound nBTTagCompound4 = (NBTTagCompound)nBTTagList.func_74743_b(i);
                int n = nBTTagCompound4.func_74771_c("Tank") & 0xFF;
                if (n < 0 || n >= ((FluidTank)fluidTank).length || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound4)) == null) continue;
                fluidTank[n].setFluid(fluidStack);
            }
        } else {
            fluidTank = this._tank;
            if (fluidTank != null && nBTTagCompound.func_74764_b("tankFluidName")) {
                int n = nBTTagCompound.func_74762_e("tankAmount");
                FluidStack fluidStack = FluidRegistry.getFluidStack((String)nBTTagCompound.func_74779_i("tankFluidName"), (int)n);
                if (fluidStack != null) {
                    if (fluidStack.amount > fluidTank.getCapacity()) {
                        fluidStack.amount = fluidTank.getCapacity();
                    }
                    fluidTank.setFluid(fluidStack);
                }
                nBTTagCompound.func_82580_o("tankFluidName");
                nBTTagCompound.func_82580_o("tankAmount");
            }
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this._inventory[i] == null || this._inventory[i].func_77973_b() != null) continue;
            this._inventory[i] = null;
        }
        if (nBTTagCompound.func_74764_b("display") && (nBTTagCompound2 = nBTTagCompound.func_74775_l("display")).func_74764_b("Name")) {
            this.setInvName(nBTTagCompound2.func_74779_i("Name"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        super.func_70310_b(nBTTagCompound);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (int i = 0; i < this._inventory.length; ++i) {
            if (this._inventory[i] == null) continue;
            nBTTagList = new NBTTagCompound();
            nBTTagList.func_74774_a("Slot", (byte)i);
            this._inventory[i].func_77955_b((NBTTagCompound)nBTTagList);
            nBTTagList2.func_74742_a((NBTBase)nBTTagList);
        }
        IFluidTank[] iFluidTankArray = this.getTanks();
        nBTTagList = new NBTTagList();
        int n = iFluidTankArray.length;
        for (int i = 0; i < n; ++i) {
            if (iFluidTankArray[i].getFluid() == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74774_a("Tank", (byte)i);
            FluidStack fluidStack = iFluidTankArray[i].getFluid();
            fluidStack.writeToNBT(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("mTanks", (NBTBase)nBTTagList);
        if (this.func_94042_c()) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.func_74778_a("Name", this.func_70303_b());
            nBTTagCompound.func_74766_a("display", nBTTagCompound3);
        }
        nBTTagCompound.func_74782_a("Items", (NBTBase)nBTTagList2);
    }

    public ItemStack func_70304_b(int n) {
        return null;
    }

    public boolean shouldDropSlotWhenBroken(int n) {
        return true;
    }

    public int[] func_94128_d(int n) {
        int n2 = this.getStartInventorySide(ForgeDirection.getOrientation((int)n));
        int n3 = this.getSizeInventorySide(ForgeDirection.getOrientation((int)n));
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i + n2;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return this.func_70302_i_();
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.func_94041_b(n, itemStack);
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return true;
    }

    public float getComparatorOutput(int n) {
        int[] nArray = this.func_94128_d(n);
        int n2 = 0;
        float f = 0.0f;
        int n3 = nArray.length;
        while (n3-- > 0) {
            if (!this.func_102007_a(nArray[n3], null, n)) continue;
            ItemStack itemStack = this.func_70301_a(nArray[n3]);
            if (itemStack != null) {
                float f2 = Math.min(itemStack.func_77976_d(), this.func_70297_j_());
                f += Math.max(Math.min((float)itemStack.field_77994_a / f2, 1.0f), 0.0f);
            }
            ++n2;
        }
        return f / (float)n2;
    }

    public boolean isActive() {
        return false;
    }

    public boolean manageFluids() {
        return false;
    }

    public boolean manageSolids() {
        return false;
    }

    public boolean allowActions() {
        return false;
    }

    public boolean allowAction(IAction iAction) {
        return this.allowActions();
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.FLUID && this.manageFluids()) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        if (pipeType == IPipeTile.PipeType.ITEM && this.manageSolids()) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }
}

