/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public abstract class TileEntityGenerator
extends TileEntityFactoryInventory
implements IPowerReceptor,
IPowerEmitter {
    private PowerHandler _powerProvider = new PowerHandler(this, PowerHandler.Type.GATE);

    protected TileEntityGenerator(Machine machine) {
        super(machine);
        this._powerProvider.configure(0.0f, 0.0f, 0.0f, 0.0f);
        this._powerProvider.setPerdition(TileEntityFactoryPowered.MFRPerdition.DEFAULT);
    }

    protected final int producePower(int n) {
        BlockPosition blockPosition = BlockPosition.fromFactoryTile((IRotateableTile)this);
        for (BlockPosition blockPosition2 : blockPosition.getAdjacent(true)) {
            IPowerReceptor iPowerReceptor;
            PowerHandler.PowerReceiver powerReceiver;
            TileEntity tileEntity = this.field_70331_k.func_72796_p(blockPosition2.x, blockPosition2.y, blockPosition2.z);
            if (tileEntity == null || !(tileEntity instanceof IPowerReceptor) || (powerReceiver = (iPowerReceptor = (IPowerReceptor)tileEntity).getPowerReceiver(blockPosition2.orientation.getOpposite())) == null || !(powerReceiver.powerRequest() > 0.0f) || !(powerReceiver.getMinEnergyReceived() <= (float)n)) continue;
            float f = Math.min(Math.min(powerReceiver.getMaxEnergyReceived(), (float)n), powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored());
            powerReceiver.receiveEnergy(this._powerProvider.getPowerReceiver().getType(), f, blockPosition2.orientation.getOpposite());
            if ((n = (int)((float)n - f)) > 0) continue;
            return 0;
        }
        return n;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        return this._powerProvider.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler powerHandler) {
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection forgeDirection) {
        return true;
    }
}

