/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public abstract class TileEntityLiquidFabricator
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private int _liquidId;
    private int _liquidFabPerTick;

    protected TileEntityLiquidFabricator(int n, int n2, Machine machine) {
        super(machine, machine.getActivationEnergyMJ() * n2);
        this._liquidId = n;
        this._liquidFabPerTick = n2;
        this._tank = new FluidTank(1000);
    }

    @Override
    protected boolean activateMachine() {
        if (this._liquidId < 0) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        if (this._tank.getFluid() != null && this._tank.getCapacity() - this._tank.getFluid().amount < this._liquidFabPerTick) {
            return false;
        }
        this._tank.fill(new FluidStack(this._liquidId, this._liquidFabPerTick), true);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 0;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this._tank.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && fluidStack.isFluidEqual(this._tank.getFluid())) {
            return this._tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

