/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoBrewer;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoBrewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoBrewer
extends TileEntityFactoryPowered {
    public TileEntityAutoBrewer() {
        super(Machine.AutoBrewer);
    }

    private int getProcessSlot(int n) {
        return n * 5;
    }

    private int getTemplateSlot(int n) {
        return n * 5 + 1;
    }

    private int getResourceSlot(int n, int n2) {
        return n * 5 + n2 + 2;
    }

    public int func_70302_i_() {
        return 31;
    }

    @Override
    public String getGuiBackground() {
        return "autobrewer.png";
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoBrewer(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoBrewer(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        int n;
        if (this._inventory[30] != null) {
            return false;
        }
        boolean bl = false;
        for (n = 0; n < 6; ++n) {
            if (this._inventory[this.getProcessSlot(n)] == null || this._inventory[this.getProcessSlot(n + 1)] != null || !this.canBrew(n)) continue;
            bl = true;
        }
        if (!bl) {
            this.setWorkDone(0);
            return false;
        }
        if (this.getWorkDone() < this.getWorkMax()) {
            this.setWorkDone(this.getWorkDone() + 1);
            return true;
        }
        this.setWorkDone(0);
        block1: for (n = 5; n >= 0; --n) {
            ItemStack itemStack = this._inventory[this.getProcessSlot(n)];
            ItemStack itemStack2 = this._inventory[this.getProcessSlot(n + 1)];
            if (itemStack2 != null && itemStack != null) {
                return n < 5;
            }
            ItemStack itemStack3 = this._inventory[this.getTemplateSlot(n)];
            if (this._inventory[this.getProcessSlot(n)] == null || !(this._inventory[this.getProcessSlot(n)].func_77973_b() instanceof ItemPotion)) continue;
            int n2 = this._inventory[this.getProcessSlot(n)].func_77960_j();
            int n3 = this.getPotionResult(n2, itemStack3);
            List list = Item.field_77726_bs.func_77834_f(n2);
            List list2 = Item.field_77726_bs.func_77834_f(n3);
            if (!(n2 > 0 && list == list2 || list != null && (list.equals(list2) || list2 == null))) {
                if (n2 != n3) {
                    this._inventory[this.getProcessSlot(n)].func_77964_b(n3);
                }
            } else if (!ItemPotion.func_77831_g((int)n2) && ItemPotion.func_77831_g((int)n3)) {
                this._inventory[this.getProcessSlot(n)].func_77964_b(n3);
            }
            this._inventory[this.getProcessSlot((int)(n + 1))] = this._inventory[this.getProcessSlot(n)];
            this._inventory[this.getProcessSlot((int)n)] = null;
            for (int i = 0; i < 3; ++i) {
                if (!UtilInventory.stacksEqual((ItemStack)this._inventory[this.getResourceSlot(n, i)], (ItemStack)itemStack3)) continue;
                if (Item.field_77698_e[itemStack3.field_77993_c].func_77634_r()) {
                    this._inventory[this.getResourceSlot((int)n, (int)i)] = Item.field_77698_e[itemStack3.field_77993_c].getContainerItemStack(this._inventory[this.getResourceSlot(n, i)]);
                    continue block1;
                }
                --this._inventory[this.getResourceSlot((int)n, (int)i)].field_77994_a;
                if (this._inventory[this.getResourceSlot((int)n, (int)i)].field_77994_a > 0) continue block1;
                this._inventory[this.getResourceSlot((int)n, (int)i)] = null;
                continue block1;
            }
        }
        return true;
    }

    private boolean canBrew(int n) {
        if (this._inventory[this.getTemplateSlot(n)] == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            if (!UtilInventory.stacksEqual((ItemStack)this._inventory[this.getTemplateSlot(n)], (ItemStack)this._inventory[this.getResourceSlot(n, i)])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        ItemStack itemStack = this._inventory[this.getTemplateSlot(n)];
        if (!Item.field_77698_e[itemStack.field_77993_c].func_77632_u()) {
            return false;
        }
        if (this._inventory[this.getProcessSlot(n)] != null && this._inventory[this.getProcessSlot(n)].func_77973_b() instanceof ItemPotion) {
            int n2 = this._inventory[this.getProcessSlot(n)].func_77960_j();
            int n3 = this.getPotionResult(n2, itemStack);
            if (!ItemPotion.func_77831_g((int)n2) && ItemPotion.func_77831_g((int)n3)) {
                return true;
            }
            List list = Item.field_77726_bs.func_77834_f(n2);
            List list2 = Item.field_77726_bs.func_77834_f(n3);
            if (!(n2 > 0 && list == list2 || list != null && (list.equals(list2) || list2 == null) || n2 == n3)) {
                return true;
            }
        }
        return false;
    }

    private int getPotionResult(int n, ItemStack itemStack) {
        if (itemStack == null || !Item.field_77698_e[itemStack.field_77993_c].func_77632_u()) {
            return n;
        }
        return PotionHelper.func_77913_a((int)n, (String)Item.field_77698_e[itemStack.field_77993_c].func_77666_t());
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 160;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        int n3 = n / 5;
        int n4 = n % 5;
        if (itemStack == null) {
            return false;
        }
        if (n3 == 6) {
            return false;
        }
        if (n4 == 1) {
            return false;
        }
        if (n4 == 0) {
            return this._inventory[this.getTemplateSlot(n3)] != null && Item.field_77698_e[itemStack.field_77993_c] instanceof ItemPotion && (n3 == 0 || this._inventory[this.getTemplateSlot(n3 - 1)] == null);
        }
        return UtilInventory.stacksEqual((ItemStack)this._inventory[this.getTemplateSlot(n3)], (ItemStack)itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        int n3 = n / 5;
        int n4 = n % 5;
        if (n3 == 6) {
            return true;
        }
        if (n4 == 1) {
            return false;
        }
        if (n4 == 0) {
            return this._inventory[this.getTemplateSlot(n3)] == null;
        }
        return !UtilInventory.stacksEqual((ItemStack)this._inventory[this.getTemplateSlot(n3)], (ItemStack)itemStack);
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n % 5 != 1;
    }
}

