/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomItem;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLaserDrill;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLaserDrill;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLaserDrill
extends TileEntityFactoryInventory {
    private static final int _energyPerWork = Machine.LaserDrillPrecharger.getActivationEnergyMJ() * 10 * 4;
    private static final int _energyDrawMax = 20000;
    private static final int _energyStoredMax = 1000000;
    private int _energyStored;
    private int _workStoredMax = MFRConfig.laserdrillCost.getInt();
    private float _workStored;
    private int _bedrockLevel;
    private Random _rand = new Random();

    public TileEntityLaserDrill() {
        super(Machine.LaserDrill);
    }

    @Override
    public String getGuiBackground() {
        return "laserdrill.png";
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLaserDrill(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLaserDrill(this.getContainer(inventoryPlayer), this);
    }

    public int addEnergy(int n) {
        int n2 = Math.min(n, 1000000 - this._energyStored);
        this._energyStored += n2;
        return n - n2;
    }

    @Override
    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K || this.func_70320_p()) {
            return;
        }
        if (this.shouldCheckDrill()) {
            this.updateDrill();
        }
        int n = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (this._bedrockLevel < 0) {
            if (n == MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca) {
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            }
            return;
        }
        if (n != MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca && (Block.field_71973_m[n] == null || Block.field_71973_m[n].isAirBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n))) {
            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca);
        }
        int n2 = Math.min(20000, this._energyStored);
        float f = (float)((double)_energyPerWork * (1.0 - 0.2 * Math.min((double)(this.field_70330_m - this._bedrockLevel), 128.0) / 128.0));
        float f2 = (float)n2 / f;
        this._workStored += f2;
        this._energyStored = (int)((float)this._energyStored - f2 * f);
        while (this._workStored >= (float)this._workStoredMax) {
            this._workStored -= (float)this._workStoredMax;
            UtilInventory.dropStack((TileEntity)this, (ItemStack)this.getRandomDrop(), (ForgeDirection)ForgeDirection.UP);
        }
    }

    public int getWorkDone() {
        return (int)this._workStored;
    }

    public void setWorkDone(int n) {
        this._workStored = n;
    }

    public int getWorkMax() {
        return this._workStoredMax;
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public int getEnergyMax() {
        return 1000000;
    }

    private boolean shouldCheckDrill() {
        return this.field_70331_k.func_72820_D() % 32L == 0L;
    }

    private void updateDrill() {
        int n = Integer.MAX_VALUE;
        for (n = this.field_70330_m - 1; n >= 0; --n) {
            int n2 = this.field_70331_k.func_72798_a(this.field_70329_l, n, this.field_70327_n);
            if (n2 != MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca && n2 != Block.field_71986_z.field_71990_ca && n2 != 0) {
                this._bedrockLevel = -1;
                return;
            }
            if (n2 != Block.field_71986_z.field_71990_ca) continue;
            this._bedrockLevel = n;
            return;
        }
        this._bedrockLevel = 0;
    }

    private ItemStack getRandomDrop() {
        LinkedList<WeightedRandomItemStack> linkedList = new LinkedList<WeightedRandomItemStack>();
        int n = WeightedRandom.func_76272_a(MFRRegistry.getLaserOres()) / 30;
        for (WeightedRandomItem weightedRandomItem : MFRRegistry.getLaserOres()) {
            WeightedRandomItemStack weightedRandomItemStack = (WeightedRandomItemStack)weightedRandomItem;
            WeightedRandomItemStack weightedRandomItemStack2 = new WeightedRandomItemStack(weightedRandomItemStack.field_76292_a, weightedRandomItemStack.getStack());
            linkedList.add(weightedRandomItemStack2);
            for (ItemStack itemStack : this._inventory) {
                if (itemStack == null || itemStack.field_77993_c != MineFactoryReloadedCore.laserFocusItem.field_77779_bT || MFRRegistry.getLaserPreferredOres(itemStack.func_77960_j()) == null) continue;
                List<ItemStack> list = MFRRegistry.getLaserPreferredOres(itemStack.func_77960_j());
                for (ItemStack itemStack2 : list) {
                    if (!UtilInventory.stacksEqual((ItemStack)weightedRandomItemStack2.getStack(), (ItemStack)itemStack2)) continue;
                    weightedRandomItemStack2.field_76292_a += n;
                }
            }
        }
        return ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)this._rand, linkedList)).getStack();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return 65536.0;
    }

    public boolean shouldDrawBeam() {
        this.updateDrill();
        return this._bedrockLevel >= 0;
    }

    public int getBeamHeight() {
        return this.field_70330_m - this._bedrockLevel;
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

