/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.RemoteInventoryCrafting;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquiCrafter;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquiCrafter;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLiquiCrafter
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private boolean _lastRedstoneState;
    private boolean _resourcesChangedSinceLastFailedCraft = true;
    private FluidTank[] _tanks = new FluidTank[9];

    public TileEntityLiquiCrafter() {
        super(Machine.LiquiCrafter);
        for (int i = 0; i < 9; ++i) {
            this._tanks[i] = new FluidTank(10000);
        }
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n > 9;
    }

    @Override
    public String getGuiBackground() {
        return "liquicrafter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquiCrafter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquiCrafter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquiCrafter(this, inventoryPlayer);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean bl = Util.isRedstonePowered((TileEntity)this);
        if (bl && !this._lastRedstoneState && !this.field_70331_k.field_72995_K && this._resourcesChangedSinceLastFailedCraft && this._inventory[9] != null && (this._inventory[10] == null || this._inventory[10].field_77994_a + this._inventory[9].field_77994_a <= this._inventory[9].func_77976_d() && this._inventory[9].field_77993_c == this._inventory[10].field_77993_c && this._inventory[9].func_77960_j() == this._inventory[10].func_77960_j())) {
            this.checkResources();
        }
        this._lastRedstoneState = bl;
    }

    private void checkResources() {
        int n;
        int n2;
        LinkedList<ItemResourceTracker> linkedList = new LinkedList<ItemResourceTracker>();
        block0: for (n2 = 0; n2 < 9; ++n2) {
            FluidStack fluidStack;
            if (this._inventory[n2] == null) continue;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)this._inventory[n2]) && (fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this._inventory[n2])) != null) {
                for (ItemResourceTracker itemResourceTracker : linkedList) {
                    if (!itemResourceTracker.isFluid || !itemResourceTracker.fluid.isFluidEqual(fluidStack)) continue;
                    itemResourceTracker.required += fluidStack.amount;
                    continue block0;
                }
                linkedList.add(new ItemResourceTracker(fluidStack, fluidStack.amount));
                continue;
            }
            for (ItemResourceTracker itemResourceTracker : linkedList) {
                if (itemResourceTracker.id != this._inventory[n2].field_77993_c || itemResourceTracker.meta != this._inventory[n2].func_77960_j()) continue;
                ++itemResourceTracker.required;
                continue block0;
            }
            linkedList.add(new ItemResourceTracker(this._inventory[n2].field_77993_c, this._inventory[n2].func_77960_j(), this._inventory[n2].func_77978_p(), 1));
        }
        block3: for (n2 = 11; n2 < 29; ++n2) {
            ItemStack itemStack = this._inventory[n2];
            if (itemStack == null) continue;
            for (ItemResourceTracker itemResourceTracker : linkedList) {
                if (itemResourceTracker.id != itemStack.field_77993_c || itemResourceTracker.meta != itemStack.func_77960_j() && !itemStack.func_77973_b().func_77645_m()) continue;
                if (!itemStack.func_77973_b().func_77634_r()) {
                    itemResourceTracker.found += itemStack.field_77994_a;
                    continue block3;
                }
                ++itemResourceTracker.found;
                continue block3;
            }
        }
        block5: for (n2 = 0; n2 < this._tanks.length; ++n2) {
            FluidStack fluidStack = this._tanks[n2].getFluid();
            if (fluidStack == null || fluidStack.amount == 0) continue;
            for (ItemResourceTracker itemResourceTracker : linkedList) {
                if (!itemResourceTracker.isFluid || !fluidStack.isFluidEqual(itemResourceTracker.fluid)) continue;
                itemResourceTracker.found += fluidStack.amount;
                continue block5;
            }
        }
        for (ItemResourceTracker itemResourceTracker : linkedList) {
            if (itemResourceTracker.found >= itemResourceTracker.required) continue;
            this._resourcesChangedSinceLastFailedCraft = false;
            return;
        }
        block8: for (n = 11; n < 29; ++n) {
            if (this._inventory[n] == null) continue;
            for (ItemResourceTracker itemResourceTracker : linkedList) {
                int n3;
                if (itemResourceTracker.id != this._inventory[n].field_77993_c || itemResourceTracker.meta != this._inventory[n].func_77960_j() && !this._inventory[n].func_77973_b().func_77645_m()) continue;
                if (this._inventory[n].func_77973_b().func_77634_r()) {
                    n3 = 1;
                    ItemStack itemStack = this._inventory[n].func_77973_b().getContainerItemStack(this._inventory[n]);
                    this._inventory[n] = itemStack.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k() ? null : itemStack;
                } else {
                    n3 = Math.min(itemResourceTracker.required, this._inventory[n].field_77994_a);
                    this._inventory[n].field_77994_a -= n3;
                }
                itemResourceTracker.required -= n3;
                if (this._inventory[n] != null && this._inventory[n].field_77994_a == 0) {
                    this._inventory[n] = null;
                }
                if (itemResourceTracker.required != 0) continue block8;
                linkedList.remove(itemResourceTracker);
                continue block8;
            }
        }
        block10: for (n = 0; n < this._tanks.length; ++n) {
            FluidStack fluidStack = this._tanks[n].getFluid();
            if (fluidStack == null || fluidStack.amount == 0) continue;
            for (ItemResourceTracker itemResourceTracker : linkedList) {
                if (!fluidStack.isFluidEqual(itemResourceTracker.fluid)) continue;
                int n4 = Math.min(itemResourceTracker.required, fluidStack.amount);
                this._tanks[n].drain(n4, true);
                itemResourceTracker.required -= n4;
                if (itemResourceTracker.required != 0) continue block10;
                linkedList.remove(itemResourceTracker);
                continue block10;
            }
        }
        if (this._inventory[10] == null) {
            this._inventory[10] = this._inventory[9].func_77946_l();
            this._inventory[10].field_77994_a = this._inventory[9].field_77994_a;
        } else {
            this._inventory[10].field_77994_a += this._inventory[9].field_77994_a;
        }
    }

    private void calculateOutput() {
        this._inventory[9] = this.findMatchingRecipe();
    }

    public int func_70302_i_() {
        return 29;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this._inventory[n] = itemStack;
        if (n < 9) {
            this.calculateOutput();
        }
        this.onFactoryInventoryChanged();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        ItemStack itemStack = super.func_70298_a(n, n2);
        if (n < 9) {
            this.calculateOutput();
        }
        this.onFactoryInventoryChanged();
        return itemStack;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) <= 64.0;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 10;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 19;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n > 10;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 10;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._resourcesChangedSinceLastFailedCraft = true;
        super.onFactoryInventoryChanged();
    }

    @Override
    public boolean allowBucketFill() {
        return false;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = this.findFirstMatchingTank(fluidStack);
        if (n >= 0) {
            int n2 = this._tanks[n].fill(fluidStack, bl);
            if (n2 > 0) {
                this._resourcesChangedSinceLastFailedCraft = true;
            }
            return n2;
        }
        n = this.findFirstEmptyTank();
        if (n >= 0) {
            int n3 = this._tanks[n].fill(fluidStack, bl);
            if (n3 > 0) {
                this._resourcesChangedSinceLastFailedCraft = true;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return false;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        int n2 = this.findFirstNonEmptyTank();
        if (n2 >= 0) {
            return this._tanks[n2].drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = this.findFirstMatchingTank(fluidStack);
        if (n >= 0) {
            return this._tanks[n].drain(fluidStack.amount, bl);
        }
        return null;
    }

    @Override
    public IFluidTank getTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
        int n = this.findFirstMatchingTank(fluidStack);
        if (n >= 0) {
            return this._tanks[n];
        }
        n = this.findFirstEmptyTank();
        if (n >= 0) {
            return this._tanks[n];
        }
        return null;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[this._tanks.length];
        int n = this._tanks.length;
        while (n-- > 0) {
            fluidTankInfoArray[n] = this._tanks[n].getInfo();
        }
        return fluidTankInfoArray;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFluidTank[] getTanks() {
        return this._tanks;
    }

    private int findFirstEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getFluid() != null && this._tanks[i].getFluid().amount != 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstNonEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getFluid() == null || this._tanks[i].getFluid().amount <= 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstMatchingTank(FluidStack fluidStack) {
        if (fluidStack == null) {
            return -1;
        }
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getFluid() == null || !fluidStack.isFluidEqual(this._tanks[i].getFluid())) continue;
            return i;
        }
        return -1;
    }

    private ItemStack findMatchingRecipe() {
        RemoteInventoryCrafting remoteInventoryCrafting = new RemoteInventoryCrafting();
        for (int i = 0; i < 9; ++i) {
            remoteInventoryCrafting.func_70299_a(i, this._inventory[i] == null ? null : this._inventory[i].func_77946_l());
        }
        return CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)remoteInventoryCrafting, this.field_70331_k);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.func_74761_m("Tanks");
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            FluidStack fluidStack;
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.func_74743_b(i);
            int n = nBTTagCompound2.func_74771_c("Tank") & 0xFF;
            if (n < 0 || n >= this._tanks.length || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) continue;
            this._tanks[n].setFluid(fluidStack);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this._tanks.length; ++i) {
            if (this._tanks[i].getFluid() == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74774_a("Tank", (byte)i);
            FluidStack fluidStack = this._tanks[i].getFluid();
            fluidStack.writeToNBT(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Tanks", (NBTBase)nBTTagList);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    private class ItemResourceTracker {
        public boolean isFluid;
        public FluidStack fluid;
        public int id;
        public int meta;
        public NBTTagCompound tag;
        public int required;
        public int found;

        public ItemResourceTracker(int n, int n2, NBTTagCompound nBTTagCompound, int n3) {
            this.id = n;
            this.meta = n2;
            this.required = n3;
            this.tag = nBTTagCompound;
            this.isFluid = false;
        }

        public ItemResourceTracker(FluidStack fluidStack, int n) {
            this.fluid = fluidStack;
            this.required = n;
            this.isFluid = true;
        }
    }
}

