/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.RanchedItem;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityRancher
extends TileEntityFactoryPowered
implements ITankContainerBucketable,
IHarvestAreaContainer {
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 2, 2, 1);

    public TileEntityRancher() {
        super(Machine.Rancher);
        this._tank = new FluidTank(4000);
    }

    @Override
    public String getGuiBackground() {
        return "rancher.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public HarvestAreaManager getHAM() {
        return this._areaManager;
    }

    @Override
    public boolean activateMachine() {
        MFRLiquidMover.pumpLiquid((IFluidTank)this._tank, this);
        boolean bl = false;
        List list = this.field_70331_k.func_72872_a(EntityLivingBase.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        for (Object e : list) {
            IFactoryRanchable iFactoryRanchable;
            List<RanchedItem> list2;
            EntityLivingBase entityLivingBase = (EntityLivingBase)e;
            if (!MFRRegistry.getRanchables().containsKey(entityLivingBase.getClass()) || (list2 = (iFactoryRanchable = MFRRegistry.getRanchables().get(entityLivingBase.getClass())).ranch(this.field_70331_k, entityLivingBase, (IInventory)this)) == null) continue;
            for (RanchedItem ranchedItem : list2) {
                if (ranchedItem.hasFluid()) {
                    this._tank.fill((FluidStack)ranchedItem.getResult(), true);
                    bl = true;
                    continue;
                }
                this.doDrop((ItemStack)ranchedItem.getResult());
                bl = true;
            }
            if (!bl) continue;
            this.setIdleTicks(20);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    public int func_70302_i_() {
        return 9;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this._tank.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && fluidStack.isFluidEqual(this._tank.getFluid())) {
            return this._tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    @Override
    public IFluidTank getTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
        return this._tank;
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

