/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.oredict.OreDictTracker;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUnifier;
import powercrystals.minefactoryreloaded.gui.container.ContainerUnifier;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityUnifier
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private static FluidStack _biofuel;
    private static FluidStack _ethanol;
    private static FluidStack _essence;
    private static FluidStack _liquidxp;
    private int _roundingCompensation;
    private Map<String, ItemStack> _preferredOutputs = new HashMap<String, ItemStack>();

    public TileEntityUnifier() {
        super(Machine.Unifier);
        this._tank = new FluidTank(4000);
        this._roundingCompensation = 1;
    }

    public static void updateUnifierLiquids() {
        _biofuel = FluidRegistry.getFluidStack((String)"biofuel", (int)1);
        _ethanol = FluidRegistry.getFluidStack((String)"ethanol", (int)1);
        _essence = FluidRegistry.getFluidStack((String)"mobessence", (int)1);
        _liquidxp = FluidRegistry.getFluidStack((String)"immibis.liquidxp", (int)1);
    }

    @Override
    public String getGuiBackground() {
        return "unifier.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUnifier(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerUnifier getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUnifier(this, inventoryPlayer);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            ItemStack itemStack = null;
            if (this._inventory[0] != null) {
                List list = OreDictTracker.getNamesFromItem((ItemStack)this._inventory[0]);
                if (list == null || list.size() != 1) {
                    itemStack = this._inventory[0].func_77946_l();
                } else if (this._preferredOutputs.containsKey(list.get(0))) {
                    itemStack = this._preferredOutputs.get(list.get(0)).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                } else {
                    itemStack = ((ItemStack)OreDictionary.getOres((String)((String)list.get(0))).get(0)).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                }
                this.moveItemStack(itemStack);
            }
        }
    }

    private void moveItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        int n = itemStack.field_77994_a;
        if (this._inventory[1] == null) {
            n = Math.min(this.func_70297_j_(), itemStack.func_77976_d());
        } else {
            if (itemStack.field_77993_c != this._inventory[1].field_77993_c || itemStack.func_77960_j() != this._inventory[1].func_77960_j()) {
                return;
            }
            if (itemStack.func_77978_p() != null || this._inventory[1].func_77978_p() != null) {
                return;
            }
            n = Math.min(this._inventory[0].field_77994_a, this._inventory[1].func_77976_d() - this._inventory[1].field_77994_a);
        }
        if (this._inventory[1] == null) {
            this._inventory[1] = itemStack.func_77946_l();
            this._inventory[0].field_77994_a -= itemStack.field_77994_a;
        } else {
            this._inventory[1].field_77994_a += n;
            this._inventory[0].field_77994_a -= n;
        }
        if (this._inventory[0].field_77994_a == 0) {
            this._inventory[0] = null;
        }
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._preferredOutputs.clear();
        for (int i = 2; i < 11; ++i) {
            List list;
            if (this._inventory[i] == null || (list = OreDictTracker.getNamesFromItem((ItemStack)this._inventory[i])) == null) continue;
            for (String string : list) {
                this._preferredOutputs.put(string, this._inventory[i].func_77946_l());
            }
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n < 2;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 11;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || fluidStack.amount == 0) {
            return 0;
        }
        FluidStack fluidStack2 = this.unifierTransformLiquid(fluidStack, bl);
        if (fluidStack2 == null || fluidStack2.amount == 0) {
            return 0;
        }
        int n = this._tank.fill(fluidStack2, bl);
        if (n == fluidStack2.amount) {
            return fluidStack.amount;
        }
        return n * fluidStack.amount / fluidStack2.amount + (fluidStack.amount & this._roundingCompensation);
    }

    private FluidStack unifierTransformLiquid(FluidStack fluidStack, boolean bl) {
        if (_ethanol != null && _biofuel != null) {
            if (_ethanol.isFluidEqual(fluidStack)) {
                return new FluidStack(TileEntityUnifier._biofuel.fluidID, fluidStack.amount);
            }
            if (_biofuel.isFluidEqual(fluidStack)) {
                return new FluidStack(TileEntityUnifier._ethanol.fluidID, fluidStack.amount);
            }
        } else if (_essence != null && _liquidxp != null) {
            if (_essence.isFluidEqual(fluidStack)) {
                return new FluidStack(TileEntityUnifier._liquidxp.fluidID, fluidStack.amount * 2);
            }
            if (_liquidxp.isFluidEqual(fluidStack)) {
                if (bl) {
                    this._roundingCompensation ^= fluidStack.amount & 1;
                }
                return new FluidStack(TileEntityUnifier._essence.fluidID, fluidStack.amount / 2 + (fluidStack.amount & this._roundingCompensation));
            }
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this._tank.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && fluidStack.isFluidEqual(this._tank.getFluid())) {
            return this._tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

