/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.AdvRecipe;
import ic2.core.util.Util;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class AdvShapelessRecipe
implements IRecipe {
    public ItemStack output;
    public Object[] input;
    public boolean hidden;

    public static void addAndRegister(ItemStack result, Object ... args) {
        CraftingManager.func_77594_a().func_77592_b().add(new AdvShapelessRecipe(result, args));
    }

    public AdvShapelessRecipe(ItemStack result, Object ... args) {
        if (result == null) {
            AdvRecipe.displayError("null result", null, null, true);
        }
        this.input = new Object[args.length - Util.countInArray(args, Boolean.class)];
        int inputIndex = 0;
        for (Object o : args) {
            if (o instanceof String) {
                this.input[inputIndex++] = o;
                continue;
            }
            if (o instanceof ItemStack || o instanceof Block || o instanceof Item) {
                if (o instanceof Block) {
                    o = new ItemStack((Block)o, 1, Short.MAX_VALUE);
                } else if (o instanceof Item) {
                    o = new ItemStack((Item)o, 1, Short.MAX_VALUE);
                }
                this.input[inputIndex++] = o;
                continue;
            }
            if (o instanceof Boolean) {
                this.hidden = (Boolean)o;
                continue;
            }
            AdvRecipe.displayError("unknown type", "O: " + o + "\nT: " + (o == null ? "null" : o.getClass().getName()), result, true);
        }
        if (inputIndex != this.input.length) {
            AdvRecipe.displayError("length calculation error", "I: " + inputIndex + "\nL: " + this.input.length, result, true);
        }
        this.output = result;
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        return this.func_77572_b(inventorycrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        int offerSize = inventorycrafting.func_70302_i_();
        if (offerSize < this.input.length) {
            return null;
        }
        Vector<Object> unmatched = new Vector<Object>();
        for (Object o : this.input) {
            unmatched.add(o);
        }
        int outputCharge = 0;
        block1: for (int i = 0; i < offerSize; ++i) {
            ItemStack offer = inventorycrafting.func_70301_a(i);
            if (offer == null) continue;
            for (int j = 0; j < unmatched.size(); ++j) {
                List<ItemStack> requestedItemStacks = AdvRecipe.resolveOreDict(unmatched.get(j));
                for (ItemStack requestedItemStack : requestedItemStacks) {
                    if (offer.func_77973_b() instanceof IElectricItem) {
                        if (offer.field_77993_c != requestedItemStack.field_77993_c) continue;
                        outputCharge += ElectricItem.manager.getCharge(offer);
                        unmatched.remove(j);
                        continue block1;
                    }
                    if (!offer.func_77969_a(requestedItemStack) && (requestedItemStack.func_77960_j() != Short.MAX_VALUE || offer.field_77993_c != requestedItemStack.field_77993_c)) continue;
                    unmatched.remove(j);
                    continue block1;
                }
            }
            return null;
        }
        if (!unmatched.isEmpty()) {
            return null;
        }
        ItemStack ret = this.output.func_77946_l();
        if (ret.func_77973_b() instanceof IElectricItem) {
            ElectricItem.manager.charge(ret, outputCharge, Integer.MAX_VALUE, true, false);
        }
        return ret;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }
}

