/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockPoleFence;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemLuminator;
import ic2.core.util.AabbUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockLuminator
extends BlockMultiID {
    boolean light;

    public BlockLuminator(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76264_q, ItemLuminator.class);
        this.func_71884_a(field_71974_j);
        this.func_71848_c(0.3f);
        this.func_71894_b(0.5f);
        if (internalName == InternalName.blockLuminator) {
            this.light = true;
            this.func_71900_a(1.0f);
            this.func_71849_a(null);
        } else {
            this.light = false;
        }
    }

    @Override
    public String getTextureFolder() {
        return "wiring";
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public boolean func_71850_a_(World world, int i, int j, int k, int direction) {
        if (world.func_72798_a(i, j, k) != 0) {
            return false;
        }
        switch (direction) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public static boolean isSupportingBlock(World world, int i, int j, int k) {
        if (world.func_72798_a(i, j, k) == 0) {
            return false;
        }
        if (world.func_72804_r(i, j, k)) {
            return true;
        }
        return BlockLuminator.isSpecialSupporter((IBlockAccess)world, i, j, k);
    }

    public static boolean isSpecialSupporter(IBlockAccess world, int i, int j, int k) {
        Block block = Block.field_71973_m[world.func_72798_a(i, j, k)];
        if (block == null) {
            return false;
        }
        if (block instanceof BlockFence || block instanceof BlockPoleFence || block instanceof BlockCable) {
            return true;
        }
        return block.field_71990_ca == Ic2Items.reinforcedGlass.field_77993_c || block == Block.field_71946_M;
    }

    public boolean func_71854_d(World world, int i, int j, int k) {
        TileEntity te = world.func_72796_p(i, j, k);
        if (te != null && ((TileEntityLuminator)te).ignoreBlockStay) {
            return true;
        }
        int facing = world.func_72805_g(i, j, k);
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public void func_71863_a(World world, int i, int j, int k, int l) {
        if (!this.func_71854_d(world, i, j, k)) {
            world.func_72832_d(i, j, k, 0, 0, 7);
        }
        super.func_71863_a(world, i, j, k, l);
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    public int func_71857_b() {
        return IC2.platform.getRenderId("luminator");
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        return this.func_71872_e(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(box[0] + (float)x), (double)(box[1] + (float)y), (double)(box[2] + (float)z), (double)(box[3] + (float)x), (double)(box[4] + (float)y), (double)(box[5] + (float)z));
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return this.func_71872_e(world, x, y, z);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, this.func_71872_e(world, x, y, z), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public static float[] getBoxOfLuminator(IBlockAccess world, int x, int y, int z) {
        int facing = world.func_72805_g(x, y, z);
        float px = 0.0625f;
        switch (facing) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, x, y, z);
        switch (facing) {
            case 1: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px, 1.0f};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 15.0f * px, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{6.0f * px, 3.0f * px, 14.0f * px, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px};
                }
                return new float[]{6.0f * px, 3.0f * px, 0.0f, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 2.0f * px};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{14.0f * px, 3.0f * px, 6.0f * px, 1.0f, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px, 1.0f, 1.0f};
                }
                return new float[]{0.0f, 3.0f * px, 6.0f * px, 2.0f * px, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
        }
        if (fullCover) {
            return new float[]{0.0f, 15.0f * px, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{4.0f * px, 13.0f * px, 4.0f * px, 1.0f - 4.0f * px, 1.0f, 1.0f - 4.0f * px};
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    @Override
    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        ItemStack itemStack = entityplayer.func_71045_bC();
        if (itemStack == null || !(itemStack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        itemStack.func_77973_b();
        TileEntityLuminator lumi = (TileEntityLuminator)world.func_72796_p(i, j, k);
        int transfer = lumi.getMaxEnergy() - lumi.energy;
        if (transfer <= 0) {
            return false;
        }
        transfer = ElectricItem.manager.discharge(itemStack, transfer, 2, true, false);
        if (!this.light) {
            world.func_72832_d(i, j, k, Ic2Items.activeLuminator.field_77993_c, world.func_72805_g(i, j, k), 7);
            lumi = (TileEntityLuminator)world.func_72796_p(i, j, k);
        }
        lumi.energy += transfer;
        return true;
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        if (this.light && entity instanceof EntityMob) {
            entity.func_70015_d(entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD ? 20 : 10);
        }
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityLuminator();
    }

    @Override
    public void func_71879_a(int i, CreativeTabs tabs, List itemList) {
        if (!this.light) {
            super.func_71879_a(i, tabs, itemList);
        }
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (te != null && te.getClass() == TileEntityLuminator.class) {
            TileEntityLuminator tel = (TileEntityLuminator)te;
            return (int)Math.floor((float)tel.energy / (float)tel.getMaxEnergy() * 15.0f);
        }
        return 0;
    }
}

