/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.BehaviorScrapboxDispense;
import ic2.core.item.ItemIC2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class ItemScrapbox
extends ItemIC2 {
    public ItemScrapbox(Configuration config, InternalName internalName) {
        super(config, internalName);
        BlockDispenser.field_82527_a.func_82595_a((Object)this, (Object)new BehaviorScrapboxDispense());
    }

    public static void init() {
        ArrayList ores;
        Recipes.scrapboxDrops = new ScrapboxRecipeManager();
        if (IC2.suddenlyHoes) {
            ItemScrapbox.addDrop(Item.field_77678_N, 9001.0f);
        } else {
            ItemScrapbox.addDrop(Item.field_77678_N, 5.01f);
        }
        ItemScrapbox.addDrop(Block.field_71979_v, 5.0f);
        ItemScrapbox.addDrop(Item.field_77669_D, 4.0f);
        ItemScrapbox.addDrop((Block)Block.field_71980_u, 3.0f);
        ItemScrapbox.addDrop(Block.field_71940_F, 3.0f);
        ItemScrapbox.addDrop(Block.field_72012_bb, 2.0f);
        ItemScrapbox.addDrop(Item.field_77737_bm, 2.0f);
        ItemScrapbox.addDrop(Item.field_77706_j, 1.5f);
        ItemScrapbox.addDrop(Item.field_77684_U, 1.5f);
        ItemScrapbox.addDrop(Ic2Items.filledTinCan.func_77973_b(), 1.5f);
        ItemScrapbox.addDrop(Item.field_77715_r);
        ItemScrapbox.addDrop(Item.field_77714_s);
        ItemScrapbox.addDrop(Item.field_77713_t);
        ItemScrapbox.addDrop(Block.field_72013_bc);
        ItemScrapbox.addDrop(Item.field_77792_au);
        ItemScrapbox.addDrop(Item.field_77770_aF);
        ItemScrapbox.addDrop(Item.field_77676_L);
        ItemScrapbox.addDrop(Item.field_77755_aX);
        ItemScrapbox.addDrop(Item.field_77782_ar, 0.9f);
        ItemScrapbox.addDrop(Item.field_77734_bj, 0.9f);
        ItemScrapbox.addDrop(Block.field_72061_ba, 0.9f);
        ItemScrapbox.addDrop(Item.field_77736_bl, 0.9f);
        ItemScrapbox.addDrop(Item.field_77773_az, 0.9f);
        ItemScrapbox.addDrop(Item.field_77767_aC, 0.9f);
        ItemScrapbox.addDrop(Ic2Items.rubber.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Item.field_77751_aT, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.coalDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.copperDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.tinDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.plantBall.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.suBattery.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.ironDust.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.goldDust.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Item.field_77761_aM, 0.6f);
        ItemScrapbox.addDrop(Block.field_71949_H, 0.5f);
        ItemScrapbox.addDrop((Item)Item.field_77796_al, 0.5f);
        ItemScrapbox.addDrop(Block.field_71941_G, 0.5f);
        ItemScrapbox.addDrop(Item.field_77746_aZ, 0.5f);
        ItemScrapbox.addDrop(Item.field_77702_n, 0.1f);
        ItemScrapbox.addDrop(Item.field_77817_bH, 0.05f);
        if (Ic2Items.copperOre != null) {
            ItemScrapbox.addDrop(Ic2Items.copperOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreCopper");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
        if (Ic2Items.tinOre != null) {
            ItemScrapbox.addDrop(Ic2Items.tinOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreTin");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
    }

    public static void addDrop(Item item) {
        ItemScrapbox.addDrop(new ItemStack(item), 1.0f);
    }

    public static void addDrop(Item item, float chance) {
        ItemScrapbox.addDrop(new ItemStack(item), chance);
    }

    public static void addDrop(Block block) {
        ItemScrapbox.addDrop(new ItemStack(block), 1.0f);
    }

    public static void addDrop(Block block, float chance) {
        ItemScrapbox.addDrop(new ItemStack(block), chance);
    }

    public static void addDrop(ItemStack item) {
        ItemScrapbox.addDrop(item, 1.0f);
    }

    public static void addDrop(ItemStack item, float chance) {
        Recipes.scrapboxDrops.addRecipe(item, Float.valueOf(chance));
    }

    public static ItemStack getDrop(World world) {
        Map<ItemStack, Drop> dropList = ((ScrapboxRecipeManager)Recipes.scrapboxDrops).getDrops();
        if (!dropList.isEmpty()) {
            float dropChance = world.field_73012_v.nextFloat() * Drop.topChance;
            for (Map.Entry<ItemStack, Drop> entry : dropList.entrySet()) {
                Drop drop = entry.getValue();
                if (!(drop.upperChanceBound > dropChance) || !(drop.upperChanceBound - drop.originalChance <= dropChance)) continue;
                return entry.getKey().func_77946_l();
            }
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ItemStack itemStack;
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        if ((itemStack = ItemScrapbox.getDrop(world)) != null) {
            entityplayer.func_71021_b(itemStack);
        }
        return itemstack;
    }

    static class ScrapboxRecipeManager
    implements IMachineRecipeManager<Float> {
        private final IMachineRecipeManager<Drop> backend = new BasicMachineRecipeManager<Drop>();

        ScrapboxRecipeManager() {
        }

        @Override
        public void addRecipe(ItemStack input, Float output) {
            this.backend.addRecipe(input, new Drop(output.floatValue()));
        }

        @Override
        public Float getOutputFor(ItemStack input, boolean adjustInput) {
            Drop drop = this.backend.getOutputFor(input, adjustInput);
            if (drop == null) {
                return null;
            }
            return Float.valueOf(drop.originalChance);
        }

        @Override
        public Map<ItemStack, Float> getRecipes() {
            HashMap<ItemStack, Float> recipes = new HashMap<ItemStack, Float>();
            for (Map.Entry<ItemStack, Drop> entry : this.backend.getRecipes().entrySet()) {
                recipes.put(entry.getKey(), Float.valueOf(entry.getValue().originalChance / Drop.topChance));
            }
            return Collections.unmodifiableMap(recipes);
        }

        Map<ItemStack, Drop> getDrops() {
            return this.backend.getRecipes();
        }
    }

    static class Drop {
        float originalChance;
        float upperChanceBound;
        static float topChance;

        Drop(float chance) {
            this.originalChance = chance;
            this.upperChanceBound = topChance += chance;
        }
    }
}

