/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.dj.nativeswing.BackBufferManager;
import chrriis.dj.nativeswing.EmbeddableComponent;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;

abstract class NativeComponentProxy
extends EmbeddableComponent {
    private BackBufferManager backBufferManager;
    protected NativeComponentWrapper nativeComponentWrapper;

    protected NativeComponentProxy(NativeComponentWrapper nativeComponentWrapper) {
        this.nativeComponentWrapper = nativeComponentWrapper;
        nativeComponentWrapper.setNativeComponentProxy(this);
        this.backBufferManager = new BackBufferManager(nativeComponentWrapper, this);
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NativeComponentProxy.this.nativeComponentWrapper.getNativeComponent().requestFocus();
            }
        });
    }

    @Override
    protected void printComponent(Graphics graphics) {
        this.nativeComponentWrapper.getNativeComponent().print(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.backBufferManager.paintBackBuffer(graphics);
    }

    public BackBufferManager getBackBufferManager() {
        return this.backBufferManager;
    }

    protected abstract void dispose();

    protected static JLayeredPane findLayeredPane(Component component) {
        Component component2 = component;
        while ((component2 = component2.getParent()) != null) {
            if (component2.isLightweight() || !(component2 instanceof RootPaneContainer)) continue;
            return ((RootPaneContainer)((Object)component2)).getLayeredPane();
        }
        throw new IllegalStateException("The window ancestor must be a root pane container!");
    }
}

