/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Filter;
import chrriis.common.UIUtils;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.ClipLayout;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import chrriis.dj.nativeswing.NativeSwing;
import com.sun.jna.examples.WindowUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

class NativeComponentProxyPanel
extends NativeComponentProxy {
    private static final boolean IS_DEBUGGING_SHAPE = Boolean.parseBoolean(NSSystemProperty.COMPONENTS_DEBUG_PRINTSHAPECOMPUTING.get());
    private boolean isProxiedFiliation;
    private AWTEventListener shapeAdjustmentEventListener;
    private boolean isDestructionOnFinalization;
    private boolean isVisibilityConstrained;
    private HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            Component component = hierarchyEvent.getChanged();
            if (component instanceof Window) {
                return;
            }
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.adjustFocus();
        }

        protected void adjustFocus() {
            for (Container container = NativeComponentProxyPanel.this; container != null && !(container instanceof Window); container = container.getParent()) {
                if (!(container instanceof JInternalFrame)) continue;
                Window window = SwingUtilities.getWindowAncestor(NativeComponentProxyPanel.this);
                if (window == null) break;
                boolean bl = window.getFocusableWindowState();
                window.setFocusableWindowState(false);
                try {
                    ((JInternalFrame)container).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                window.setFocusableWindowState(bl);
                break;
            }
        }
    };
    private volatile boolean isInvoking;
    private Rectangle[] lastArea = new Rectangle[]{new Rectangle(this.getSize())};
    private EmbeddedPanel embeddedPanel;
    private HierarchyListener hierarchyListener;

    NativeComponentProxyPanel(NativeComponentWrapper nativeComponentWrapper, boolean bl, boolean bl2, boolean bl3) {
        super(nativeComponentWrapper);
        this.isDestructionOnFinalization = bl2;
        this.isVisibilityConstrained = bl;
        this.hierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                long l = hierarchyEvent.getChangeFlags();
                if ((l & 4L) != 0L) {
                    if (NativeComponentProxyPanel.this.isVisibilityConstrained) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    } else {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                    }
                }
            }
        };
        if (bl) {
            this.shapeAdjustmentEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    boolean bl = false;
                    switch (aWTEvent.getID()) {
                        case 100: 
                        case 101: 
                        case 300: 
                        case 301: {
                            bl = true;
                            break;
                        }
                        case 102: 
                        case 103: {
                            if (!(aWTEvent.getSource() instanceof Window)) break;
                            bl = true;
                        }
                    }
                    if (bl && NativeComponentProxyPanel.this.nativeComponentWrapper.getNativeComponentProxy() == NativeComponentProxyPanel.this) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    }
                }
            };
        }
        this.isProxiedFiliation = bl3;
    }

    private void adjustEmbeddedPanelBounds() {
        Container container;
        boolean bl;
        if (this.embeddedPanel == null) {
            return;
        }
        if (!this.isVisibilityConstrained && (bl = this.isShowing()) != this.embeddedPanel.isVisible()) {
            this.embeddedPanel.setVisible(bl);
        }
        if ((container = this.embeddedPanel.getParent()) != null) {
            Point point = SwingUtilities.convertPoint(this, new Point(0, 0), container);
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            Rectangle rectangle2 = this.embeddedPanel.getRectangularClip();
            if (rectangle2 != null) {
                rectangle.x += rectangle2.x;
                rectangle.y += rectangle2.y;
                rectangle.width = rectangle2.width;
                rectangle.height = rectangle2.height;
            }
            if (!this.embeddedPanel.getBounds().equals(rectangle)) {
                this.embeddedPanel.setBounds(rectangle);
                this.embeddedPanel.invalidate();
                this.embeddedPanel.validate();
                this.embeddedPanel.repaint();
                if (this.isVisibilityConstrained) {
                    this.adjustEmbeddedPanelShape();
                }
            }
        }
    }

    private void adjustEmbeddedPanelShape() {
        if (this.isInvoking) {
            return;
        }
        this.isInvoking = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NativeComponentProxyPanel.this.isInvoking = false;
                NativeComponentProxyPanel.this.adjustEmbeddedPanelShape_();
            }
        });
    }

    private void adjustEmbeddedPanelShape_() {
        if (this.embeddedPanel == null) {
            return;
        }
        Object[] objectArray = this.computePeerShapeArea();
        if (Arrays.equals(this.lastArea, objectArray)) {
            this.embeddedPanel.nativeComponentWrapper.getNativeComponent().repaint();
            return;
        }
        this.lastArea = objectArray;
        if (objectArray.length == 0) {
            this.embeddedPanel.setVisible(false);
        } else {
            if (!this.embeddedPanel.isVisible()) {
                this.embeddedPanel.setVisible(true);
            }
            this.embeddedPanel.applyShape((Rectangle[])objectArray);
        }
    }

    private Rectangle[] computePeerShapeArea() {
        if (IS_DEBUGGING_SHAPE) {
            System.err.println("Computing shape: [" + this.getWidth() + "x" + this.getHeight() + "] " + this.nativeComponentWrapper.getComponentDescription());
        }
        Rectangle[] rectangleArray = UIUtils.getComponentVisibleArea(this, new Filter<Component>(){

            @Override
            public Filter.Acceptance accept(Component component) {
                Rectangle rectangle;
                if (component instanceof EmbeddedPanel) {
                    return Filter.Acceptance.NO;
                }
                UIUtils.TransparencyType transparencyType = UIUtils.getComponentTransparency(component);
                switch (transparencyType) {
                    case TRANSPARENT_WITH_OPAQUE_CHILDREN: {
                        return Filter.Acceptance.TEST_CHILDREN;
                    }
                    case NOT_VISIBLE: {
                        return Filter.Acceptance.NO;
                    }
                }
                if (IS_DEBUGGING_SHAPE && !(rectangle = SwingUtilities.convertRectangle(component, new Rectangle(component.getSize()), NativeComponentProxyPanel.this).intersection(new Rectangle(NativeComponentProxyPanel.this.getSize()))).isEmpty()) {
                    System.err.println("  -> Subtracting [" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "x" + rectangle.height + "] " + component);
                }
                return Filter.Acceptance.YES;
            }
        });
        return rectangleArray;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (NativeComponentWrapper nativeComponentWrapper : NativeSwing.getNativeComponentWrappers()) {
            NativeComponentProxy nativeComponentProxy = nativeComponentWrapper.getNativeComponentProxy();
            if (!(nativeComponentProxy instanceof NativeComponentProxyPanel) || !((NativeComponentProxyPanel)nativeComponentProxy).isVisibilityConstrained) continue;
            ((NativeComponentProxyPanel)nativeComponentProxy).adjustEmbeddedPanelShape();
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (n == this.getX() && n2 == this.getY() && n3 == this.getWidth() && n4 == this.getHeight()) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        this.adjustEmbeddedPanelBounds();
    }

    @Override
    public void addNotify() {
        boolean bl;
        super.addNotify();
        if (this.hierarchyListener != null) {
            this.addHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.shapeAdjustmentEventListener, 3L);
        }
        JLayeredPane jLayeredPane = null;
        if (this.isProxiedFiliation) {
            jLayeredPane = NativeComponentProxyPanel.findLayeredPane(this);
        }
        boolean bl2 = bl = this.embeddedPanel != null;
        if (bl) {
            if (this.isProxiedFiliation) {
                JLayeredPane jLayeredPane2;
                if (this.embeddedPanel.getParent() == null) {
                    jLayeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                    jLayeredPane.add(this.embeddedPanel);
                    jLayeredPane.invalidate();
                    jLayeredPane.validate();
                }
                if (jLayeredPane != (jLayeredPane2 = NativeComponentProxyPanel.findLayeredPane(this.embeddedPanel))) {
                    this.embeddedPanel.isCrossWindowReparenting = true;
                    this.nativeComponentWrapper.storeInHiddenParent();
                    Container container = this.embeddedPanel.getParent();
                    container.remove(this.embeddedPanel);
                    UIUtils.revalidate(container);
                    container.repaint();
                    jLayeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                    jLayeredPane.add(this.embeddedPanel);
                    this.nativeComponentWrapper.restoreFromHiddenParent();
                    this.embeddedPanel.isCrossWindowReparenting = false;
                    UIUtils.revalidate(jLayeredPane);
                    jLayeredPane.repaint();
                    this.revalidate();
                    this.repaint();
                }
            }
        } else {
            this.embeddedPanel = new EmbeddedPanel(this.nativeComponentWrapper, this.isDestructionOnFinalization);
            this.embeddedPanel.add(this.nativeComponentWrapper.getNativeComponent(), "Center");
        }
        this.lastArea = null;
        this.adjustEmbeddedPanelBounds();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NativeComponentProxyPanel.this.addHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
            }
        });
        this.nativeComponentWrapper.getNativeComponent().addMouseListener(this.mouseListener);
        if (!bl) {
            if (this.isProxiedFiliation) {
                jLayeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                jLayeredPane.add(this.embeddedPanel);
                UIUtils.revalidate(jLayeredPane);
                jLayeredPane.repaint();
            } else {
                this.add(this.embeddedPanel);
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.hierarchyListener != null) {
            this.removeHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.shapeAdjustmentEventListener);
        }
        if (this.isDestructionOnFinalization) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeComponentProxyPanel.this.removeHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                    NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                }
            });
            this.nativeComponentWrapper.getNativeComponent().removeMouseListener(this.mouseListener);
            if (this.isVisibilityConstrained) {
                this.adjustEmbeddedPanelShape();
            } else {
                this.adjustEmbeddedPanelBounds();
            }
            return;
        }
        this.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.embeddedPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeComponentProxyPanel.this.dispose();
                }
            });
        }
    }

    @Override
    public void dispose() {
        if (this.embeddedPanel == null) {
            return;
        }
        EmbeddedPanel embeddedPanel = this.embeddedPanel;
        this.embeddedPanel = null;
        Container container = embeddedPanel.getParent();
        if (container != null) {
            embeddedPanel.isRemovingFromParent = true;
            container.remove(embeddedPanel);
            container.invalidate();
            container.validate();
            container.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.embeddedPanel != null) {
            return this.embeddedPanel.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    private static class EmbeddedPanel
    extends Panel
    implements NativeComponentWrapper.NativeComponentHolder {
        private NativeComponentWrapper nativeComponentWrapper;
        private boolean isDestructionOnFinalization;
        private boolean isCrossWindowReparenting;
        private boolean isHiddenReparenting;
        private boolean isRemovingFromParent;
        private Rectangle clip;
        private static final boolean RESTRICT_SHAPE_TO_SINGLE_RECTANGLE = Boolean.parseBoolean(NSSystemProperty.COMPONENTS_FORCESINGLERECTANGLESHAPES.get());

        public EmbeddedPanel(NativeComponentWrapper nativeComponentWrapper, boolean bl) {
            super(new ClipLayout());
            this.nativeComponentWrapper = nativeComponentWrapper;
            this.isDestructionOnFinalization = bl;
            this.enableEvents(131072L);
        }

        @Override
        public boolean contains(int n, int n2) {
            return false;
        }

        @Override
        public boolean contains(Point point) {
            return false;
        }

        @Override
        public void removeNotify() {
            if (this.isRemovingFromParent) {
                super.removeNotify();
                return;
            }
            if (this.isDestructionOnFinalization && !this.isCrossWindowReparenting) {
                try {
                    this.nativeComponentWrapper.storeInHiddenParent();
                    this.isHiddenReparenting = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.removeNotify();
                this.isRemovingFromParent = true;
                Container container = this.getParent();
                if (container != null) {
                    container.remove(this);
                    container.invalidate();
                    container.validate();
                }
                this.isRemovingFromParent = false;
            } else {
                super.removeNotify();
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.isHiddenReparenting) {
                this.isHiddenReparenting = false;
                this.nativeComponentWrapper.restoreFromHiddenParent();
            }
        }

        protected void finalize() throws Throwable {
            if (this.isHiddenReparenting) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedPanel.this.nativeComponentWrapper.restoreFromHiddenParent();
                        EmbeddedPanel.this.nativeComponentWrapper.getNativeComponent().removeNotify();
                    }
                });
            }
        }

        public void applyShape(Rectangle[] rectangleArray) {
            Container container;
            int n;
            Rectangle rectangle;
            if (!Utils.IS_MAC && !RESTRICT_SHAPE_TO_SINGLE_RECTANGLE) {
                WindowUtils.setComponentMask((Component)this, (Rectangle[])rectangleArray);
                this.nativeComponentWrapper.getNativeComponent().repaint();
                return;
            }
            if (rectangleArray.length == 0) {
                rectangle = null;
            } else {
                rectangle = new Rectangle(rectangleArray[0]);
                if (rectangleArray.length > 1) {
                    System.err.println("Non-rectangular clip detected on a system that does not support this feature.");
                    for (n = 1; n < rectangleArray.length; ++n) {
                        rectangle = rectangle.union(rectangleArray[n]);
                    }
                }
            }
            if (Utils.equals(this.clip, rectangle)) {
                return;
            }
            n = this.clip == null ? 0 : this.clip.x;
            int n2 = this.clip == null ? 0 : this.clip.y;
            this.clip = rectangle;
            int n3 = rectangle == null ? 0 : rectangle.x;
            int n4 = rectangle == null ? 0 : rectangle.y;
            NativeComponentProxy nativeComponentProxy = this.nativeComponentWrapper.getNativeComponentProxy();
            if (nativeComponentProxy != null) {
                ((ClipLayout)this.getLayout()).setClip(rectangle == null ? null : new Rectangle(-rectangle.x, -rectangle.y, nativeComponentProxy.getWidth(), nativeComponentProxy.getHeight()));
            }
            if ((container = this.getParent()) != null) {
                LayoutManager layoutManager = container.getLayout();
                if (layoutManager instanceof ClipLayout) {
                    ((ClipLayout)layoutManager).setClip(rectangle);
                } else {
                    int n5 = n3 - n;
                    int n6 = n4 - n2;
                    this.setBounds(this.getX() + n5, this.getY() + n6, this.getWidth() - n5, this.getHeight() - n6);
                }
                this.doLayout();
                UIUtils.revalidate(container);
            }
        }

        public Rectangle getRectangularClip() {
            return this.clip;
        }
    }
}

