/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import java.applet.Applet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeInterfaceAppletHandler {
    private static final Object INITIALIZATION_LOCK = new Object();
    private static boolean isInterfaceToOpen;
    private static Set<Applet> activeAppletSet;

    private NativeInterfaceAppletHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateAppletMode() {
        NSSystemProperty.DEPLOYMENT_TYPE.set("applet");
        if (NativeInterface.isInProcess()) {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
            synchronized (atomicBoolean2) {
                Thread thread = new Thread("NativeSwing event pump thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NativeInterface.initialize();
                        }
                        finally {
                            atomicBoolean.set(true);
                            AtomicBoolean atomicBoolean2 = atomicBoolean;
                            synchronized (atomicBoolean2) {
                                atomicBoolean.notify();
                            }
                        }
                        if (!NativeInterface.isEventPumpRunning()) {
                            NativeInterface.runEventPump();
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                while (!atomicBoolean.get()) {
                    try {
                        atomicBoolean.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else {
            NativeInterface.initialize();
        }
    }

    public static void init(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.add(applet);
            if (isInterfaceToOpen) {
                NativeInterface.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.remove(applet);
            if (activeAppletSet.isEmpty()) {
                isInterfaceToOpen = NativeInterface.isOpen();
                NativeInterfaceAppletHandler.stopActivity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.remove(applet);
            if (activeAppletSet.isEmpty()) {
                isInterfaceToOpen = false;
                NativeInterfaceAppletHandler.stopActivity();
            }
        }
    }

    private static void stopActivity() {
        NativeInterface.close();
        WebServer.stopDefaultWebServer();
    }

    private static void checkAppletMode() {
        if (!"applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get())) {
            throw new IllegalStateException(NativeInterfaceAppletHandler.class.getName() + ".activateAppletMode() was not called! This code has to be placed first in the applet subclass in a static initializer.");
        }
    }

    static {
        activeAppletSet = new HashSet<Applet>();
    }
}

