/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.gui.NinePPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ShortcutManager;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PopupDialog
extends JDialog {
    public static final Color sMaskColor = GUIUtil.hex2color("#42000000");
    public static final Color sBackground = GUIUtil.hex2color("#efeff1");
    public static final Color sConfirmButtonColor = GUIUtil.hex2color("#989899");
    public static final ImageIcon sConfirmButtonNormal = ResourceFactory.getInstance().getImageIcon("editinfo/btn_n.png");
    public static final ImageIcon sConfirmButtonPressed = ResourceFactory.getInstance().getImageIcon("editinfo/btn_p.png");
    protected JButton mConfirmButton = GUIUtil.createTransparentButton(sConfirmButtonNormal, sConfirmButtonPressed, sConfirmButtonPressed, null);
    protected JButton mCancelButton = GUIUtil.createTransparentButton(sConfirmButtonNormal, sConfirmButtonPressed, sConfirmButtonPressed, null);
    public static final Color sTitleLabelColor = GUIUtil.hex2color("#606060");
    public static final Color sLabelColor = GUIUtil.hex2color("#989899");
    public static final ImageIcon mCloseImage = ResourceFactory.getInstance().getImageIcon("editinfo/ic_dialog_close.png");
    protected JButton mCloseButton = GUIUtil.createTransparentButton(mCloseImage, null, null, null);
    protected JLabel mDialogTitleLabel;
    protected JPanel mMainPanel;
    private MouseAdapter mMoveWindowListener = new MouseAdapter(){
        private Point lastPoint = null;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.lastPoint = mouseEvent.getLocationOnScreen();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                NewMainFrame.getInstance().toggleMaxWindow();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getLocationOnScreen();
            int n = point.x - this.lastPoint.x;
            int n2 = point.y - this.lastPoint.y;
            Rectangle rectangle = PopupDialog.this.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
            PopupDialog.this.setBounds(rectangle);
            this.lastPoint = point;
        }
    };
    protected ActionListener mCloseActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PopupDialog.this.closeDialog();
        }
    };
    protected NinePPanel mWrapperPanel;
    protected NinePPanel mContentPanel;
    protected NinePPanel mMaskPanel;
    protected ShortcutManager.ShortcutListener mShortcutListener = new ShortcutManager.ShortcutListener(){

        @Override
        public void handle() {
            PopupDialog.this.closeDialog();
        }
    };
    public static final Color sSepLineColor = GUIUtil.hex2color("#d7d7d8");

    public void bindMoveDialogListener(JComponent jComponent) {
        jComponent.addMouseListener(this.mMoveWindowListener);
        jComponent.addMouseMotionListener(this.mMoveWindowListener);
    }

    protected void closeDialog() {
        ShortcutManager.getInstance().removeShortcutListener(this.mShortcutListener);
        this.dispose();
    }

    public PopupDialog() {
        super((Frame)NewMainFrame.getInstance(), true);
        this.setUndecorated(true);
        this.setBackground(GUIUtil.TRANSPARENT);
        this.setModal(true);
        this.initButtons();
        this.mWrapperPanel = new NinePPanel();
        this.mContentPanel = new NinePPanel();
        this.mWrapperPanel.setContentPanel(this.mContentPanel);
        this.mWrapperPanel.setNinePBackground("main/frame_bg.9.png");
        this.mContentPanel.setNinePBackground("editinfo/dialog_bg.9.png");
        this.getContentPane().setLayout(new BorderLayout());
        if (GUIUtil.supportTransparent()) {
            this.mMaskPanel = new NinePPanel();
            this.setContentPane(this.mMaskPanel);
            this.setBounds(NewMainFrame.getInstance().getMinBounds());
            double[][] dArrayArray = new double[][]{{-1.0, this.getDefineWidth() + this.mWrapperPanel.getLeftPadding() + this.mWrapperPanel.getRightPadding(), -1.0}, {-1.0, this.getDefineHeight() + this.mWrapperPanel.getLeftPadding() + this.mWrapperPanel.getRightPadding(), -1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.getContentPane().setLayout(tableLayout);
            this.getContentPane().add((Component)this.mWrapperPanel, "1, 1");
        } else {
            this.getContentPane().add((Component)this.mWrapperPanel, "Center");
            GUIUtil.layout(this, NewMainFrame.getInstance(), this.getDefineWidth() + this.mWrapperPanel.getLeftPadding() + this.mWrapperPanel.getRightPadding(), this.getDefineHeight() + this.mWrapperPanel.getTopPadding() + this.mWrapperPanel.getBottomPadding());
        }
        this.mMainPanel = this.mContentPanel.getContentPanel();
        ShortcutManager.getInstance().addShortcutListener(this.mShortcutListener, 27);
        this.bindMoveDialogListener(this.mWrapperPanel);
    }

    public int getDefineWidth() {
        return 480;
    }

    public int getDefineHeight() {
        return 400;
    }

    public void initButtons() {
        this.mConfirmButton.setText(ResourceFactory.getString("OK"));
        this.mCancelButton.setText(ResourceFactory.getString("Cancel"));
        this.adjustButton(this.mConfirmButton);
        this.adjustButton(this.mCancelButton);
    }

    protected void adjustButton(JButton jButton) {
        jButton.setFont(ThemeLookAndFeel.getBoldFont(12));
        jButton.setForeground(sConfirmButtonColor);
        jButton.setHorizontalTextPosition(0);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void adjustLabel(JLabel jLabel) {
        jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
        jLabel.setForeground(GUIUtil.hex2color("#707072"));
    }

    protected JPanel getSepPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(sSepLineColor);
        return jPanel;
    }
}

