/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.util.GUIUtil;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPanel;

public class HoverSelectedPanel
extends JPanel {
    private boolean mIsSelected = false;
    private boolean mIsHover = false;
    private Icon mSelectedIcon;
    private Icon mHoverIcon;
    private Icon mIcon;
    private MouseAdapter mHoverListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            HoverSelectedPanel.this.mIsHover = true;
            HoverSelectedPanel.this.refresh();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HoverSelectedPanel.this.mIsHover = false;
            HoverSelectedPanel.this.refresh();
        }
    };

    public void refresh() {
        this.repaint();
    }

    public HoverSelectedPanel() {
        this.setBackground(GUIUtil.TRANSPARENT);
        this.setOpaque(false);
        this.addMouseMotionListener(this.mHoverListener);
        this.addMouseListener(this.mHoverListener);
    }

    public void setSelected(boolean bl) {
        this.mIsSelected = bl;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setIcon(Icon icon) {
        this.mIcon = icon;
    }

    public void setHoverIcon(Icon icon) {
        this.mHoverIcon = icon;
    }

    public void setSelectedIcon(Icon icon) {
        this.mSelectedIcon = icon;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = (this.getWidth() - this.mIcon.getIconWidth()) / 2;
        int n2 = (this.getHeight() - this.mIcon.getIconHeight()) / 2;
        if (this.mIsSelected) {
            this.mSelectedIcon.paintIcon(this, graphics, n, n2);
            return;
        }
        if (this.mIsHover) {
            this.mHoverIcon.paintIcon(this, graphics, n, n2);
            return;
        }
        this.mIcon.paintIcon(this, graphics, n, n2);
    }
}

