/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.skin;

import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class MenuUI
extends BasicMenuUI {
    BufferedImage mMenuBackgroundHover = ResourceFactory.getInstance().getImage("main/menu_hover.png");
    BufferedImage mMenuBackgroundPressed = ResourceFactory.getInstance().getImage("main/menu_pressed.png");
    ImageIcon mMenuBackgroundHoverIcon = ResourceFactory.getInstance().getImageIcon("main/menu_hover.png");
    protected boolean mIsHover = false;
    public MouseAdapter mMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            MenuUI.this.mIsHover = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            MenuUI.this.mIsHover = false;
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new MenuUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.mMouseAdapter);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeMouseListener(this.mMouseAdapter);
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
    }

    @Override
    protected void installComponents(JMenuItem jMenuItem) {
        super.installComponents(jMenuItem);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.drawImage(this.mMenuBackgroundPressed, 0, 0, null);
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && this.mIsHover) {
            graphics.drawImage(this.mMenuBackgroundHover, 0, 0, null);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        dimension.width = 53;
        dimension.height = 28;
        return dimension;
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        rectangle.x = 13;
        super.paintText(graphics, jMenuItem, rectangle, string);
    }
}

