/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.CSVFile;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class IconManager {
    public static final String ICON_SUFFIX = ".png";
    public static HashMap<String, File> mIconsMap = new HashMap();
    public static Vector<String> mSystemNames = new Vector();
    public static HashMap<String, String[]> mSystemApps = new HashMap();
    private static FileFilter mIconsFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(IconManager.ICON_SUFFIX);
        }
    };
    private static HashMap<String, BufferedImage> mIconCache = new HashMap();
    public static BufferedImage sIconFrame = ResourceFactory.getInstance().getImage("more/icon_frame.png");

    public static synchronized File getIconByPackageName(String string) {
        return mIconsMap.get(string + ICON_SUFFIX);
    }

    public static synchronized File getIconByPackageNameLike(String string) {
        for (String string2 : mIconsMap.keySet()) {
            if (!string2.contains(string)) continue;
            return mIconsMap.get(string2);
        }
        return null;
    }

    public static synchronized void fillData() {
        mIconsMap.clear();
        mSystemNames.clear();
        mSystemApps.clear();
        File file = new File(IconManager.getThemeIconsCatalog());
        File[] fileArray = file.listFiles(mIconsFileFilter);
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(ICON_SUFFIX)) continue;
            mIconsMap.put(file2.getName(), file2);
        }
        File file3 = new File(IconManager.getThemeIconsCatalogDefault());
        fileArray = file3.listFiles(mIconsFileFilter);
        if (fileArray == null) {
            return;
        }
        for (File file4 : fileArray) {
            if (!file4.getName().endsWith(ICON_SUFFIX)) continue;
            mIconsMap.put(file4.getName(), file4);
        }
        Vector<String[]> vector = new CSVFile(ThemeHelper.getDataFolder() + File.separator + "system_icons.csv").getData();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            if (stringArray.length < 3 || stringArray[0].isEmpty()) continue;
            boolean bl = false;
            for (int i = 2; i < stringArray.length; ++i) {
                if (!mIconsMap.containsKey(stringArray[i] + ICON_SUFFIX)) continue;
                if (bl) {
                    mIconsMap.remove(stringArray[i] + ICON_SUFFIX);
                    continue;
                }
                mSystemApps.put(stringArray[i], stringArray);
                mSystemNames.add(stringArray[i]);
                bl = true;
            }
        }
    }

    public static Vector<String> getSystemIcons() {
        Vector<String> vector = new Vector<String>();
        for (String string : mSystemNames) {
            if (!mIconsMap.containsKey(string + ICON_SUFFIX)) continue;
            vector.add(string);
        }
        return vector;
    }

    public static Vector<String> getOtherIcons() {
        Vector<String> vector = new Vector<String>();
        for (String string : mIconsMap.keySet()) {
            String string2 = string.substring(0, string.length() - 4);
            if (mSystemNames.contains(string2)) continue;
            vector.add(string2);
        }
        return vector;
    }

    public static String getThemeIconsCatalogDefault() {
        return ThemeHelper.getResourceCatalogPath() + File.separator + "defaulticons";
    }

    public static String getThemeIconsCatalog() {
        return ThemeHelper.getResourceCatalogPath() + File.separator + "icons";
    }

    public static String getIconsFolder() {
        return ConfigUtil.getThemePath() + File.separator + "icons";
    }

    public static BufferedImage getIcon(String string) {
        if (mIconCache.containsKey(string)) {
            return mIconCache.get(string);
        }
        File file = IconManager.getIconByPackageName(string);
        BufferedImage bufferedImage = null;
        if (file == null) {
            file = IconManager.getIconByPackageNameLike(string);
        }
        bufferedImage = file == null ? ResourceFactory.getInstance().getImage("more/default_icon.png") : GUIUtil.getImage(file);
        mIconCache.put(string, bufferedImage);
        return bufferedImage;
    }

    public static ImageIcon getScaledAndRoundedIcon(BufferedImage bufferedImage, int n, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = sIconFrame;
        }
        BufferedImage bufferedImage3 = new BufferedImage(n, n, bufferedImage.getType());
        Graphics graphics = bufferedImage3.getGraphics();
        BufferedImage bufferedImage4 = GUIUtil.scaleImage(bufferedImage, n);
        BufferedImage bufferedImage5 = GUIUtil.scaleImage(bufferedImage2, n);
        graphics.drawImage(bufferedImage4, 0, 0, null);
        graphics.drawImage(bufferedImage5, 0, 0, null);
        return new ImageIcon(bufferedImage3);
    }
}

