/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconResourceReplacePanel
extends ResourceReplacePanel {
    public static final int REPLACE_ICON_SIZE = 97;

    public IconResourceReplacePanel(String string, File file, File file2, ResourceReplacePanel.ReplaceActionListener replaceActionListener) {
        super(string, file, file2, replaceActionListener);
        this.initPanel();
    }

    protected void initPanel() {
        this.setBackground(GUIUtil.TRANSPARENT);
        double[][] dArrayArray = new double[][]{{44.0, 97.0, 30.0, 22.0, 30.0, 97.0, -1.0, 14.0, 30.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        ImageIcon imageIcon = GUIUtil.getIcon(this.mCatalogFile, 97, 4);
        this.mCatalogIconLabel = new JLabel(imageIcon);
        this.mCatalogIconLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mCatalogIconLabel.addMouseListener(new ResourceReplacePanel.OpenInExplorerMouseAdapter(this.mCatalogFile));
        this.add((Component)this.mCatalogIconLabel, "1, 0");
        this.mCopyButton.addActionListener(new ResourceReplacePanel.CopyResourceActionListener(this.mCatalogFile.getAbsolutePath(), this.mReplaceFile.getAbsolutePath()));
        this.add((Component)this.mCopyButton, "3, 0");
        if (this.mReplaceFile.exists()) {
            this.mReplaceIconLabel = new JLabel(GUIUtil.getIcon(this.mReplaceFile, 97, 4));
            this.mReplaceIconLabel.addMouseListener(new ResourceReplacePanel.OpenInExplorerMouseAdapter(this.mReplaceFile));
            this.mReplaceIconLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.add((Component)this.mReplaceIconLabel, "5, 0");
            new FileDrop(null, (Component)this.mReplaceIconLabel, this.mReplaceIconLabel.getBorder(), (FileDrop.Listener)new ResourceReplacePanel.FileDropListener(this.mReplaceFile));
        } else {
            this.add((Component)this.mUnreplaceButton, "5, 0");
            this.mUnreplaceButton.addActionListener(this.dhal);
            new FileDrop(null, (Component)this.mUnreplaceButton, this.mUnreplaceButton.getBorder(), (FileDrop.Listener)new ResourceReplacePanel.FileDropListener(this.mReplaceFile));
        }
        this.mEditPanel = this.getEditPanel();
        this.add((Component)this.mEditPanel, "7, 0");
    }

    protected JPanel getEditPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        double[][] dArrayArray = new double[][]{{-1.0}, {72.0, 14.0, 17.0, 14.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        transparentPanel.setLayout(tableLayout);
        if (this.mReplaceFile.exists()) {
            this.mDeleteButton.addActionListener(this.dfal);
            this.mDeleteButton.setHorizontalAlignment(2);
            transparentPanel.add((Component)this.mDeleteButton, "0, 3");
        }
        this.mSelectButton.addActionListener(this.rial);
        transparentPanel.add((Component)this.mSelectButton, "0, 1");
        return transparentPanel;
    }

    @Override
    protected void replaceResource(File file, File file2) {
        HashMap<String, String[]> hashMap = IconManager.mSystemApps;
        String string = ThemeHelper.stripSuffix(file.getName(), ".png");
        if (hashMap.containsKey(string)) {
            String[] stringArray = hashMap.get(string);
            for (int i = 2; i < stringArray.length; ++i) {
                super.replaceResource(new File(file.getAbsolutePath().replace(string, stringArray[i])), new File(file2.getAbsolutePath().replace(string, stringArray[i])));
            }
        } else {
            super.replaceResource(file, file2);
        }
    }

    @Override
    protected void deleteFile(File file) {
        HashMap<String, String[]> hashMap = IconManager.mSystemApps;
        String string = ThemeHelper.stripSuffix(file.getName(), ".png");
        if (hashMap.containsKey(string)) {
            String[] stringArray = hashMap.get(string);
            for (int i = 2; i < stringArray.length; ++i) {
                super.deleteFile(new File(file.getAbsolutePath().replace(string, stringArray[i])));
            }
        } else {
            super.deleteFile(file);
        }
    }
}

