/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class IconSync {
    public static final String PATH_XHDPI = "icons" + File.separator + "res" + File.separator + "drawable-xhdpi";
    public static final String PATH_HDPI = "icons" + File.separator + "res" + File.separator + "drawable-hdpi";
    public static final String PATH_ICONS = "icons";
    public static final String THEME_DEFAULT_ICON_PATH_V4 = "/system/media/theme/default/icons";
    public static final String THEME_DEFAULT_ICON_PATH_V5 = "/system/media/theme/miui_mod_icons";
    public static final String THEME_DEFAULT_ICON_TMP = ThemeHelper.getTmpFolder() + File.separator + "defaulticons";
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_FOLDER = ThemeHelper.getTmpFolder() + File.separator + "res";
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_HDPI = ThemeHelper.getTmpFolder() + File.separator + "res" + File.separator + "drawable-hdpi";
    public static final String THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_XHDPI = ThemeHelper.getTmpFolder() + File.separator + "res" + File.separator + "drawable-xhdpi";
    public static final String SHOW_APPS_ICONS = "/data/data/com.miui.themetool/app_appicon";
    public static final String THEME_ICONS_TMP = ThemeHelper.getTmpFolder() + File.separator + "syncicons";
    public static final String ICON_SUFFIX = ".png";
    private static HashSet<String> oldDefaultThemeSet = new HashSet();

    public static String getThemeIconsCatalog() {
        return ThemeHelper.getResourceCatalogPath() + File.separator + PATH_ICONS;
    }

    public static String getThemeIconsCatalogDefault() {
        return ThemeHelper.getResourceCatalogPath() + File.separator + "defaulticons";
    }

    public static String getImportThemeIconsCatalog() {
        return ThemeHelper.getImportResourceCatalogPath() + File.separator + PATH_ICONS;
    }

    public static String getImportThemeIconsCatalogDefault() {
        return ThemeHelper.getImportResourceCatalogPath() + File.separator + "defaulticons";
    }

    public static boolean syncIcons() {
        File file = new File(THEME_ICONS_TMP);
        if (file.exists()) {
            CmdUtils.deleteDir(THEME_ICONS_TMP);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = CmdUtils.adb_install(CmdUtils.IMPORT_APPS_APK_FILE);
        if (!bl) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("generate", PATH_ICONS);
        bl = CmdUtils.adb_shell_start("com.miui.themetool/com.miui.themetool.ShowAppsActivity", hashMap);
        if (!bl) {
            return false;
        }
        bl = ThemeHelper.waitForCompleteFile("/data/data/com.miui.themetool/app_appicon/complete");
        if (!bl) {
            return false;
        }
        bl = CmdUtils.adb_pull(SHOW_APPS_ICONS, THEME_ICONS_TMP);
        if (!bl) {
            return false;
        }
        new File(THEME_ICONS_TMP + File.separator + "complete").delete();
        IconSync.copyFiles(THEME_ICONS_TMP, IconSync.getImportThemeIconsCatalog());
        CmdUtils.deleteFile(THEME_ICONS_TMP);
        if (2 == ThemeHelper.getRomUIVersion()) {
            bl = CmdUtils.adb_pull(THEME_DEFAULT_ICON_PATH_V4, THEME_DEFAULT_ICON_TMP);
            if (!bl) {
                return false;
            }
            ThemeHelper.unzip(new File(THEME_DEFAULT_ICON_TMP), ThemeHelper.getTmpFolder());
            IconSync.copyFiles(THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_HDPI, IconSync.getImportThemeIconsCatalogDefault());
            IconSync.copyFiles(THEME_DEFAULT_ICON_TMP_UNZIPPED_ICONS_XHDPI, IconSync.getImportThemeIconsCatalogDefault());
            CmdUtils.deleteFile(THEME_DEFAULT_ICON_TMP);
            CmdUtils.deleteDir(THEME_DEFAULT_ICON_TMP_UNZIPPED_FOLDER);
        } else {
            bl = CmdUtils.adb_pull(THEME_DEFAULT_ICON_PATH_V5, THEME_DEFAULT_ICON_TMP);
            IconSync.copyFiles(THEME_DEFAULT_ICON_TMP, IconSync.getImportThemeIconsCatalogDefault());
            CmdUtils.deleteDir(THEME_DEFAULT_ICON_TMP);
            if (!bl) {
                return false;
            }
        }
        IconSync.removeOldDefaultTheme();
        IconManager.fillData();
        return true;
    }

    private static void removeOldDefaultTheme() {
        for (String string : oldDefaultThemeSet) {
            new File(IconSync.getImportThemeIconsCatalogDefault() + File.separator + string).delete();
        }
    }

    private static void copyFiles(String string, String string2) {
        File[] fileArray;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((fileArray = new File(string).listFiles()) == null) {
            return;
        }
        for (File file2 : fileArray) {
            try {
                ThemeHelper.copyFile(file2, new File(string2 + File.separator + file2.getName()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void cleanIcons() {
        CmdUtils.deleteDir(IconSync.getImportThemeIconsCatalog());
    }

    static {
        oldDefaultThemeSet.add("com.android.gallery.png");
    }
}

