/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.icon.IconFilterPanel;
import com.miui.theme.tool.icon.MockLauncher;
import com.miui.theme.tool.resource.ResourceFactory;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import miui.content.res.IconConfig;

class TransformPanel
extends NinePBackgroundPanel
implements KeyListener {
    private List<Float> mPointsMappingFrom = new ArrayList<Float>();
    private List<Float> mPointsMappingTo = new ArrayList<Float>();
    private ArrayList<JTextField> mPointsFromList;
    private ArrayList<JTextField> mPointsToList;
    private JButton mResetButton;
    private MockLauncher mPreviewPanel;
    private IconConfig mIconConfig;

    public TransformPanel(IconConfig iconConfig, MockLauncher mockLauncher) {
        this.setNinePBackground("icon/config_bg.9.png");
        this.mIconConfig = iconConfig;
        if (iconConfig.mPointsMappingFrom != null) {
            this.mPointsMappingFrom = iconConfig.mPointsMappingFrom;
        }
        if (iconConfig.mPointsMappingTo != null) {
            this.mPointsMappingTo = iconConfig.mPointsMappingTo;
        }
        this.mPreviewPanel = mockLauncher;
        if (this.mPointsMappingFrom.size() != 8) {
            this.mPointsMappingFrom.clear();
            this.mPointsMappingTo.clear();
            this.mPointsMappingFrom.add(Float.valueOf(0.0f));
            this.mPointsMappingFrom.add(Float.valueOf(0.0f));
            this.mPointsMappingFrom.add(Float.valueOf(0.0f));
            this.mPointsMappingFrom.add(Float.valueOf(90.0f));
            this.mPointsMappingFrom.add(Float.valueOf(90.0f));
            this.mPointsMappingFrom.add(Float.valueOf(90.0f));
            this.mPointsMappingFrom.add(Float.valueOf(90.0f));
            this.mPointsMappingFrom.add(Float.valueOf(0.0f));
            for (int i = 0; i < this.mPointsMappingFrom.size(); ++i) {
                this.mPointsMappingTo.add(this.mPointsMappingFrom.get(i));
            }
        }
        this.init();
    }

    private void init() {
        this.mPointsFromList = new ArrayList();
        this.mPointsToList = new ArrayList();
        double[][] dArrayArray = new double[][]{{33.0, 26.0, 62.0, 32.0, 62.0, 55.0, 26.0, 62.0, 32.0, 62.0, -1.0}, {56.0, 26.0, 50.0, 26.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        for (int i = 0; i < this.mPointsMappingTo.size() / 2; ++i) {
            this.mPointsToList.add(2 * i, new JTextField("" + this.mPointsMappingTo.get(2 * i)));
            this.mPointsToList.add(2 * i + 1, new JTextField("" + this.mPointsMappingTo.get(2 * i + 1)));
        }
        JLabel jLabel = new JLabel(ResourceFactory.getString("filter.upper_left"));
        jLabel.setFont(ThemeLookAndFeel.getBoldFont(12));
        this.add((Component)jLabel, "1, 0, 4, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.x")), "1, 1");
        this.add((Component)this.mPointsToList.get(0), "2, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.y")), "3, 1");
        this.add((Component)this.mPointsToList.get(1), "4, 1");
        JLabel jLabel2 = new JLabel(ResourceFactory.getString("filter.lower_left"));
        jLabel2.setFont(ThemeLookAndFeel.getBoldFont(12));
        this.add((Component)jLabel2, "1, 2, 4, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.x")), "1, 3");
        this.add((Component)this.mPointsToList.get(2), "2, 3");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.y")), "3, 3");
        this.add((Component)this.mPointsToList.get(3), "4, 3");
        JLabel jLabel3 = new JLabel(ResourceFactory.getString("filter.lower_right"));
        jLabel3.setFont(ThemeLookAndFeel.getBoldFont(12));
        this.add((Component)jLabel3, "6, 2, 4, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.x")), "6, 3");
        this.add((Component)this.mPointsToList.get(4), "7, 3");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.y")), "8, 3");
        this.add((Component)this.mPointsToList.get(5), "9, 3");
        JLabel jLabel4 = new JLabel(ResourceFactory.getString("filter.upper_right"));
        jLabel4.setFont(ThemeLookAndFeel.getBoldFont(12));
        this.add((Component)jLabel4, "6, 0, 4, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.x")), "6, 1");
        this.add((Component)this.mPointsToList.get(6), "7, 1");
        this.add((Component)new JLabel(ResourceFactory.getString("resource.y")), "8, 1");
        this.add((Component)this.mPointsToList.get(7), "9, 1");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.mResetButton = new JButton(ResourceFactory.getString("reset"));
        jPanel.add(this.mResetButton);
        this.add((Component)jPanel, "0, 4, 10, 1");
        this.mResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.mPointsMappingTo.clear();
                for (int i = 0; i < TransformPanel.this.mPointsMappingFrom.size(); ++i) {
                    TransformPanel.this.mPointsMappingTo.add(i, TransformPanel.this.mPointsMappingFrom.get(i));
                    ((JTextField)TransformPanel.this.mPointsToList.get(i)).setText("" + TransformPanel.this.mPointsMappingTo.get(i));
                }
                TransformPanel.this.refresh();
            }
        });
        for (int i = 0; i < this.mPointsToList.size(); ++i) {
            this.mPointsToList.get(i).addKeyListener(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.refresh();
    }

    public void refresh() {
        int n;
        this.mPointsMappingTo.clear();
        for (n = 0; n < this.mPointsToList.size(); ++n) {
            this.mPointsMappingTo.add(Float.valueOf(Float.parseFloat(this.mPointsToList.get(n).getText())));
        }
        for (n = 0; n < this.mPointsMappingTo.size(); ++n) {
            this.mIconConfig.mPointsMappingTo.set(n, Float.valueOf(Float.parseFloat(this.mPointsToList.get(n).getText())));
        }
        IconFilterPanel.refreshPreviewPanel(this.mPreviewPanel, this.mIconConfig);
    }
}

