/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchDecoder;
import com.miui.theme.tool.ninepatch.NinePatchEncoder;
import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NinePatchUtils {
    public static void compile(String string) throws NinePatchPngFormatException, IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                NinePatchUtils.compile(file2.getAbsolutePath());
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".9.png")) {
            NinePatchEncoder ninePatchEncoder = new NinePatchEncoder();
            ninePatchEncoder.encode(string, string);
        }
    }

    public static void decompile(String string) {
        block4: {
            File file;
            block3: {
                File[] fileArray;
                file = new File(string);
                if (!file.isDirectory()) break block3;
                for (File file2 : fileArray = file.listFiles()) {
                    NinePatchUtils.decompile(file2.getAbsolutePath());
                }
                break block4;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".9.png")) break block4;
            try {
                NinePatchDecoder.decode(string, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean compileSinglePng(String string, OutputStream outputStream) throws IOException, NinePatchPngFormatException {
        FileInputStream fileInputStream = new FileInputStream(string);
        NinePatchEncoder ninePatchEncoder = new NinePatchEncoder();
        return ninePatchEncoder.encode(fileInputStream, outputStream);
    }

    public static ByteArrayInputStream compileSinglePng(InputStream inputStream) throws NinePatchPngFormatException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        NinePatchEncoder ninePatchEncoder = new NinePatchEncoder();
        byteArrayInputStream = ninePatchEncoder.encode(inputStream);
        return byteArrayInputStream;
    }

    public static void getBytesFromInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n] = (byte)(n2 >>> 24);
    }
}

