/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.phone.uiautomator;

import com.android.ddmlib.IDevice;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.phone.uiautomator.IProgressMonitor;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorInstance;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class UiAutomatorTask
extends SwingWorker<Void, Void> {
    IDevice mDevice;
    private boolean mShowProgressDialog;

    public UiAutomatorTask(IDevice iDevice, boolean bl) {
        this.mDevice = iDevice;
        this.mShowProgressDialog = bl;
    }

    @Override
    protected Void doInBackground() {
        try {
            ProgressDialog progressDialog = this.mShowProgressDialog ? new ProgressDialog() : null;
            UiAutomatorInstance.getInstance().updateAutomatorData(this.mDevice, progressDialog);
        }
        catch (Exception exception) {
            GUIUtil.alert(exception.getMessage());
        }
        return null;
    }

    private class ProgressDialog
    extends JDialog
    implements IProgressMonitor {
        JLabel progressText;

        public ProgressDialog() {
            super((Frame)NewMainFrame.getInstance(), false);
            this.progressText = null;
            this.setTitle("Phone snapshot");
            this.setSize(600, 120);
            this.setLocationRelativeTo(NewMainFrame.getInstance());
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.progressText = new JLabel("Wait ...");
            this.progressText.setBorder(BorderFactory.createEmptyBorder(0, 30, 5, 0));
            this.add((Component)this.progressText, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.setVisible(true);
                }
            });
        }

        @Override
        public void beginTask() {
        }

        @Override
        public void done() {
            this.setVisible(false);
        }

        @Override
        public void subTask(String string) {
            this.progressText.setText(string);
        }
    }
}

