/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.Notifier;
import com.miui.theme.tool.resourceeditor.PointRectangle;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.SelectableJPanel;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ImageEditorPanel
extends SelectableJPanel
implements Observer {
    protected BufferedImage mImage;
    private int mWidth;
    private int mHeight;
    protected double mScale;
    protected Vector<Resource> mSelected;
    int active = 0;
    private Resource mCurrentResource;
    protected PointRectangle[] mSelections;
    protected Vector<Resource> mResources;
    protected Notifier mNotifier;
    private boolean lockResource = false;
    boolean mDragingFlag = false;
    MouseAdapter rma = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ImageEditorPanel.this.mDragingFlag = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ImageEditorPanel.this.mDragingFlag) {
                ImageEditorPanel.this.mSelected = new Vector();
                for (int i = 0; i < ImageEditorPanel.this.mSelections.length; ++i) {
                    if (!ImageEditorPanel.this.mSelections[i].contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                    ImageEditorPanel.this.mSelected.add(ImageEditorPanel.this.mResources.get(i));
                }
                Collections.sort(ImageEditorPanel.this.mSelected);
                if (ImageEditorPanel.this.mSelected.size() > 0) {
                    Vector<Resource> vector = new Vector<Resource>();
                    vector.add(ImageEditorPanel.this.mSelected.get(0));
                    for (int i = 1; i < ImageEditorPanel.this.mSelected.size() && ImageEditorPanel.this.mSelected.get(i).compareTo(ImageEditorPanel.this.mSelected.get(0)) == 0; ++i) {
                        vector.add(ImageEditorPanel.this.mSelected.get(i));
                    }
                    ImageEditorPanel.this.mSelected = vector;
                }
                ImageEditorPanel.this.mNotifier.doNotify(ImageEditorPanel.this.mSelected);
            }
            ImageEditorPanel.this.repaint();
            ImageEditorPanel.this.mDragingFlag = false;
        }
    };

    public ImageEditorPanel(BufferedImage bufferedImage) {
        this.mImage = bufferedImage;
        this.mScale = 690.0 / (double)bufferedImage.getHeight();
        this.fixSize();
        this.setToolTipText(ResourceFactory.getString("scroll_to_zoom"));
        this.bindScaleAction();
    }

    private void fixSize() {
        int n = (int)((double)this.mImage.getWidth() * this.mScale);
        int n2 = (int)((double)this.mImage.getHeight() * this.mScale);
        GUIUtil.fixSize(this, new Dimension(n, n2));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintSelectImage(graphics);
    }

    @Override
    public void paintSelectImage(Graphics graphics) {
        if (this.mImage == null) {
            return;
        }
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.mWidth, this.mHeight);
        int n = (int)((double)this.mImage.getWidth() * this.mScale);
        int n2 = (int)((double)this.mImage.getHeight() * this.mScale);
        graphics.drawImage(GUIUtil.scale(this.mImage, n, n2), 0, 0, n, n2, null);
    }

    @Override
    protected void drawSelection(PointRectangle pointRectangle) {
        int n = (int)((double)this.mImage.getWidth() * this.mScale);
        int n2 = (int)((double)this.mImage.getHeight() * this.mScale);
        if (pointRectangle.x + pointRectangle.width > n) {
            pointRectangle.x = n - pointRectangle.width;
        }
        if (pointRectangle.y + pointRectangle.height > n2) {
            pointRectangle.y = n2 - pointRectangle.height;
        }
        if (pointRectangle.x < 0) {
            pointRectangle.x = 0;
        }
        if (pointRectangle.y < 0) {
            pointRectangle.y = 0;
        }
        super.drawSelection(pointRectangle);
        if (this.lockResource) {
            return;
        }
        if (this.mCurrentResource == null) {
            return;
        }
        if (pointRectangle != null) {
            this.mCurrentResource.mX = (int)Math.round((double)pointRectangle.x / this.mScale);
            this.mCurrentResource.mY = (int)Math.round((double)pointRectangle.y / this.mScale);
            this.mCurrentResource.mWidth = (int)Math.round((double)pointRectangle.width / this.mScale);
            this.mCurrentResource.mHeight = (int)Math.round((double)pointRectangle.height / this.mScale);
            this.mNotifier.doNotify(this);
        }
    }

    protected void drawSelected() {
        this.mSelections = new PointRectangle[this.mResources.size()];
        for (int i = 0; i < this.mResources.size(); ++i) {
            Resource resource = this.mResources.get(i);
            this.mSelections[i] = new PointRectangle(new Rectangle((int)Math.round((double)resource.mX * this.mScale), (int)Math.round((double)resource.mY * this.mScale), (int)Math.round((double)resource.mWidth * this.mScale), (int)Math.round((double)resource.mHeight * this.mScale)));
            if (resource.equals(this.mCurrentResource)) continue;
            if (this.mSelected != null && this.mSelected.contains(this.mResources.get(i))) {
                this.selection_color = Color.BLUE;
                super.drawSelection(this.mSelections[i]);
                continue;
            }
            this.selection_color = Color.RED;
            super.drawSelection(this.mSelections[i]);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEditorPanel.this.resizeImage();
            }
        });
    }

    public void resizeImage() {
        if (this.mCurrentResource == null) {
            return;
        }
        if (this.mSelection != null) {
            this.wipeSelection();
        }
        this.mSelection = new PointRectangle(new Rectangle((int)Math.round((double)this.mCurrentResource.mX * this.mScale), (int)Math.round((double)this.mCurrentResource.mY * this.mScale), (int)Math.round((double)this.mCurrentResource.mWidth * this.mScale), (int)Math.round((double)this.mCurrentResource.mHeight * this.mScale)));
        if (this.mSelection != null) {
            this.lockResource = true;
            this.drawSelected();
            this.drawSelection(this.mSelection);
            this.lockResource = false;
            this.confirmSelection(this.mSelection);
        }
    }

    public void bindResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.mCurrentResource == null) {
            this.bindSelection();
        }
        this.mCurrentResource = resource;
        this.resizeImage();
    }

    public void unbindResource() {
        this.mCurrentResource = null;
        this.unbindSelection();
    }

    public void bindResources(Vector<Resource> vector) {
        if (vector == null) {
            return;
        }
        this.mResources = vector;
        this.mSelections = new PointRectangle[this.mResources.size()];
        this.bindScaleAction();
        this.bindSelect();
    }

    public void bindNotifier(Notifier notifier) {
        this.mNotifier = notifier;
        notifier.addObserver(this);
    }

    protected void bindSelect() {
        this.addMouseListener(this.rma);
        this.addMouseMotionListener(this.rma);
    }

    protected void bindScaleAction() {
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof JTextField) {
            this.lockResource = true;
            this.resizeImage();
            this.lockResource = false;
        }
    }
}

