/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resourceeditor.PointRectangle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.JPanel;

public abstract class SelectableJPanel
extends JPanel {
    private static final long serialVersionUID = -7159915510292362753L;
    int x;
    int y;
    PointRectangle mSelection;
    PointRectangle mLastSelection;
    int mActiveHandle = -1;
    Rectangle[] mHandles = new Rectangle[9];
    private MouseAdapter ma = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SelectableJPanel.this.mActiveHandle >= 0) {
                SelectableJPanel.this.wipeSelection();
                SelectableJPanel.this.drawSelection(SelectableJPanel.this.mSelection);
                SelectableJPanel.this.confirmSelection(SelectableJPanel.this.mSelection);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SelectableJPanel.this.x = mouseEvent.getX();
            SelectableJPanel.this.y = mouseEvent.getY();
            SelectableJPanel.this.mLastSelection = SelectableJPanel.this.mSelection;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            for (int i = 0; i < SelectableJPanel.this.mHandles.length; ++i) {
                if (SelectableJPanel.this.mHandles[i] == null || !SelectableJPanel.this.mHandles[i].contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                SelectableJPanel.this.mActiveHandle = i;
                switch (i) {
                    case 0: 
                    case 4: {
                        SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(5));
                        break;
                    }
                    case 1: 
                    case 5: {
                        SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(9));
                        break;
                    }
                    case 2: 
                    case 6: {
                        SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(4));
                        break;
                    }
                    case 3: 
                    case 7: {
                        SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(11));
                        break;
                    }
                    case 8: {
                        SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }
                return;
            }
            SelectableJPanel.this.mActiveHandle = -1;
            SelectableJPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SelectableJPanel.this.mActiveHandle >= 0) {
                if (SelectableJPanel.this.mSelection != null) {
                    SelectableJPanel.this.wipeSelection();
                }
                switch (SelectableJPanel.this.mActiveHandle) {
                    case 0: {
                        SelectableJPanel.this.mSelection = new PointRectangle(mouseEvent.getX(), mouseEvent.getY(), SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 1: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, mouseEvent.getY(), SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 2: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, mouseEvent.getY(), mouseEvent.getX(), SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 3: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, mouseEvent.getX(), SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 4: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, mouseEvent.getX(), mouseEvent.getY());
                        break;
                    }
                    case 5: {
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mSelection.x1, SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, mouseEvent.getY());
                        break;
                    }
                    case 6: {
                        SelectableJPanel.this.mSelection = new PointRectangle(mouseEvent.getX(), SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, mouseEvent.getY());
                        break;
                    }
                    case 7: {
                        SelectableJPanel.this.mSelection = new PointRectangle(mouseEvent.getX(), SelectableJPanel.this.mSelection.y1, SelectableJPanel.this.mSelection.x2, SelectableJPanel.this.mSelection.y2);
                        break;
                    }
                    case 8: {
                        int n = mouseEvent.getX() - SelectableJPanel.this.x;
                        int n2 = mouseEvent.getY() - SelectableJPanel.this.y;
                        SelectableJPanel.this.mSelection = new PointRectangle(SelectableJPanel.this.mLastSelection.x1 + n, SelectableJPanel.this.mLastSelection.y1 + n2, SelectableJPanel.this.mLastSelection.x2 + n, SelectableJPanel.this.mLastSelection.y2 + n2);
                    }
                }
            } else {
                return;
            }
            SelectableJPanel.this.drawSelection(SelectableJPanel.this.mSelection);
        }
    };
    protected Color selection_color = Color.RED;

    protected void bindSelection() {
        this.addMouseListener(this.ma);
        this.addMouseMotionListener(this.ma);
    }

    protected void unbindSelection() {
        this.removeMouseListener(this.ma);
        this.removeMouseMotionListener(this.ma);
        this.wipeSelection();
    }

    public void clearSelection() {
        this.mSelection = null;
        this.mActiveHandle = -1;
        for (int i = 0; i < this.mHandles.length; ++i) {
            this.mHandles[i] = null;
        }
    }

    protected void wipeSelection() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics().create();
        Area area = new Area(new Rectangle(this.mSelection.x, this.mSelection.y, this.mSelection.width + 1, this.mSelection.height + 1));
        area.subtract(new Area(new Rectangle(this.mSelection.x + 1, this.mSelection.y + 1, this.mSelection.width - 1, this.mSelection.height - 1)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width / 2 - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y + this.mSelection.height / 2 - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x + this.mSelection.width / 2 - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y + this.mSelection.height - 2, 5, 5)));
        area.add(new Area(new Rectangle(this.mSelection.x - 2, this.mSelection.y + this.mSelection.height / 2 - 2, 5, 5)));
        graphics2D.setClip(area);
        this.paintSelectImage(graphics2D);
    }

    public abstract void paintSelectImage(Graphics var1);

    protected void drawSelection(PointRectangle pointRectangle) {
        if (this.getGraphics() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics().create();
        graphics2D.setPaint(this.selection_color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics2D.draw(pointRectangle);
    }

    protected void confirmSelection(Rectangle rectangle) {
        int n;
        this.mSelection = new PointRectangle(rectangle);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (rectangle.isEmpty()) {
            this.clearSelection();
            return;
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setPaint(Color.BLUE);
        graphics2D.draw(rectangle);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics2D.draw(rectangle);
        this.mHandles[0] = new Rectangle(rectangle.x - 2, rectangle.y - 2, 4, 4);
        this.mHandles[1] = new Rectangle(rectangle.x + rectangle.width / 2 - 2, rectangle.y - 2, 4, 4);
        this.mHandles[2] = new Rectangle(rectangle.x + rectangle.width - 2, rectangle.y - 2, 4, 4);
        this.mHandles[3] = new Rectangle(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height / 2 - 2, 4, 4);
        this.mHandles[4] = new Rectangle(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2, 4, 4);
        this.mHandles[5] = new Rectangle(rectangle.x + rectangle.width / 2 - 2, rectangle.y + rectangle.height - 2, 4, 4);
        this.mHandles[6] = new Rectangle(rectangle.x - 2, rectangle.y + rectangle.height - 2, 4, 4);
        this.mHandles[7] = new Rectangle(rectangle.x - 2, rectangle.y + rectangle.height / 2 - 2, 4, 4);
        this.mHandles[8] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(Color.WHITE);
        for (n = 0; n < this.mHandles.length - 1; ++n) {
            graphics2D.fill(this.mHandles[n]);
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (n = 0; n < this.mHandles.length - 1; ++n) {
            graphics2D.draw(this.mHandles[n]);
        }
    }

    public Rectangle getSelection() {
        return this.mSelection;
    }
}

