/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ThemeValuesList;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ThemeValuesEditPage
extends CommonRightPanel {
    private TransparentPanel mTopPanel;
    private TransparentPanel mEditPanel;
    private JPanel mCommentPanel;
    private JLabel mNameLabel;
    private JLabel mCommentSecondaryLabel;
    private JPanel mEditPanel1;
    private JPanel mEditPanel2;
    private JLabel mCommentHtmlLabel;
    private JButton mResetButton = GUIUtil.createTransparentButton(ResourceFactory.getInstance().getImageIcon("tab/reset.png"), null, null, null);
    private JButton mResetButtonVertical = GUIUtil.createTransparentButton(ResourceFactory.getInstance().getImageIcon("tab/reset_vertical.png"), null, null, null);
    private ActionListener mResetActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ThemeValuesEditPage.this.mThemeValuesList.resetCurrentLine();
            ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
            ThemeValuesEditPage.this.refreshValue();
        }
    };
    private ThemeValuesList mThemeValuesList;
    public static Color sSecondaryTextColor = GUIUtil.hex2color("#b0b1b1");
    public static Color sEditColorTextColor = GUIUtil.hex2color("#7d7d7d");

    public ThemeValuesEditPage(ThemeValuesList themeValuesList) {
        this.mThemeValuesList = themeValuesList;
        this.mResetButton.addActionListener(this.mResetActionListener);
        this.mResetButton.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void refreshValue() {
        this.initTopPanel();
        this.initEditPanel();
        this.initCommentPanel();
        this.initLayout();
        this.revalidate();
        this.repaint();
    }

    public void initLayout() {
        this.removeAll();
        boolean bl = this.mThemeValuesList.getCurrentValue(0).equals("string");
        double[][] dArrayArray = bl ? new double[][]{{20.0, -1.0, 1.0}, {80.0, 60.0, 500.0, -1.0}} : new double[][]{{20.0, -1.0}, {80.0, 60.0, 50.0, 1.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mTopPanel, "1, 1");
        this.add((Component)this.mEditPanel, "1, 2");
        this.add((Component)new JScrollPane(this.mCommentPanel), "1, 4");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(GUIUtil.hex2color("#d9dadc"));
        if (bl) {
            this.add((Component)jPanel, "2, 0, 2, 3");
        } else {
            this.add((Component)jPanel, "0, 3, 1, 3");
        }
    }

    private void initTopPanel() {
        this.mTopPanel = new TransparentPanel();
        double[][] dArrayArray = new double[][]{{-1.0}, {20.0, 20.0, 20.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mTopPanel.setLayout(tableLayout);
        this.mNameLabel = new JLabel(this.mThemeValuesList.getCurrentValue(1));
        GUIUtil.hand(this.mNameLabel);
        this.mNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ThemeValuesEditPage.this.mThemeValuesList.browseSelectedWiki();
            }
        });
        this.mTopPanel.add((Component)this.mNameLabel, "0, 0");
        String string = ThemeValuesList.clearComment(this.mThemeValuesList.getCurrentValue(5));
        this.mCommentSecondaryLabel = new JLabel();
        this.mCommentSecondaryLabel.setText(GUIUtil.cutWord(this.mCommentSecondaryLabel, string, 400));
        this.mCommentSecondaryLabel.setForeground(sSecondaryTextColor);
        this.mTopPanel.add((Component)this.mCommentSecondaryLabel, "0, 1");
    }

    private void initEditPanel() {
        this.mEditPanel = new TransparentPanel();
        if (this.mThemeValuesList.getCurrentValue(0).equals("color")) {
            double[][] dArrayArray = new double[][]{{-1.0, 180.0, 44.0, 230.0}, {-1.0, 22.0, 20.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.mEditPanel.setLayout(tableLayout);
            this.mEditPanel1 = new ColorBaseValuePanel();
            this.mEditPanel2 = new ColorEditValuePanel();
            this.mEditPanel.add((Component)this.mEditPanel1, "1, 1");
            this.mEditPanel.add((Component)this.mEditPanel2, "3, 1");
            this.mEditPanel.add((Component)this.mResetButton, "2, 1");
        } else if (this.mThemeValuesList.getCurrentValue(0).equals("string")) {
            double[][] dArrayArray = new double[][]{{-1.0, 20.0}, {-1.0, 44.0, -1.0, 20.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.mEditPanel.setLayout(tableLayout);
            this.mEditPanel1 = new StringBaseValuePanel();
            this.mEditPanel2 = new StringEditValuePanel();
            this.mEditPanel.add((Component)this.mEditPanel1, "0, 0");
            this.mEditPanel.add((Component)this.mResetButtonVertical, "0, 1");
            this.mEditPanel.add((Component)this.mEditPanel2, "0, 2");
        } else {
            double[][] dArrayArray = new double[][]{{-1.0, 151.0, 44.0, 180.0}, {-1.0, 22.0, 20.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.mEditPanel.setLayout(tableLayout);
            this.mEditPanel1 = new CommonBaseValuePanel();
            this.mEditPanel2 = new CommonEditValuePanel();
            this.mEditPanel.add((Component)this.mEditPanel1, "1, 1");
            this.mEditPanel.add((Component)this.mEditPanel2, "3, 1");
            this.mEditPanel.add((Component)this.mResetButton, "2, 1");
        }
    }

    private void initCommentPanel() {
        this.mCommentPanel = new CommonRightPanel();
        this.mCommentHtmlLabel = new JLabel(ThemeValuesList.correctCommentImageUrl(this.mThemeValuesList.getCurrentValue(5)));
        CommonRightPanel commonRightPanel = new CommonRightPanel();
        commonRightPanel.setLayout(new BorderLayout());
        commonRightPanel.add((Component)this.mCommentHtmlLabel, "North");
        double[][] dArrayArray = new double[][]{{-1.0, 20.0}, {20.0, -1.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mCommentPanel.setLayout(tableLayout);
        this.mCommentPanel.add((Component)commonRightPanel, "0, 1");
    }

    class TextArea
    extends JTextArea {
        private NinePatch mPatch = GUIUtil.getNinePatch("tab/input_box.9.png");

        public TextArea() {
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.setBackground(GUIUtil.TRANSPARENT);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.mPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(graphics);
        }
    }

    class ColorEditValuePanel
    extends ColorBaseValuePanel {
        public JTextField mTransparentTextField;
        private KeyListener mValueKeyListener;
        private KeyListener mTransparentKeyListener;
        private MouseListener mMouseListener;

        public ColorEditValuePanel() {
            this.mValueKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    ThemeValuesEditPage.this.mThemeValuesList.setCurrentNewValue(ColorEditValuePanel.this.mValueTextField.getText());
                    ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
                    ColorEditValuePanel.this.refreshTransparent();
                }
            };
            this.mTransparentKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    ColorEditValuePanel.this.refreshValueByTransparent();
                }
            };
            this.mMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Color color = JColorChooser.showDialog(NewMainFrame.getInstance(), "change color", GUIUtil.hex2color(ColorEditValuePanel.this.mValueTextField.getText()));
                    if (color != null) {
                        ColorEditValuePanel.this.setCurrentValue(color);
                    }
                }
            };
            this.mLabel.setText(ResourceFactory.getString("CurrentValue"));
            this.mColorPanel.setBackground(GUIUtil.hex2color(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue()));
            GUIUtil.hand(this.mColorPanel);
            this.mColorPanel.addMouseListener(this.mMouseListener);
            this.mValueTextField.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue());
            this.mTransparentTextField = new JTextField();
            this.mTransparentTextField.setHorizontalAlignment(0);
            this.refreshTransparent();
            this.mTransparentTextField.addKeyListener(this.mTransparentKeyListener);
            this.initLayout2();
            this.mValueTextField.addKeyListener(this.mValueKeyListener);
        }

        protected void refreshValueByTransparent() {
            Color color = GUIUtil.hex2color(this.mValueTextField.getText());
            if (color == null) {
                return;
            }
            String string = this.mTransparentTextField.getText();
            if (string.isEmpty()) {
                return;
            }
            int n = Integer.parseInt(string = string.substring(0, string.length() - 1));
            if (n > 100 || n < 0) {
                return;
            }
            n = n * 255 / 100;
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            ThemeValuesEditPage.this.mThemeValuesList.setCurrentNewValue(GUIUtil.color2hex(color));
            this.mValueTextField.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(4));
            ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
            this.refreshColorPanel();
        }

        private void setCurrentValue(Color color) {
            ThemeValuesEditPage.this.mThemeValuesList.setCurrentNewValue(GUIUtil.color2hex(color));
            this.mValueTextField.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(4));
            ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
            this.refreshTransparent();
        }

        public void refreshTransparent() {
            Color color = GUIUtil.hex2color(this.mValueTextField.getText());
            if (color == null) {
                return;
            }
            String string = 100 * color.getAlpha() / 255 + "%";
            this.mTransparentTextField.setText(string);
            this.refreshColorPanel();
        }

        public void refreshColorPanel() {
            Color color = GUIUtil.hex2color(this.mValueTextField.getText());
            if (color == null) {
                return;
            }
            this.mColorPanel.setBackground(color);
            this.repaint();
        }

        public void initLayout2() {
            double[][] dArrayArray = new double[][]{{54.0, 11.0, 40.0, 5.0, 22.0, 5.0, 86.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "0, 0");
            this.add((Component)this.mTransparentTextField, "2, 0");
            if (this.mColorPanel != null) {
                this.add((Component)this.mColorPanel, "4, 0");
            }
            this.add((Component)this.mValueTextField, "6, 0");
        }
    }

    class ColorBaseValuePanel
    extends ValuePanel {
        public JPanel mColorPanel;
        public JTextField mValueTextField;

        public ColorBaseValuePanel() {
            this.mColorPanel = new JPanel();
            this.mColorPanel.setBackground(GUIUtil.hex2color(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(2)));
            this.mValueTextField = new JTextField(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(2));
            this.mValueTextField.setHorizontalAlignment(0);
            this.initLayout();
        }

        public void initLayout() {
            double[][] dArrayArray = new double[][]{{54.0, 11.0, 22.0, 5.0, 86.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "0, 0");
            if (this.mColorPanel != null) {
                this.add((Component)this.mColorPanel, "2, 0");
            }
            this.add((Component)this.mValueTextField, "4, 0");
        }
    }

    class StringEditValuePanel
    extends StringBaseValuePanel {
        private KeyListener mKeyListener;

        public StringEditValuePanel() {
            this.mKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    ThemeValuesEditPage.this.mThemeValuesList.setCurrentNewValue(StringEditValuePanel.this.mValueTextArea.getText());
                    ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
                }
            };
            this.mLabel.setText(ResourceFactory.getString("CurrentValue"));
            this.mValueTextArea.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue());
            this.mValueTextArea.addKeyListener(this.mKeyListener);
        }
    }

    class StringBaseValuePanel
    extends ValuePanel {
        protected JTextArea mValueTextArea;

        public StringBaseValuePanel() {
            this.mValueTextArea = new TextArea();
            this.mValueTextArea.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(2));
            this.initLayout();
        }

        public void initLayout() {
            double[][] dArrayArray = new double[][]{{6.0, -1.0}, {40.0, 7.0, -1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "1, 0");
            this.mLabel.setHorizontalAlignment(2);
            this.add((Component)new JScrollPane(this.mValueTextArea), "0, 2, 1, 2");
        }
    }

    class CommonEditValuePanel
    extends CommonBaseValuePanel {
        private KeyListener mKeyListener;

        public CommonEditValuePanel() {
            this.mKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    ThemeValuesEditPage.this.mThemeValuesList.setCurrentNewValue(CommonEditValuePanel.this.mValueTextField.getText());
                    ThemeValuesEditPage.this.mThemeValuesList.saveThemeValues();
                }
            };
            this.mLabel.setText(ResourceFactory.getString("CurrentValue"));
            this.mValueTextField.setText(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue());
            this.mValueTextField.addKeyListener(this.mKeyListener);
        }
    }

    class CommonBaseValuePanel
    extends ValuePanel {
        public JTextField mValueTextField;

        public CommonBaseValuePanel() {
            this.mValueTextField = new JTextField(ThemeValuesEditPage.this.mThemeValuesList.getCurrentValue(2));
            this.mValueTextField.setHorizontalAlignment(0);
            this.initLayout();
        }

        public void initLayout() {
            double[][] dArrayArray = new double[][]{{54.0, 11.0, 86.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "0, 0");
            this.add((Component)this.mValueTextField, "2, 0");
        }
    }

    class ValuePanel
    extends CommonRightPanel {
        public JLabel mLabel;

        public ValuePanel() {
            this.initLabels();
        }

        private void initLabels() {
            this.mLabel = new JLabel(ResourceFactory.getString("DefaultValue"));
            this.mLabel.setForeground(sEditColorTextColor);
        }
    }
}

