/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.android.ddmlib.Log;
import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.catalog.MIUIThemeValues;
import com.miui.theme.tool.catalog.ThemeValueComparator;
import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.ConfirmDialog;
import com.miui.theme.tool.phone.reg.AndroidStringMatchUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.RefreshPageListener;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.Wiki;
import com.miui.theme.tool.util.WikiImageManager;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class ThemeValuesList
extends JList {
    private String mPackageName;
    private String mFilteredResourceScope;
    private String mFilteredResourceType;
    private Vector<Vector<String>> mThemeValues;
    private Vector<Vector<String>> mCatalogThemeValues;
    private Vector<Vector<String>> mFrameworkThemeValues;
    private Vector<Vector<String>> mFrameworkMiuiThemeValues;
    private HashMap<String, Vector<String>> mThemeHashMap;
    private Vector<Vector<String>> mCatalogThemeData;
    private HashMap<String, Vector<String>> mCatalogHashMap;
    private Vector<Vector<String>> mCatalogModelFiltered;
    private SnapshotTextMapHelper mSnapshotTextHelper = new SnapshotTextMapHelper();
    private long mLastModified;
    public static final int TYPE = 0;
    public static final int NAME = 1;
    public static final int VALUE = 2;
    public static final int PACKAGE = 3;
    public static final int NEWVALUE = 4;
    public static final int COMMENT = 5;
    public static final Color sSecondaryTitleColor = GUIUtil.hex2color("#b0b1b1");
    public static final Color sSelectedBackgroundColor = GUIUtil.hex2color("#eaecee");
    NinePatch mPatch = GUIUtil.getNinePatch("tab/theme_values_list_bg.9.png");
    public static final Color sThemeValuesSepColor = GUIUtil.hex2color("#d9dadc");
    public Thread mLoadNetCommentThread = null;
    private RefreshPageListener mRefreshPageListener;

    public ThemeValuesList(String string) {
        this.mPackageName = string;
        this.mFilteredResourceType = "color";
        this.mFilteredResourceScope = "";
        this.setBackground(GUIUtil.COMMON_RIGHT_BACKGROUND_COLOR);
        this.initData();
        this.sortThemeData();
        this.setCellRenderer(new Renderer());
        this.setFilter(this.mFilteredResourceType, this.mFilteredResourceScope);
        this.setModel(new ListModel());
        this.setSelectionMode(2);
        this.bindKeyListener();
    }

    public void initData() {
        Object object;
        File file = new File(ConfigUtil.getThemePath() + File.separator + this.mPackageName + File.separator + "theme_values.xml");
        File file2 = new File(ThemeHelper.getResourceCatalogPath() + File.separator + this.mPackageName + File.separator + "theme_values.xml");
        File file3 = new File(ThemeHelper.getResourceCatalogPath() + File.separator + "framework-res" + File.separator + "theme_values.xml");
        File file4 = new File(ThemeHelper.getResourceCatalogPath() + File.separator + "framework-miui-res" + File.separator + "theme_values.xml");
        this.mLastModified = file.lastModified();
        this.mThemeValues = ThemeValuesList.getThemeValuesExtended(file);
        this.mCatalogThemeValues = ThemeValuesList.getThemeValuesExtended(file2);
        this.mFrameworkThemeValues = ThemeValuesList.getThemeValuesExtended(file3);
        this.mFrameworkMiuiThemeValues = ThemeValuesList.getThemeValuesExtended(file4);
        this.mCatalogHashMap = new HashMap();
        this.mCatalogThemeData = (Vector)this.mCatalogThemeValues.clone();
        for (Vector<String> object2 : this.mCatalogThemeData) {
            this.mCatalogHashMap.put(MIUIThemeValues.getMapKey(object2), object2);
        }
        if (!this.mPackageName.equals("framework-res") && !this.mPackageName.equals("framework-miui-res")) {
            for (Vector<String> vector : this.mFrameworkThemeValues) {
                vector.set(3, "android");
                this.mCatalogThemeData.add(vector);
                this.mCatalogHashMap.put(MIUIThemeValues.getMapKey(vector), vector);
            }
            for (Vector vector : this.mFrameworkMiuiThemeValues) {
                vector.set(3, "miui");
                this.mCatalogThemeData.add(vector);
                this.mCatalogHashMap.put(MIUIThemeValues.getMapKey(vector), vector);
            }
        }
        this.mThemeHashMap = new HashMap();
        for (Vector<String> vector : this.mThemeValues) {
            object = MIUIThemeValues.getMapKey(vector);
            if (this.mCatalogHashMap.containsKey(object)) {
                if (this.mCatalogHashMap.get(object).get(2).equals(vector.get(4))) continue;
                this.mThemeHashMap.put((String)object, vector);
                continue;
            }
            this.mThemeHashMap.put((String)object, vector);
        }
        for (String string : this.mThemeHashMap.keySet()) {
            if (!this.mCatalogHashMap.containsKey(string)) {
                this.mThemeHashMap.get(string).set(2, "");
                object = ThemeValuesList.cloneLine(this.mThemeHashMap.get(string));
                ((Vector)object).set(4, "");
                this.mCatalogThemeData.add((Vector<String>)object);
                continue;
            }
            this.mThemeHashMap.get(string).set(2, this.mCatalogHashMap.get(string).get(2));
        }
    }

    private void sortThemeData() {
        Collections.sort(this.mCatalogThemeData, new ThemeValueComparator());
    }

    public void setFilter(String string, String string2) {
        this.mFilteredResourceType = string;
        this.mFilteredResourceScope = string2;
        this.updateShowingContent(false);
        this.fillComments();
    }

    public Vector<Vector<String>> getFilteredThemeValues(String string, String string2) {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        for (Vector<String> vector2 : this.mCatalogThemeData) {
            if (!vector2.get(0).equals(string) || !vector2.get(3).equals(string2)) continue;
            vector.add(vector2);
        }
        return vector;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getFilteredResourceType() {
        return this.mFilteredResourceType;
    }

    public String getFilteredResourceScope() {
        return this.mFilteredResourceScope;
    }

    public boolean canHaveSnapshotView() {
        return "".equals(this.mFilteredResourceScope) && "string".equals(this.mFilteredResourceType);
    }

    public void setSnapshotTextList(List<String> list) {
        this.mSnapshotTextHelper.updateSnapshotTextList(list);
    }

    public void updateShowingContent(boolean bl) {
        if (bl && this.canHaveSnapshotView()) {
            this.mCatalogModelFiltered = this.mSnapshotTextHelper.getMatchedThemeStringList();
            if (this.mCatalogModelFiltered.isEmpty()) {
                GUIUtil.toast(ResourceFactory.getString("snapshot_no_text_after_filtered"));
            }
        } else {
            this.mCatalogModelFiltered = this.getFilteredThemeValues(this.mFilteredResourceType, this.mFilteredResourceScope);
        }
        this.updateUI();
    }

    public boolean isSnapshotFilteredMode() {
        return this.mCatalogModelFiltered == this.mSnapshotTextHelper.getMatchedThemeStringList();
    }

    public void selectThemeStringItemBySnapshotText(String string) {
        List<String> list = this.mSnapshotTextHelper.getMatchedThemeStringName(string);
        if (list != null && !list.isEmpty()) {
            int[] nArray = new int[list.size()];
            int n = 0;
            for (String string2 : list) {
                for (int i = 0; i < this.mCatalogModelFiltered.size(); ++i) {
                    Vector<String> vector = this.mCatalogModelFiltered.get(i);
                    if (!vector.get(1).equals(string2)) continue;
                    nArray[n++] = i;
                }
            }
            Arrays.sort(nArray);
            this.setSelectedIndices(nArray);
            this.ensureIndexIsVisible(nArray[0]);
            if (nArray.length > 1) {
                this.ensureIndexIsVisible(nArray[nArray.length - 1]);
            }
        }
    }

    public String getSnapshotTextOfCurrentValue() {
        String string = this.getCurrentValue(0);
        if (string.equals("string")) {
            return this.mSnapshotTextHelper.getMatchedSnapshotText(this.getCurrentValue(1));
        }
        return null;
    }

    public static Vector<Vector<String>> getThemeValuesExtended(File file) {
        Vector<Vector<String>> vector = MIUIThemeValues.getThemeValuesFromFile(file);
        for (Vector<String> vector2 : vector) {
            vector2.add(4, vector2.get(2));
            vector2.add(5, "");
        }
        return vector;
    }

    public static Vector<String> cloneLine(Vector<String> vector) {
        return (Vector)vector.clone();
    }

    public static String clearComment(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.indexOf("<img") != -1) {
            string = string.replaceAll("<a href.*<img.*/a>", "<font color='blue'>" + ResourceFactory.getString("picture") + "</font>");
        }
        if (string.indexOf("<br") != -1) {
            string = string.replaceAll("<br.*?/?>", "");
        }
        return string;
    }

    public void browseSelectedWiki() {
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            URI uRI = URI.create("http://wiki.dev.xiaomi.com/index.php?title=" + this.getWikiPath(nArray[i]));
            try {
                Desktop.getDesktop().browse(uRI);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.mPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), this.getHeight());
    }

    private void setComment(int n, String string) {
        if (string != null && !string.isEmpty()) {
            string = "<html>" + string + "</html>";
            this.setValueAt(string, n, 5);
        }
    }

    public void setCurrentNewValue(String string) {
        this.setValueAt(string, this.getSelectedIndex(), 4);
        this.updateUI();
    }

    public String getCurrentValue(int n) {
        return this.getValueAt(this.getSelectedIndex(), n);
    }

    public String getCurrentValue() {
        return this.getValueAt(this.getSelectedIndex(), 4);
    }

    private String getValueAt(int n, int n2) {
        String string = MIUIThemeValues.getMapKey(this.mCatalogModelFiltered.get(n));
        if ((n2 == 4 || n2 == 3) && this.mThemeHashMap.containsKey(string)) {
            return this.mThemeHashMap.get(string).get(n2);
        }
        return this.mCatalogModelFiltered.get(n).get(n2);
    }

    private boolean isValueEdited(int n) {
        String string = MIUIThemeValues.getMapKey(this.mCatalogModelFiltered.get(n));
        return this.mThemeHashMap.containsKey(string);
    }

    public void setValueAt(String string, int n, int n2) {
        if (string == null) {
            return;
        }
        Vector<String> vector = this.mCatalogModelFiltered.get(n);
        String string2 = MIUIThemeValues.getMapKey(vector);
        if (n2 == 4) {
            if (string.equals(vector.get(4))) {
                if (this.mThemeHashMap.containsKey(string2)) {
                    this.mThemeHashMap.remove(string2);
                }
            } else if (this.mThemeHashMap.containsKey(string2)) {
                this.mThemeHashMap.get(string2).set(4, string.toString());
            } else {
                Vector<String> vector2 = ThemeValuesList.cloneLine(vector);
                vector2.set(4, string.toString());
                this.mThemeHashMap.put(string2, vector2);
            }
        } else if (n2 == 5) {
            this.mCatalogModelFiltered.get(n).set(5, string);
        }
    }

    private void loadNetComment(int n) {
        String string = null;
        String string2 = this.getWikiPath(n);
        Wiki wiki = new Wiki("wiki.dev.xiaomi.com", "");
        wiki.setUsingCompressedRequests(false);
        wiki.setThrottle(5000);
        try {
            string = wiki.getRenderedText(string2);
            if (string.startsWith("<p><a href=\"/")) {
                return;
            }
            this.writeCommentCache(string2, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string2.contains("folder_icon_title_text_shadow")) {
            Log.i((String)"LOG", (String)string2);
        }
        if (string.indexOf("<img") != -1) {
            Vector<String> vector = ThemeValuesList.getImagePaths(string);
            for (String string3 : vector) {
                string3 = "/" + string3.substring(string3.indexOf("images"));
                WikiImageManager.getInstance().addDownloadTask(string3);
            }
        }
        this.setComment(n, string);
    }

    private String getWikiPath(int n) {
        if (this.getValueAt(n, 3).equals("android")) {
            return "theme_values/framework-res/" + this.getValueAt(n, 1);
        }
        if (this.getValueAt(n, 3).equals("miui")) {
            return "theme_values/framework-miui-res/" + this.getValueAt(n, 1);
        }
        String string = "";
        if (ResourceFactory.sLocale != null && !ResourceFactory.sLocale.toString().equals("zh_CN")) {
            string = "en/";
        }
        return "theme_values/" + string + this.mPackageName + "/" + this.getValueAt(n, 1);
    }

    private void loadLocalComment(int n) {
        String string = this.getWikiPath(n);
        String string2 = this.loadCommentCache(string);
        if (string2 != null) {
            if (string2.isEmpty()) {
                String string3 = ThemeHelper.getTmpFolder() + File.separator + string;
                new File(string3).delete();
            } else {
                this.setComment(n, string2);
            }
        }
    }

    private void writeCommentCache(String string, String string2) {
        String string3 = ThemeHelper.getTmpFolder() + File.separator + string;
        File file = new File(string3);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ThemeHelper.writeToFile(file, string2);
    }

    private String loadCommentCache(String string) {
        string = ThemeHelper.assurePath(string);
        String string2 = ThemeHelper.getTmpFolder() + File.separator + string;
        File file = new File(string2);
        if (file.exists()) {
            return ThemeHelper.readFromFile(file);
        }
        return null;
    }

    public void fillComments() {
        this.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ThemeValuesList.this.mCatalogModelFiltered.size(); ++i) {
                    ThemeValuesList.this.loadLocalComment(i);
                }
                ThemeValuesList.this.clearSelection();
                ThemeValuesList.this.updateUI();
                if (!ThemeHelper.isInnerUserMode()) {
                    return;
                }
                ThemeValuesList.this.mLoadNetCommentThread = new Thread(){

                    @Override
                    public void run() {
                        for (int i = 0; i < ThemeValuesList.this.getModel().getSize(); ++i) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            ThemeValuesList.this.loadNetComment(i);
                        }
                    }
                };
                ThemeValuesList.this.mLoadNetCommentThread.start();
            }
        });
    }

    public static String correctCommentImageUrl(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.indexOf("<img") != -1) {
            Vector<String> vector = ThemeValuesList.getImagePaths(string);
            for (String string2 : vector) {
                String string3 = WikiImageManager.getInstance().getImageUrl(string2);
                if (string3 == null) {
                    string = string.replaceAll("<img.*?src=\"" + string2 + "\".*?/>", "<font color='blue'>" + ResourceFactory.getString("loading") + "</font>");
                    continue;
                }
                string = string.replaceAll("<a href.*?(<img.*?/>).*?/a>", "$1");
                string = string.replace(string2, string3);
            }
        }
        return string;
    }

    private static Vector<String> getImagePaths(String string) {
        Vector<String> vector = new Vector<String>();
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            vector.add(matcher.group(1));
        }
        return vector;
    }

    public void setRefreshPageListener(RefreshPageListener refreshPageListener) {
        this.mRefreshPageListener = refreshPageListener;
    }

    public synchronized boolean saveThemeValues() {
        Serializable serializable;
        File file = new File(ConfigUtil.getThemePath() + File.separator + this.mPackageName + File.separator + "theme_values.xml");
        if (file.lastModified() > this.mLastModified) {
            serializable = new ConfirmDialog(ResourceFactory.getString("Notice"), ResourceFactory.getString("ReloadThemeValues"));
            ((Dialog)serializable).setVisible(true);
            if (((ConfirmDialog)serializable).mResult == "yes") {
                this.reloadThemeValues();
                return false;
            }
        }
        serializable = this.mThemeHashMap;
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        for (String string : ((HashMap)serializable).keySet()) {
            Vector vector2 = (Vector)((HashMap)serializable).get(string);
            Vector vector3 = new Vector();
            vector3.add(0, vector2.get(0));
            vector3.add(1, vector2.get(1));
            vector3.add(2, vector2.get(4));
            vector3.add(3, vector2.get(3));
            vector.add(vector3);
        }
        MIUIThemeValues mIUIThemeValues = new MIUIThemeValues();
        mIUIThemeValues.setXmlFile(file);
        mIUIThemeValues.setAll(vector);
        mIUIThemeValues.setSaveHelpData(this.mCatalogThemeValues);
        mIUIThemeValues.save();
        this.mLastModified = file.lastModified();
        return true;
    }

    private void reloadThemeValues() {
        int n = this.getSelectedIndex();
        this.initData();
        this.sortThemeData();
        this.updateUI();
        this.mRefreshPageListener.onRefresh();
    }

    public void resetCurrentLine() {
        this.resetLine(this.getSelectedIndex());
    }

    public void resetLine(int n) {
        String string = MIUIThemeValues.getMapKey(this.mCatalogModelFiltered.get(n));
        if (this.mThemeHashMap.containsKey(string)) {
            this.mThemeHashMap.remove(string);
        }
        this.updateUI();
    }

    private void bindKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                Object object2;
                if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    if (ThemeValuesList.this.getSelectedIndex() < 0) {
                        return;
                    }
                    object2 = new StringSelection(ThemeValuesList.this.getValueAt(ThemeValuesList.this.getSelectedIndex(), 4).toString());
                    object = ThemeValuesList.this.getToolkit().getSystemClipboard();
                    ((Clipboard)object).setContents((Transferable)object2, null);
                    keyEvent.consume();
                }
                if (keyEvent.getKeyCode() == 88 && keyEvent.isControlDown()) {
                    if (ThemeValuesList.this.getSelectedIndex() < 0) {
                        return;
                    }
                    object2 = new StringSelection(ThemeValuesList.this.getValueAt(ThemeValuesList.this.getSelectedIndex(), 1).toString());
                    object = ThemeValuesList.this.getToolkit().getSystemClipboard();
                    ((Clipboard)object).setContents((Transferable)object2, null);
                    keyEvent.consume();
                }
                if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && (object = ((Clipboard)(object2 = ThemeValuesList.this.getToolkit().getSystemClipboard())).getContents(null)) != null && object.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String string = (String)object.getTransferData(DataFlavor.stringFlavor);
                        int[] nArray = ThemeValuesList.this.getSelectedIndices();
                        for (int i = 0; i < nArray.length; ++i) {
                            ThemeValuesList.this.setValueAt(string, nArray[i], 4);
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    ThemeValuesList.this.saveThemeValues();
                    ThemeValuesList.this.updateUI();
                    keyEvent.consume();
                }
                if (keyEvent.getKeyCode() == 82 && keyEvent.isControlDown()) {
                    object2 = ThemeValuesList.this.getSelectedIndices();
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        ThemeValuesList.this.resetLine((int)object2[i]);
                    }
                    ThemeValuesList.this.saveThemeValues();
                    keyEvent.consume();
                }
                if (keyEvent.isControlDown()) {
                    if (keyEvent.getKeyCode() == 65) {
                        return;
                    }
                    keyEvent.consume();
                }
            }
        });
    }

    class DownLineCommonRightPanel
    extends CommonRightPanel {
        DownLineCommonRightPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(sThemeValuesSepColor);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
    }

    class Renderer
    implements ListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Vector vector = (Vector)object;
            DownLineCommonRightPanel downLineCommonRightPanel = new DownLineCommonRightPanel();
            if (bl) {
                downLineCommonRightPanel.setBackground(sSelectedBackgroundColor);
            }
            JLabel jLabel = new JLabel();
            jLabel.setText(GUIUtil.cutWord(jLabel, (String)vector.get(1), 270));
            if (ThemeValuesList.this.isValueEdited(n)) {
                jLabel.setForeground(GUIUtil.BASE_BLUE);
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            String string = ThemeValuesList.clearComment((String)vector.get(5));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(GUIUtil.cutWord(jLabel2, string, 250));
            jLabel2.setForeground(sSecondaryTitleColor);
            double[][] dArrayArray = new double[][]{{10.0, -1.0, 28.0, 16.0}, {16.0, 14.0, 14.0, 16.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            downLineCommonRightPanel.setLayout(tableLayout);
            downLineCommonRightPanel.add((Component)jLabel, "1, 0, 1, 1");
            downLineCommonRightPanel.add((Component)jLabel2, "1, 2, 1, 3");
            if (((String)vector.get(0)).equals("color")) {
                Color color = GUIUtil.hex2color((String)vector.get(4));
                JPanel jPanel = new JPanel();
                jPanel.setBackground(color);
                downLineCommonRightPanel.add((Component)jPanel, "2, 1, 2, 2");
            }
            downLineCommonRightPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ThemeValuesList.this.browseSelectedWiki();
                }
            });
            return downLineCommonRightPanel;
        }
    }

    class ListModel
    extends AbstractListModel {
        ListModel() {
        }

        @Override
        public int getSize() {
            return ThemeValuesList.this.mCatalogModelFiltered.size();
        }

        @Override
        public Object getElementAt(int n) {
            String string = MIUIThemeValues.getMapKey((Vector)ThemeValuesList.this.mCatalogModelFiltered.get(n));
            if (ThemeValuesList.this.mThemeHashMap.containsKey(string)) {
                return ThemeValuesList.this.mThemeHashMap.get(string);
            }
            return ThemeValuesList.this.mCatalogModelFiltered.get(n);
        }
    }

    private class SnapshotTextMapHelper {
        private HashMap<String, String> stringNameToSnapshotTextMap = new HashMap();
        private HashMap<String, List<String>> snapshotTextToStringNameMap = new HashMap();
        private Vector<Vector<String>> snapshotMatchedThemeStringList = new Vector();

        private SnapshotTextMapHelper() {
        }

        public Vector<Vector<String>> getMatchedThemeStringList() {
            return this.snapshotMatchedThemeStringList;
        }

        public List<String> getMatchedThemeStringName(String string) {
            return this.snapshotTextToStringNameMap.get(string);
        }

        public String getMatchedSnapshotText(String string) {
            return this.stringNameToSnapshotTextMap.get(string);
        }

        /*
         * WARNING - void declaration
         */
        public void updateSnapshotTextList(List<String> list) {
            this.stringNameToSnapshotTextMap.clear();
            this.snapshotTextToStringNameMap.clear();
            Vector<Vector<String>> vector = ThemeValuesList.this.getFilteredThemeValues(ThemeValuesList.this.mFilteredResourceType, ThemeValuesList.this.mFilteredResourceScope);
            for (int i = vector.size() - 1; i >= 0; --i) {
                Vector<String> object = vector.get(i);
                boolean list2 = false;
                for (String string : list) {
                    void var8_15;
                    if (!AndroidStringMatchUtils.matchAnroidString(object.get(2), string)) continue;
                    this.stringNameToSnapshotTextMap.put(object.get(1), string);
                    List<String> list3 = this.snapshotTextToStringNameMap.get(string);
                    if (list3 == null) {
                        LinkedList linkedList = new LinkedList();
                        this.snapshotTextToStringNameMap.put(string, linkedList);
                    }
                    var8_15.add(object.get(1));
                    list2 = true;
                    break;
                }
                if (list2) continue;
                vector.remove(i);
            }
            Collections.sort(vector, new Comparator<Vector<String>>(){

                @Override
                public int compare(Vector<String> vector, Vector<String> vector2) {
                    String string = vector.get(1);
                    String string2 = (String)SnapshotTextMapHelper.this.stringNameToSnapshotTextMap.get(string);
                    String string3 = vector2.get(1);
                    String string4 = (String)SnapshotTextMapHelper.this.stringNameToSnapshotTextMap.get(string3);
                    if (string2.equals(string4)) {
                        return string.compareTo(string3);
                    }
                    return string2.compareTo(string4);
                }
            });
            this.snapshotMatchedThemeStringList = vector;
            for (String string : this.snapshotTextToStringNameMap.keySet()) {
                List<String> list4 = this.snapshotTextToStringNameMap.get(string);
                if (list4.size() <= 1) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : list4) {
                    stringBuilder.append(" -> " + string2);
                }
                System.out.println("More than one text string can match snapshot: " + string + stringBuilder.toString());
            }
        }
    }
}

