/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.review;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowFactory;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.main.ModuleRightPanel;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.review.AddCaptureHelper;
import com.miui.theme.tool.review.BaseScreencapturePanel;
import com.miui.theme.tool.review.DownloadImageTask;
import com.miui.theme.tool.review.ReviewConfig;
import com.miui.theme.tool.review.ReviewFailHelper;
import com.miui.theme.tool.review.ReviewWebPanel;
import com.miui.theme.tool.review.TestScreencapturePanel;
import com.miui.theme.tool.review.ThemeTask;
import com.miui.theme.tool.review.UserScreenscapturePanel;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.InputStreamUtils;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.Screenshot;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.ToastPanel;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ReviewDetailPanel
extends ModuleRightPanel {
    public static String CAPTURE_URL_PRE = ReviewConfig.Test_DETAIL_DOMAIN + "/theme/screencapture/";
    public static String MI1V5MIDDLE = "/mi1-2/zh_CN/sanity/img_";
    public static String MI2V5MIDDLE = "/mi2-2/zh_CN/sanity/img_";
    public static String MI1V6MIDDLE = "/mi1-3/zh_CN/sanity/img_";
    public static String MI2V6MIDDLE = "/mi2-3/zh_CN/sanity/img_";
    public static HashMap<String, String> sUrlMiddle = new HashMap();
    public static HashMap<String, String> sFolderNameMap = new HashMap();
    ExecutorService mThreadPool = ReviewWebPanel.sThreadPool;
    public static String[] sResolutions;
    private String mCurrentResolution;
    private HashMap<String, TestScreencapturePanel> mTestScreencapturePanels = new HashMap();
    private HashMap<String, UserScreenscapturePanel> mUserScreencapturePanels = new HashMap();
    private HashMap<String, JScrollPane> mTestScrollPanes = new HashMap();
    private HashMap<String, JScrollPane> mUserScrollPanes = new HashMap();
    private ThemeTask mThemeTask;
    private JPanel mTabTitlePanel;
    private JLabel mTitleLabel;
    private CommonRightPanel mTabs;
    private CommonRightPanel mControlPanel;
    ImageIcon sPositiveNIcon = ResourceFactory.getInstance().getImageIcon("review/positive_btn_n.png");
    ImageIcon sPositivePIcon = ResourceFactory.getInstance().getImageIcon("review/positive_btn_p.png");
    ImageIcon sNegativeNIcon = ResourceFactory.getInstance().getImageIcon("review/negative_btn_n.png");
    ImageIcon sNegativePIcon = ResourceFactory.getInstance().getImageIcon("review/negative_btn_p.png");
    ImageIcon sDescriptNIcon = ResourceFactory.getInstance().getImageIcon("review/description_n.png");
    ImageIcon sDescriptPIcon = ResourceFactory.getInstance().getImageIcon("review/description_p.png");
    JButton mDescriptButton = GUIUtil.createTransparentButton(this.sDescriptNIcon, null, this.sDescriptPIcon, null);
    JButton mCaptureButton = GUIUtil.createTransparentButton(this.sPositiveNIcon, null, this.sPositivePIcon, null);
    JButton mApplyButton = GUIUtil.createTransparentButton(this.sPositiveNIcon, null, this.sPositivePIcon, null);
    JButton mReviewFailButton = GUIUtil.createTransparentButton(this.sNegativeNIcon, null, this.sNegativePIcon, null);
    JButton mReviewSuccessButton = GUIUtil.createTransparentButton(this.sPositiveNIcon, null, this.sPositivePIcon, null);
    JButton mReviewAddCaptureButton = GUIUtil.createTransparentButton(this.sPositiveNIcon, null, this.sPositivePIcon, null);
    private MouseAdapter mShowDescriptionListener = new MouseAdapter(){
        private JWebBrowserWindow mWebBrowserWindow;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ReviewDetailPanel.getWebWin(((ReviewDetailPanel)ReviewDetailPanel.this).mThemeTask.mCoverUrl);
        }
    };
    ActionListener mActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ReviewDetailPanel.this.mCaptureButton)) {
                ReviewDetailPanel.this.screenCapture();
            } else if (actionEvent.getSource().equals(ReviewDetailPanel.this.mReviewAddCaptureButton)) {
                String[] stringArray = ((ReviewDetailPanel)ReviewDetailPanel.this).mThemeTask.mCoverIds.split(";");
                AddCaptureHelper.addCaptures(stringArray);
            } else if (actionEvent.getSource().equals(ReviewDetailPanel.this.mApplyButton)) {
                ReviewDetailPanel.applyToPhone(((ReviewDetailPanel)ReviewDetailPanel.this).mThemeTask.mMtzPath);
            } else if (actionEvent.getSource().equals(ReviewDetailPanel.this.mReviewSuccessButton)) {
                try {
                    GUIUtil.toast(ReviewDetailPanel.this.reviewSuccess());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GUIUtil.toast(ResourceFactory.getString("Fail"));
                }
            } else if (actionEvent.getSource().equals(ReviewDetailPanel.this.mReviewFailButton)) {
                ReviewFailHelper.reviewFail(ReviewDetailPanel.this.mThemeTask, ReviewDetailPanel.this.getEditedFiles());
            }
        }
    };
    private HashMap<String, NinePBackgroundPanel> mResolutionTitles = new HashMap();

    public ReviewDetailPanel(ThemeTask themeTask) {
        this.mThemeTask = themeTask;
        if (themeTask.mType.contains("V6")) {
            sUrlMiddle.put("drawable-hdpi", MI1V6MIDDLE);
            sUrlMiddle.put("drawable-xhdpi", MI2V6MIDDLE);
        } else {
            sUrlMiddle.put("drawable-hdpi", MI1V5MIDDLE);
            sUrlMiddle.put("drawable-xhdpi", MI2V5MIDDLE);
        }
        for (String string : sResolutions) {
            this.mTestScreencapturePanels.put(string, new TestScreencapturePanel("drawable-hdpi"));
            this.mTestScrollPanes.put(string, new JScrollPane(this.mTestScreencapturePanels.get(string)));
            this.bind(this.mTestScreencapturePanels.get(string), this.mTestScrollPanes.get(string));
            this.mUserScreencapturePanels.put(string, new UserScreenscapturePanel("drawable-hdpi"));
            this.mUserScrollPanes.put(string, new JScrollPane(this.mUserScreencapturePanels.get(string)));
            this.bind(this.mUserScreencapturePanels.get(string), this.mUserScrollPanes.get(string));
        }
        double[][] dArrayArray = new double[][]{{-1.0, 500.0}, {67.0, -1.0, 46.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.initTabTitle();
        this.initImages();
        this.initControls();
        if (themeTask.mType.contains("aries")) {
            this.switchTab("drawable-xhdpi");
        } else if (themeTask.mType.contains("mione_plus")) {
            this.switchTab("drawable-hdpi");
        }
    }

    private void bind(BaseScreencapturePanel baseScreencapturePanel, JScrollPane jScrollPane) {
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(20);
    }

    public static JWebBrowserWindow getWebWin(String string) {
        JWebBrowser jWebBrowser = new JWebBrowser(new NSOption[0]);
        JWebBrowserWindow jWebBrowserWindow = WebBrowserWindowFactory.create(jWebBrowser);
        jWebBrowserWindow.getWebBrowser().navigate(string);
        jWebBrowserWindow.setVisible(true);
        return jWebBrowserWindow;
    }

    private void initControls() {
        double[][] dArrayArray = new double[][]{{10.0, 26.0, -1.0, 90.0, 15.0, 90.0, 43.0, 90.0, 15.0, 90.0, 43.0, 90.0, 15.0}, {10.0, -1.0, 10.0}};
        Vector<JButton> vector = new Vector<JButton>();
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mControlPanel = new CommonRightPanel();
        this.mControlPanel.setLayout(tableLayout);
        int n = 1;
        this.mDescriptButton.addMouseListener(this.mShowDescriptionListener);
        vector.add(this.mDescriptButton);
        this.mControlPanel.add((Component)this.mDescriptButton, n + ", 1");
        this.mCaptureButton.setText(ResourceFactory.getString("Capture"));
        vector.add(this.mCaptureButton);
        this.mControlPanel.add((Component)this.mCaptureButton, (n += 2) + ", 1");
        this.mApplyButton.setText(ResourceFactory.getString("ApplyTheme"));
        vector.add(this.mApplyButton);
        this.mControlPanel.add((Component)this.mApplyButton, (n += 2) + ", 1");
        this.mApplyButton.setEnabled(ReviewConfig.isThemeDownloaded(this.mThemeTask.mID));
        this.mReviewFailButton.setText(ResourceFactory.getString("ReviewFail"));
        vector.add(this.mReviewFailButton);
        this.mControlPanel.add((Component)this.mReviewFailButton, (n += 2) + ", 1");
        this.mReviewSuccessButton.setText(ResourceFactory.getString("ReviewSuccess"));
        vector.add(this.mReviewSuccessButton);
        this.mControlPanel.add((Component)this.mReviewSuccessButton, (n += 2) + ", 1");
        this.mReviewAddCaptureButton.setText(ResourceFactory.getString("ReviewAddCapture"));
        vector.add(this.mReviewAddCaptureButton);
        this.mControlPanel.add((Component)this.mReviewAddCaptureButton, (n += 2) + ", 1");
        for (JButton jButton : vector) {
            this.processButton(jButton);
            jButton.addActionListener(this.mActionListener);
        }
        this.add((Component)this.mControlPanel, "0,2, 1, 2");
    }

    private static synchronized void applyToPhone(final String string) {
        final ToastPanel toastPanel = GUIUtil.toastEver(ResourceFactory.getString("Applying"));
        new Thread(){

            @Override
            public void run() {
                String string2 = ThemeHelper.getUserDir();
                string2 = OS.getOS() == 1 ? string2 + File.separator + "tools" + File.separator + "adb.exe" : (OS.getOS() == 3 ? string2 + File.separator + "tools" + File.separator + "adb-mac" : string2 + File.separator + "tools" + File.separator + "adb");
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge((String)string2, (boolean)false);
                int n = 0;
                while (!androidDebugBridge.hasInitialDeviceList()) {
                    try {
                        Thread.sleep(100L);
                        ++n;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n <= 100) continue;
                    GUIUtil.showResult(false);
                    return;
                }
                boolean bl = true;
                for (IDevice iDevice : androidDebugBridge.getDevices()) {
                    if (!iDevice.isOnline()) continue;
                    bl = CmdUtils.adb_push_MIUIThemeToolGenerated(iDevice.getSerialNumber(), string);
                    if (bl) {
                        CmdUtils.adb_shell_applyTheme(iDevice.getSerialNumber(), true, 0L);
                        continue;
                    }
                    bl = false;
                    break;
                }
                toastPanel.hideToast();
                GUIUtil.showResult(bl);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String reviewSuccess() throws Exception {
        try (CloseableHttpClient closeableHttpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)ReviewConfig.getCookieStore()).build();){
            HttpPost httpPost = new HttpPost(ReviewWebPanel.REVIEW_ROOT + "/theme/audit/mtzAudit");
            HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("auditIds", (ContentBody)new StringBody(this.mThemeTask.mCoverIds, ContentType.TEXT_PLAIN)).addPart("auditActionType", (ContentBody)new StringBody("approve", ContentType.TEXT_PLAIN)).addPart("editorRating", (ContentBody)new StringBody("0", ContentType.TEXT_PLAIN)).build();
            httpPost.setEntity(httpEntity);
            System.out.println("executing request " + httpPost.getRequestLine());
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                System.out.println("----------------------------------------");
                System.out.println(closeableHttpResponse.getStatusLine());
                HttpEntity httpEntity2 = closeableHttpResponse.getEntity();
                if (httpEntity2 != null) {
                    String string = InputStreamUtils.InputStreamTOString(httpEntity2.getContent(), "utf8");
                    Log.l(string);
                    if (string.contains("ok")) {
                        ReviewWebPanel.sDeleteQueue.add(this.mThemeTask.mTestDetailUrl);
                        String string2 = ResourceFactory.getString("Success");
                        return string2;
                    }
                    String string3 = string.replace("{\"S\":\"", "").replace("\"}", "");
                    return string3;
                }
            }
        }
        return ResourceFactory.getString("Fail");
    }

    protected Vector<String> getEditedFiles() {
        Vector<String> vector = new Vector<String>();
        for (String string : sResolutions) {
            vector.addAll(this.mTestScreencapturePanels.get(string).getEditedFiles());
            vector.addAll(this.mUserScreencapturePanels.get(string).getEditedFiles());
        }
        return vector;
    }

    private void screenCapture() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        String string = this.getUserScreencapturePath();
        File file = new File(string);
        file.mkdirs();
        String string2 = string + File.separator + this.mCurrentResolution + File.separator + simpleDateFormat.format(calendar.getTime()) + ".png";
        try {
            Screenshot.captureScreen(string2);
            GUIUtil.toastLong(string2);
            File file2 = new File(string2);
            if (file2.exists()) {
                this.mUserScreencapturePanels.get(this.mCurrentResolution).addImage(new String[]{file2.getAbsolutePath()});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUIUtil.toastLong(ResourceFactory.getString("Fail"));
        }
    }

    private String getUserScreencapturePath() {
        return this.getLocalPath() + File.separator + "screenshot";
    }

    private void processButton(JButton jButton) {
        jButton.setHorizontalTextPosition(0);
        jButton.setForeground(Color.WHITE);
    }

    private void initTabTitle() {
        this.mTabTitlePanel = new CommonRightPanel();
        double[][] dArrayArray = new double[][]{{-1.0, 260.0, -1.0}, {10.0, 20.0, 10.0, -1.0, 2.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mTabTitlePanel.setLayout(tableLayout);
        this.mTitleLabel = new JLabel(this.mThemeTask.mTitle);
        this.mTitleLabel.setHorizontalAlignment(0);
        this.mTitleLabel.setForeground(GUIUtil.hex2color("#b7b9bc"));
        this.mTabTitlePanel.add((Component)this.mTitleLabel, "1, 1");
        this.initTabs();
        this.add((Component)this.mTabTitlePanel, "0, 0, 1, 0");
    }

    private void initTabs() {
        double[][] dArrayArray = new double[][]{{-1.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mTabs = new CommonRightPanel();
        this.mTabs.setLayout(tableLayout);
        int n = 0;
        for (String string : sResolutions) {
            NinePBackgroundPanel ninePBackgroundPanel = new NinePBackgroundPanel();
            GUIUtil.hand(ninePBackgroundPanel);
            this.mResolutionTitles.put(string, ninePBackgroundPanel);
            ninePBackgroundPanel.setName(string);
            ninePBackgroundPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    super.mouseClicked(mouseEvent);
                    NinePBackgroundPanel ninePBackgroundPanel = (NinePBackgroundPanel)mouseEvent.getSource();
                    ReviewDetailPanel.this.switchTab(ninePBackgroundPanel.getName());
                }
            });
            ninePBackgroundPanel.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(sFolderNameMap.get(string));
            jLabel.setHorizontalAlignment(0);
            jLabel.setForeground(GUIUtil.hex2color("#616162"));
            ninePBackgroundPanel.add((Component)jLabel, "Center");
            tableLayout.insertColumn(n, -1.0);
            tableLayout.insertColumn(++n, -1.0);
            this.mTabs.add((Component)ninePBackgroundPanel, ++n - 2 + ", 0");
        }
        this.mTabTitlePanel.add((Component)this.mTabs, "1, 3");
    }

    private void switchTab(String string) {
        this.mCurrentResolution = string;
        for (String string2 : this.mResolutionTitles.keySet()) {
            if (this.mResolutionTitles.get(string2).getName().equals(string)) {
                this.mResolutionTitles.get(string2).setNinePBackground("review/tab_actived.9.png");
            } else {
                this.mResolutionTitles.get(string2).clearNinePBackground();
            }
            this.mResolutionTitles.get(string2).repaint();
        }
        for (String string3 : sResolutions) {
            this.remove(this.mTestScrollPanes.get(string3));
            this.remove(this.mUserScrollPanes.get(string3));
        }
        this.add((Component)this.mTestScrollPanes.get(string), "0, 1");
        this.add((Component)this.mUserScrollPanes.get(string), "1, 1");
        this.validate();
        this.repaint();
    }

    private void initImages() {
        this.mThreadPool.submit(new LoadTestImages("drawable-hdpi"));
        this.mThreadPool.submit(new LoadTestImages("drawable-xhdpi"));
        this.mThreadPool.submit(new LoadUserImages("drawable-hdpi"));
        this.mThreadPool.submit(new LoadUserImages("drawable-xhdpi"));
    }

    private String getLocalPath() {
        return this.mThemeTask.getLocalPath();
    }

    static {
        sFolderNameMap.put("drawable-hdpi", "480P");
        sFolderNameMap.put("drawable-xhdpi", "720P");
        sFolderNameMap.put("drawable-xxhdpi", "1080P");
        sResolutions = new String[]{"drawable-hdpi", "drawable-xhdpi"};
    }

    class LoadTestImages
    extends Thread {
        private String mResolution;

        public LoadTestImages(String string) {
            this.mResolution = string;
        }

        @Override
        public void run() {
            String string = ReviewDetailPanel.this.getLocalPath() + File.separator + "TestScreenapture" + File.separator + this.mResolution;
            new File(string).mkdirs();
            String string2 = CAPTURE_URL_PRE + ((ReviewDetailPanel)ReviewDetailPanel.this).mThemeTask.mID + sUrlMiddle.get(this.mResolution);
            for (int i = 0; i < BaseScreencapturePanel.CAPTURE_IMAGE_SIZE; ++i) {
                int n = i + 1;
                String string3 = string + File.separator + n + ".png";
                String string4 = string2 + n + ".png";
                File file = new File(string3);
                try {
                    DownloadImageTask downloadImageTask = new DownloadImageTask(string4);
                    if (!file.exists() || file.length() != (long)downloadImageTask.getFileSize()) {
                        file.getParentFile().mkdirs();
                        downloadImageTask.setDestFileStream(new FileOutputStream(file));
                        downloadImageTask.setDownloadProgressListener(new TestDownloadListener(i, string3));
                        ReviewDetailPanel.this.mThreadPool.submit(downloadImageTask);
                        continue;
                    }
                    this.loadCaptureImage(i, string3);
                    continue;
                }
                catch (IOException iOException) {
                    Log.l(string4 + " not exists!");
                    if (file.exists()) {
                        this.loadCaptureImage(i, string3);
                        continue;
                    }
                    this.loadCaptureImage(i, BaseScreencapturePanel.sLoadFailImage);
                }
            }
        }

        public void loadCaptureImage(int n, String string) {
            ((TestScreencapturePanel)ReviewDetailPanel.this.mTestScreencapturePanels.get(this.mResolution)).setImage(n, string);
        }

        public void loadCaptureImage(int n, BufferedImage bufferedImage) {
            ((TestScreencapturePanel)ReviewDetailPanel.this.mTestScreencapturePanels.get(this.mResolution)).setImage(n, bufferedImage);
        }

        class TestDownloadListener
        implements DownloadProgressListener {
            private int mIndex;
            private String mPath;

            public TestDownloadListener(int n, String string) {
                this.mIndex = n;
                this.mPath = string;
            }

            @Override
            public void progress(long l, long l2) {
            }

            @Override
            public void cancelled() {
            }

            @Override
            public void done(Object object) {
                LoadTestImages.this.loadCaptureImage(this.mIndex, this.mPath);
            }
        }
    }

    class LoadUserImages
    extends Thread {
        private String mResolution;

        public LoadUserImages(String string) {
            this.mResolution = string;
        }

        @Override
        public void run() {
            File file = new File(ReviewDetailPanel.this.getUserScreencapturePath() + File.separator + this.mResolution);
            Log.l(file.getAbsolutePath());
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getAbsolutePath();
            }
            ((UserScreenscapturePanel)ReviewDetailPanel.this.mUserScreencapturePanels.get(this.mResolution)).addImage(stringArray);
        }
    }
}

