/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.gui.NinePPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class ToastPanel
extends NinePPanel {
    public final int HEIGHT = 40;
    public final int WIDTH = 76;
    public int mWidth;
    private JLabel mLabel;
    private JLabel mConfirmLabel;
    private MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            ToastPanel.this.mPopup.hide();
        }
    };
    private Popup mPopup;
    private String mText;
    CounterThread mTThread;
    public static int LONG = 5000;
    public static int SHORT = 3000;
    public static int EVER = -1;
    private static volatile ToastPanel single;
    private Timer mTimer;

    protected ToastPanel() {
        this.init();
    }

    protected ToastPanel(String string) {
        this.init();
        this.setMessage(string);
    }

    public void setMessage(String string) {
        this.mText = string;
        this.mLabel = new JLabel(string);
        int n = this.getFontMetrics(this.getFont()).stringWidth(string + " (0000m00s)");
        this.mWidth = 76 + n;
        this.initLayout(n);
    }

    private void init() {
        this.setNinePBackground("util/toast_bg.9.png");
        this.mConfirmLabel = new JLabel(ResourceFactory.getString("GotIt"));
        this.mConfirmLabel.setForeground(GUIUtil.hex2color("#5384d6"));
        this.mConfirmLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mConfirmLabel.addMouseListener(this.mMouseListener);
    }

    private void initLayout(int n) {
        double[][] dArrayArray = new double[][]{{16.0, n, 10.0, 40.0, 10.0}, {40.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mLabel, "1, 0");
        this.add((Component)this.mConfirmLabel, "3, 0");
    }

    public void showToast() {
        this.showToast(SHORT);
    }

    public void hideToast() {
        this.mPopup.hide();
        if (this.mTThread != null) {
            this.mTThread.mStopFlag = true;
        }
        NewMainFrame.getInstance().repaint();
    }

    public void showToast(int n) {
        this.setNewCount();
        this.setNewTimer(n);
        NewMainFrame newMainFrame = NewMainFrame.getInstance();
        Rectangle rectangle = newMainFrame.getMinBounds();
        rectangle.x = rectangle.x + rectangle.width - this.mWidth;
        rectangle.y = rectangle.y + rectangle.height - 40 - 7;
        if (ThemeHelper.isReviewMode()) {
            rectangle.y -= 40;
        }
        System.out.println(rectangle);
        this.mPopup = PopupFactory.getSharedInstance().getPopup(newMainFrame, this, rectangle.x, rectangle.y);
        this.mPopup.show();
    }

    private void setNewTimer(int n) {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        if (n == EVER) {
            return;
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ToastPanel.this.hideToast();
            }
        }, n);
    }

    private void setNewCount() {
        if (this.mTThread != null) {
            this.mTThread.mStopFlag = true;
        }
        this.mTThread = new CounterThread();
        this.mTThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToastPanel getInstance() {
        if (single != null) return single;
        Class<ToastPanel> clazz = ToastPanel.class;
        synchronized (ToastPanel.class) {
            if (single != null) return single;
            single = new ToastPanel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    class CounterThread
    extends Thread {
        int mCount = 0;
        boolean mStopFlag = false;

        CounterThread() {
        }

        @Override
        public void run() {
            while (!this.mStopFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.mCount;
                String string = "";
                string = this.mCount >= 60 ? " (" + this.mCount / 60 + "m" + this.mCount % 60 + "s" + ")" : " (" + this.mCount + "s)";
                ToastPanel.this.mLabel.setText(ToastPanel.this.mText + string);
            }
        }
    }
}

